/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pastedlg.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:45:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef WNT
#include <tools/prewin.h>
#include <windows.h>
#include <ole2.h>
#include <tools/postwin.h>
#endif

#include <pastedlg.hxx>
#include <svtools/svmedit.hxx>
#include <svtools/transfer.hxx>
#include <vcl/dialog.hxx>
#include <vcl/button.hxx>
#include <vcl/fixed.hxx>
#include <vcl/group.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/msgbox.hxx>
#include <svuidlg.hxx>
#include <svuidlg.hrc>
#include <embobj.hxx>
#include <sot/formats.hxx>
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif
#include <sot/stg.hxx>
#pragma hdrstop


#include "helpid.hrc"

//---------------------------------------------
// this struct conforms to the Microsoft
// OBJECTDESCRIPTOR -> see oleidl.h
// (MS platform sdk)
//---------------------------------------------

struct OleObjectDescriptor
{
	sal_uInt32	cbSize;
	ClsId		clsid;
	sal_uInt32	dwDrawAspect;
	Size		sizel;
	Point		pointl;
	sal_uInt32	dwStatus;
	sal_uInt32	dwFullUserTypeName;
	sal_uInt32	dwSrcOfCopy;
};

class MdPasteObject;

/********************** SvPasteDlg ****************************************
**************************************************************************/
class SvPasteDlg : public MdPasteObject
{
public:
	SvPasteDlg( Window * pParent );

	ListBox&		ObjectLB()		{ return aLbInsertList; }
	FixedText&		ObjectSource()	{ return aFtObjectSource; }
	RadioButton&	PasteLink()		{ return aRbPasteLink; }
	CheckBox&		AsIconBox()		{ return aCbDisplayAsIcon; }

	const String& 	GetObjString()	{ return aSObject; }
	void			SelectObject();

private:
	DECL_LINK( SelectHdl, ListBox * );
	DECL_LINK( DoubleClickHdl, ListBox * );
};

SvPasteDlg::SvPasteDlg( Window* pParent ) :

	MdPasteObject( pParent, ResId( MD_PASTE_OBJECT, SOAPP->GetResMgr() ) )
{
	SetHelpId( HID_PASTE_DLG );
	SetUniqueId( HID_PASTE_DLG );

	Font aFont = aFtObjectSource.GetFont();
	aFont.SetWeight( WEIGHT_LIGHT );
	aFtObjectSource.SetFont( aFont );
	aOKButton1.Disable();

	ObjectLB().SetSelectHdl( LINK( this, SvPasteDlg, SelectHdl ) );
	ObjectLB().SetDoubleClickHdl( LINK( this, SvPasteDlg, DoubleClickHdl ) );
}

void SvPasteDlg::SelectObject()
{
	if ( aLbInsertList.GetEntryCount() &&
		 !aRbPaste.IsVisible() && !aRbPasteLink.IsVisible() )
	{
		aLbInsertList.SelectEntryPos(0);
		SelectHdl( &aLbInsertList );
	}
}

IMPL_LINK( SvPasteDlg, SelectHdl, ListBox *, pListBox )
{
	if ( !aOKButton1.IsEnabled() )
		aOKButton1.Enable();
	return 0;
}

IMPL_LINK_INLINE_START( SvPasteDlg, DoubleClickHdl, ListBox *, pListBox )
{
	EndDialog( RET_OK );
	return 0;
}
IMPL_LINK_INLINE_END( SvPasteDlg, DoubleClickHdl, ListBox *, pListBox )

/********************** SvPasteObjectDialog ******************************
**************************************************************************/
/*************************************************************************
|*    SvPasteObjectDialog::SvPasteObjectDialog()
|*
|*    Beschreibung
|*    Ersterstellung    MM 14.06.94
|*    Letzte Aenderung  MM 14.06.94
*************************************************************************/
void SvPasteObjectDialog::SetDefault()
{
	bLink   = FALSE;
	nAspect = ASPECT_CONTENT;
}

SvPasteObjectDialog::SvPasteObjectDialog()
{
	SetDefault();
}
SvPasteObjectDialog::~SvPasteObjectDialog()
{
	void * pStr = aSupplementTable.First();
	while( pStr )
	{
		delete (String *)pStr;
		pStr = aSupplementTable.Next();
	}
}

/*************************************************************************
|*    SvPasteObjectDialog::Insert()
|*
|*    Beschreibung
|*    Ersterstellung    MM 14.06.94
|*    Letzte Aenderung  KA 16.03.2001
*************************************************************************/
void SvPasteObjectDialog::Insert( SotFormatStringId nFormat, const String& rFormatName )
{
	String * pStr = new String( rFormatName );
	if( !aSupplementTable.Insert( nFormat, pStr ) )
		delete pStr;
}

// -----------------------------------------------------------------------------


/*************************************************************************
|*    SvPasteObjectDialog::Execute()
|*
|*    Beschreibung
|*    Ersterstellung    MM 14.06.94
|*    Letzte Aenderung  KA 16.03.2001
*************************************************************************/

ULONG SvPasteObjectDialog::Execute( Window* pParent,
		const ::com::sun::star::uno::Reference<
		::com::sun::star::datatransfer::XTransferable >& rxTransferable )
{
	TransferableDataHelper aHelper( rxTransferable );
//	TransferableObjectDescriptor aDesc;

//      if( aHelper.HasFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ) )
//  	    aHelper.GetTransferableObjectDescriptor( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR, aDesc );

	return Execute( pParent,  aHelper );
}

ULONG SvPasteObjectDialog::Execute( Window* pParent,
								const DataFlavorExVector& rFormats,
								const TransferableObjectDescriptor& rDesc )
{
	//Dialogbox erzeugen und fuellen
	SvPasteDlg*	pDlg = new SvPasteDlg( pParent );
	String aSourceName, aTypeName;
	ULONG nSelFormat = 0;
	SvGlobalName aEmptyNm;

	pDlg->ObjectLB().SetUpdateMode( FALSE );

	DataFlavorExVector::iterator aIter( ((DataFlavorExVector&)rFormats).begin() ),
								 aEnd( ((DataFlavorExVector&)rFormats).end() );
	while( aIter != aEnd )
	{
		::com::sun::star::datatransfer::DataFlavor aFlavor( *aIter );
		SotFormatStringId nFormat = (*aIter++).mnSotId;

		String*	pName = (String*) aSupplementTable.Get( nFormat );
		String aName;

#ifdef WNT
/*
		if( !pName &&
			( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE_OLE || nFormat == SOT_FORMATSTR_ID_EMBEDDED_OBJ_OLE ) )
		{
			BOOL IsClipboardObject_Impl( SotDataObject * );
			if( IsClipboardObject_Impl( pDataObj ) )
			{
				IDataObject * pDO = NULL;
				OleGetClipboard( &pDO );
				if( pDO )
				{
					FORMATETC fe;
					STGMEDIUM stm;
					(fe).cfFormat=RegisterClipboardFormat( "Object Descriptor" );
					(fe).dwAspect=DVASPECT_CONTENT;
					(fe).ptd=NULL;
					(fe).tymed=TYMED_HGLOBAL;
					(fe).lindex=-1;

					if (SUCCEEDED(pDO->GetData(&fe, &stm)))
					{
						LPOBJECTDESCRIPTOR pOD=(LPOBJECTDESCRIPTOR)GlobalLock(stm.hGlobal);
						if( pOD->dwFullUserTypeName )
						{
							OLECHAR * pN = (OLECHAR *)(((BYTE *)pOD) + pOD->dwFullUserTypeName);
							aName.Append( pN );
							pName = &aName;
							// set format to ole object
							nFormat = SOT_FORMATSTR_ID_EMBED_SOURCE_OLE;
						}
						if( pOD->dwSrcOfCopy )
						{
							OLECHAR * pN = (OLECHAR *)(((BYTE *)pOD) + pOD->dwSrcOfCopy);
							aSourceName.Append( *pN++ );
						}
						else
							aSourceName = String( ResId( STR_UNKNOWN_SOURCE, SOAPP->GetResMgr() ) );
						GlobalUnlock(stm.hGlobal);
						ReleaseStgMedium(&stm);
					}
				}
			}
		}
*/
#endif

		if( pName )
		{
			aName = *pName;

			if( SOT_FORMATSTR_ID_EMBED_SOURCE == nFormat )
			{
				if( rDesc.maClassName != aEmptyNm )
				{
					aSourceName = rDesc.maDisplayName;

					if( rDesc.maClassName == aObjClassName )
						aName = aObjName;
					else
						aName = aTypeName = rDesc.maTypeName;
				}
			}
			else if( SOT_FORMATSTR_ID_LINK_SOURCE == nFormat )
			{
				pDlg->PasteLink().Enable();
				continue;
			}
			else if( !aName.Len() )
				aName = aFlavor.HumanPresentableName;

			if( LISTBOX_ENTRY_NOTFOUND == pDlg->ObjectLB().GetEntryPos( aName ) )
				pDlg->ObjectLB().SetEntryData(
					pDlg->ObjectLB().InsertEntry( aName ), (void*) nFormat );
		}
	}

	if( !aTypeName.Len() && !aSourceName.Len() )
	{
		if( rDesc.maClassName != aEmptyNm )
		{
			aSourceName = rDesc.maDisplayName;
			aTypeName = rDesc.maTypeName;
		}

		if( !aTypeName.Len() && !aSourceName.Len() )
			aSourceName = String( ResId( STR_UNKNOWN_SOURCE, SOAPP->GetResMgr() ) );
	}

	pDlg->ObjectLB().SetUpdateMode( TRUE );
	pDlg->SelectObject();

	if( aSourceName.Len() )
	{
		if( aTypeName.Len() )
			aTypeName += '\n';

		aTypeName += aSourceName;
		aTypeName.ConvertLineEnd();
	}

	pDlg->ObjectSource().SetText( aTypeName );

	SetDefault();

	if( pDlg->Execute() )
	{
		bLink = pDlg->PasteLink().IsChecked();

		if( pDlg->AsIconBox().IsChecked() )
			nAspect = ASPECT_ICON;

		nSelFormat  = (ULONG)pDlg->ObjectLB().GetEntryData( pDlg->ObjectLB().GetSelectEntryPos() );
	}

	delete pDlg;

	return nSelFormat;
}

ULONG SvPasteObjectDialog::Execute( Window* pParent,
									TransferableDataHelper& rHelper )
{
	TransferableObjectDescriptor aDesc;
	return Execute( pParent, rHelper.GetDataFlavorExVector(),
					 aDesc, rHelper );
}


ULONG SvPasteObjectDialog::Execute( Window* pParent,
									const DataFlavorExVector& rFormats,
						 			const TransferableObjectDescriptor& ,
						 			const TransferableDataHelper& rHelper)
{
	TransferableObjectDescriptor aDesc;
    if( rHelper.HasFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ) )
	    ((TransferableDataHelper&)rHelper).GetTransferableObjectDescriptor(
								SOT_FORMATSTR_ID_OBJECTDESCRIPTOR, aDesc );

	//Dialogbox erzeugen und fuellen
	SvPasteDlg*	pDlg = new SvPasteDlg( pParent );
	String aSourceName, aTypeName;
	ULONG nSelFormat = 0;
	SvGlobalName aEmptyNm;

	pDlg->ObjectLB().SetUpdateMode( FALSE );

	DataFlavorExVector::iterator aIter( ((DataFlavorExVector&)rFormats).begin() ),
								 aEnd( ((DataFlavorExVector&)rFormats).end() );
	while( aIter != aEnd )
	{
		::com::sun::star::datatransfer::DataFlavor aFlavor( *aIter );
		SotFormatStringId nFormat = (*aIter++).mnSotId;

		String*	pName = (String*) aSupplementTable.Get( nFormat );
		String aName;

		// if there is an "Embed Source" or and "Embedded Object" on the
		// Clipboard we read the Description and the Source of this object
		// from an accompanied "Object Descriptor" format on the clipboard
		// Remember: these formats mostly appear together on the clipboard
		if ( !pName )
		{
			SvPasteObjectDialog::GetEmbeddedName(rHelper,aName,aSourceName,nFormat);
			if ( aName.Len() )
				pName = &aName;
		}


		if( pName )
		{
			aName = *pName;

			if( SOT_FORMATSTR_ID_EMBED_SOURCE == nFormat )
			{
				if( aDesc.maClassName != aEmptyNm )
				{
					aSourceName = aDesc.maDisplayName;

					if( aDesc.maClassName == aObjClassName )
						aName = aObjName;
					else
						aName = aTypeName = aDesc.maTypeName;
				}
			}
			else if( SOT_FORMATSTR_ID_LINK_SOURCE == nFormat )
			{
				pDlg->PasteLink().Enable();
				continue;
			}
			else if( !aName.Len() )
				aName = GetSotFormatUIName( nFormat );

			if( LISTBOX_ENTRY_NOTFOUND == pDlg->ObjectLB().GetEntryPos( aName ) )
				pDlg->ObjectLB().SetEntryData(
					pDlg->ObjectLB().InsertEntry( aName ), (void*) nFormat );
		}
	}

	if( !aTypeName.Len() && !aSourceName.Len() )
	{
		if( aDesc.maClassName != aEmptyNm )
		{
			aSourceName = aDesc.maDisplayName;
			aTypeName = aDesc.maTypeName;
		}

		if( !aTypeName.Len() && !aSourceName.Len() )
			aSourceName = String( ResId( STR_UNKNOWN_SOURCE, SOAPP->GetResMgr() ) );
	}

	pDlg->ObjectLB().SetUpdateMode( TRUE );
	pDlg->SelectObject();

	if( aSourceName.Len() )
	{
		if( aTypeName.Len() )
			aTypeName += '\n';

		aTypeName += aSourceName;
		aTypeName.ConvertLineEnd();
	}

	pDlg->ObjectSource().SetText( aTypeName );

	SetDefault();

	if( pDlg->Execute() )
	{
		bLink = pDlg->PasteLink().IsChecked();

		if( pDlg->AsIconBox().IsChecked() )
			nAspect = ASPECT_ICON;

		nSelFormat  = (ULONG)pDlg->ObjectLB().GetEntryData( pDlg->ObjectLB().GetSelectEntryPos() );
	}

	delete pDlg;

	return nSelFormat;
}

// -----------------------------------------------------------------------------

String SvPasteObjectDialog::GetSotFormatUIName( SotFormatStringId nId )
{
    struct SotResourcePair
    {
        SotFormatStringId   mnSotId;
        USHORT              mnResId;
    };

    static const SotResourcePair aSotResourcePairs[] =
    {
        { SOT_FORMAT_STRING,                    STR_FORMAT_STRING },
        { SOT_FORMAT_BITMAP,                    STR_FORMAT_BITMAP },
        { SOT_FORMAT_GDIMETAFILE,               STR_FORMAT_GDIMETAFILE },
        { SOT_FORMAT_RTF,                       STR_FORMAT_RTF },
        { SOT_FORMATSTR_ID_DRAWING,             STR_FORMAT_ID_DRAWING },
        { SOT_FORMATSTR_ID_SVXB,                STR_FORMAT_ID_SVXB },
        { SOT_FORMATSTR_ID_INTERNALLINK_STATE,  STR_FORMAT_ID_INTERNALLINK_STATE },
        { SOT_FORMATSTR_ID_SOLK,                STR_FORMAT_ID_SOLK },
        { SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK,   STR_FORMAT_ID_NETSCAPE_BOOKMARK },
        { SOT_FORMATSTR_ID_STARSERVER,          STR_FORMAT_ID_STARSERVER },
        { SOT_FORMATSTR_ID_STAROBJECT,          STR_FORMAT_ID_STAROBJECT },
        { SOT_FORMATSTR_ID_APPLETOBJECT,        STR_FORMAT_ID_APPLETOBJECT },
        { SOT_FORMATSTR_ID_PLUGIN_OBJECT,       STR_FORMAT_ID_PLUGIN_OBJECT },
        { SOT_FORMATSTR_ID_STARWRITER_30,       STR_FORMAT_ID_STARWRITER_30 },
        { SOT_FORMATSTR_ID_STARWRITER_40,       STR_FORMAT_ID_STARWRITER_40 },
        { SOT_FORMATSTR_ID_STARWRITER_50,       STR_FORMAT_ID_STARWRITER_50 },
        { SOT_FORMATSTR_ID_STARWRITERWEB_40,    STR_FORMAT_ID_STARWRITERWEB_40 },
        { SOT_FORMATSTR_ID_STARWRITERWEB_50,    STR_FORMAT_ID_STARWRITERWEB_50 },
        { SOT_FORMATSTR_ID_STARWRITERGLOB_40,   STR_FORMAT_ID_STARWRITERGLOB_40 },
        { SOT_FORMATSTR_ID_STARWRITERGLOB_50,   STR_FORMAT_ID_STARWRITERGLOB_50 },
        { SOT_FORMATSTR_ID_STARDRAW,            STR_FORMAT_ID_STARDRAW },
        { SOT_FORMATSTR_ID_STARDRAW_40,         STR_FORMAT_ID_STARDRAW_40 },
        { SOT_FORMATSTR_ID_STARIMPRESS_50,      STR_FORMAT_ID_STARIMPRESS_50 },
        { SOT_FORMATSTR_ID_STARDRAW_50,         STR_FORMAT_ID_STARDRAW_50 },
        { SOT_FORMATSTR_ID_STARCALC,            STR_FORMAT_ID_STARCALC },
        { SOT_FORMATSTR_ID_STARCALC_40,         STR_FORMAT_ID_STARCALC_40 },
        { SOT_FORMATSTR_ID_STARCALC_50,         STR_FORMAT_ID_STARCALC_50 },
        { SOT_FORMATSTR_ID_STARCHART,           STR_FORMAT_ID_STARCHART },
        { SOT_FORMATSTR_ID_STARCHART_40,        STR_FORMAT_ID_STARCHART_40 },
        { SOT_FORMATSTR_ID_STARCHART_50,        STR_FORMAT_ID_STARCHART_50 },
        { SOT_FORMATSTR_ID_STARIMAGE,           STR_FORMAT_ID_STARIMAGE },
        { SOT_FORMATSTR_ID_STARIMAGE_40,        STR_FORMAT_ID_STARIMAGE_40 },
        { SOT_FORMATSTR_ID_STARIMAGE_50,        STR_FORMAT_ID_STARIMAGE_50 },
        { SOT_FORMATSTR_ID_STARMATH,            STR_FORMAT_ID_STARMATH },
        { SOT_FORMATSTR_ID_STARMATH_40,         STR_FORMAT_ID_STARMATH_40 },
        { SOT_FORMATSTR_ID_STARMATH_50,         STR_FORMAT_ID_STARMATH_50 },
        { SOT_FORMATSTR_ID_STAROBJECT_PAINTDOC, STR_FORMAT_ID_STAROBJECT_PAINTDOC },
        { SOT_FORMATSTR_ID_HTML,                STR_FORMAT_ID_HTML },
        { SOT_FORMATSTR_ID_HTML_SIMPLE,         STR_FORMAT_ID_HTML_SIMPLE },
        { SOT_FORMATSTR_ID_BIFF_5,              STR_FORMAT_ID_BIFF_5 },
        { SOT_FORMATSTR_ID_BIFF_8,              STR_FORMAT_ID_BIFF_8 },
        { SOT_FORMATSTR_ID_SYLK,                STR_FORMAT_ID_SYLK },
        { SOT_FORMATSTR_ID_LINK,                STR_FORMAT_ID_LINK },
        { SOT_FORMATSTR_ID_DIF,                 STR_FORMAT_ID_DIF },
        { SOT_FORMATSTR_ID_MSWORD_DOC,          STR_FORMAT_ID_MSWORD_DOC },
        { SOT_FORMATSTR_ID_STAR_FRAMESET_DOC,   STR_FORMAT_ID_STAR_FRAMESET_DOC },
        { SOT_FORMATSTR_ID_OFFICE_DOC,          STR_FORMAT_ID_OFFICE_DOC },
        { SOT_FORMATSTR_ID_NOTES_DOCINFO,       STR_FORMAT_ID_NOTES_DOCINFO },
        { SOT_FORMATSTR_ID_SFX_DOC,             STR_FORMAT_ID_SFX_DOC },
        { SOT_FORMATSTR_ID_STARCHARTDOCUMENT_50,STR_FORMAT_ID_STARCHARTDOCUMENT_50 },
        { SOT_FORMATSTR_ID_GRAPHOBJ,            STR_FORMAT_ID_GRAPHOBJ },
        { SOT_FORMATSTR_ID_STARWRITER_60,       STR_FORMAT_ID_STARWRITER_60 },
        { SOT_FORMATSTR_ID_STARWRITERWEB_60,    STR_FORMAT_ID_STARWRITERWEB_60 },
        { SOT_FORMATSTR_ID_STARWRITERGLOB_60,   STR_FORMAT_ID_STARWRITERGLOB_60 },
        { SOT_FORMATSTR_ID_STARDRAW_60,         STR_FORMAT_ID_STARDRAW_60 },
        { SOT_FORMATSTR_ID_STARIMPRESS_60,      STR_FORMAT_ID_STARIMPRESS_60 },
        { SOT_FORMATSTR_ID_STARCALC_60,         STR_FORMAT_ID_STARCALC_60 },
        { SOT_FORMATSTR_ID_STARCHART_60,        STR_FORMAT_ID_STARCHART_60 },
        { SOT_FORMATSTR_ID_STARMATH_60,         STR_FORMAT_ID_STARMATH_60 },
        { SOT_FORMATSTR_ID_WMF,                 STR_FORMAT_ID_WMF },
        { SOT_FORMATSTR_ID_DBACCESS_QUERY,      STR_FORMAT_ID_DBACCESS_QUERY },
        { SOT_FORMATSTR_ID_DBACCESS_TABLE,      STR_FORMAT_ID_DBACCESS_TABLE },
        { SOT_FORMATSTR_ID_DBACCESS_COMMAND,    STR_FORMAT_ID_DBACCESS_COMMAND },
        { SOT_FORMATSTR_ID_DIALOG_60,           STR_FORMAT_ID_DIALOG_60 },
        { SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR,   STR_FORMAT_ID_FILEGRPDESCRIPTOR },
        { SOT_FORMATSTR_ID_HTML_NO_COMMENT,     STR_FORMAT_ID_HTML_NO_COMMENT }
    };

    String aUIName;
    USHORT nResId = 0;

    for( sal_uInt32 i = 0, nCount = sizeof( aSotResourcePairs ) / sizeof( aSotResourcePairs[ 0 ] ); ( i < nCount ) && !nResId; i++ )
    {
        if( aSotResourcePairs[ i ].mnSotId == nId )
            nResId = aSotResourcePairs[ i ].mnResId;
    }

    if( nResId )
        aUIName = String( ResId( nResId, SOAPP->GetResMgr() ) );
    else
        aUIName = SotExchange::GetFormatName( nId );

    return aUIName;
}
// -----------------------------------------------------------------------------
sal_Bool SvPasteObjectDialog::GetEmbeddedName(const TransferableDataHelper& rData,String& _rName,String& _rSource,SotFormatStringId& _nFormat)
{
	sal_Bool bRet = sal_False;
	if( _nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE_OLE || _nFormat == SOT_FORMATSTR_ID_EMBEDDED_OBJ_OLE )
	{
		::com::sun::star::datatransfer::DataFlavor aFlavor;
		SotExchange::GetFormatDataFlavor( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR_OLE, aFlavor );

		::com::sun::star::uno::Any aAny;
		if( rData.HasFormat( aFlavor ) &&
			( aAny = rData.GetAny( aFlavor ) ).hasValue() )
		{
			::com::sun::star::uno::Sequence< sal_Int8 > anySequence;
			aAny >>= anySequence;

			OleObjectDescriptor* pOleObjDescr =
				reinterpret_cast< OleObjectDescriptor* >( anySequence.getArray( ) );

			// determine the user friendly description of the embedded object
			if ( pOleObjDescr->dwFullUserTypeName )
			{
				// we set the pointer to the start of user friendly description
				// string. it starts  at &OleObjectDescriptor + dwFullUserTypeName.
				// dwFullUserTypeName is the offset in bytes.
				// the user friendly description string is '\0' terminated.
				const sal_Unicode* pUserTypeName =
					reinterpret_cast< sal_Unicode* >(
						reinterpret_cast< sal_Char* >( pOleObjDescr ) +
							pOleObjDescr->dwFullUserTypeName );

				_rName.Append( pUserTypeName );
				_nFormat = SOT_FORMATSTR_ID_EMBED_SOURCE_OLE;
			}

			// determine the source of the embedded object
			if ( pOleObjDescr->dwSrcOfCopy )
			{
				// we set the pointer to the start of source string
				// it starts  at &OleObjectDescriptor + dwSrcOfCopy.
				// dwSrcOfCopy is the offset in bytes.
				// the source string is '\0' terminated.
				const sal_Unicode* pSrcOfCopy =
					reinterpret_cast< sal_Unicode* >(
						reinterpret_cast< sal_Char* >( pOleObjDescr ) +
							pOleObjDescr->dwSrcOfCopy );

				_rSource.Append( pSrcOfCopy );
			}
			else
				_rSource =
					String( ResId( STR_UNKNOWN_SOURCE, SOAPP->GetResMgr() ) );
		}
		bRet = sal_True;
	}
	return bRet;
}
// -----------------------------------------------------------------------------

