/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xcpoly.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:35:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XCPOLY_HXX
#define _XCPOLY_HXX


enum XCPolyEdge { EDGE_LEFT, EDGE_TOP, EDGE_RIGHT, EDGE_BOTTOM };


/*************************************************************************
|*
|* Klasse XClipPolygon; Clippt ein Polygon an einem Rechteck
|*
\************************************************************************/

class XClipPolygon
{
	private:
	Polygon		aInPoly;
	PolyPolygon	aInPolyPoly;
	Rectangle	aRect;


	protected:
	BOOL	Inside(const Point& rPoint, XCPolyEdge eEdge);
	Point	Intersect(const Point& rPoint1, const Point& rPoint2, XCPolyEdge eEdge);
	Polygon	ClipEdge(const Polygon& rPoly, XCPolyEdge eEdge);


	public:
	XClipPolygon(const Polygon& rPoly, const Rectangle& rRect)
		: 	aInPoly(rPoly),
			aRect(rRect) {};
	XClipPolygon(const PolyPolygon& rPolyPoly, const Rectangle& rRect)
		: 	aInPolyPoly(rPolyPoly),
			aRect(rRect) {};
	~XClipPolygon() {};

	Polygon 		GetClippedPolygon();
};


/*************************************************************************
|*
|* Klasse XClipPolyPolygon; Clippt ein PolyPolygon an einem Rechteck
|*
\************************************************************************/

class XClipPolyPolygon
{
	private:
	PolyPolygon	aInPolyPoly;
	Rectangle	aRect;


	public:
	XClipPolyPolygon(const PolyPolygon& rPolyPoly, const Rectangle& rRect)
		: 	aInPolyPoly(rPolyPoly),
			aRect(rRect) {};
	~XClipPolyPolygon() {};

	PolyPolygon	GetClippedPolyPolygon();
};




#endif		// _XCPOLY_HXX
