/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: EnhancedCustomShapeHandle.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:28:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _ENHANCED_CUSTOMSHAPE_HANDLE_HXX
#define	_ENHANCED_CUSTOMSHAPE_HANDLE_HXX

#include <com/sun/star/uno/RuntimeException.hpp>

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XCUSTOMSHAPEHANDLE_HPP_
#include <com/sun/star/drawing/XCustomShapeHandle.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_POINT_HPP_
#include <com/sun/star/awt/Point.hpp>
#endif
#ifndef _CPPUHELPER_WEAKREF_HXX_
#include <cppuhelper/weakref.hxx>
#endif

class EnhancedCustomShapeHandle : public cppu::WeakImplHelper2
< 
	com::sun::star::drawing::XCustomShapeHandle,
	com::sun::star::lang::XInitialization
>
{
	sal_uInt32															mnIndex;
	com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > mxCustomShape;

public:

			EnhancedCustomShapeHandle( com::sun::star::uno::Reference< com::sun::star::drawing::XShape >& xCustomShape, sal_uInt32 nIndex );
	virtual ~EnhancedCustomShapeHandle();
											
	// XInterface							
    virtual void SAL_CALL acquire() throw();
    virtual void SAL_CALL release() throw();
    
	// XCustomShapeHandle
	virtual com::sun::star::awt::Point SAL_CALL getPosition()
		throw ( com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL setControllerPosition( const com::sun::star::awt::Point& )
		throw ( com::sun::star::uno::RuntimeException );

	// XInitialization
	virtual void SAL_CALL initialize( const com::sun::star::uno::Sequence< com::sun::star::uno::Any >& aArguments ) 
		throw ( com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException );
};

#endif
