/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: w4wflt_detect.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:36:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <w4wfltlocal.hxx>

// ---------------------------------------------------------------------

//Same as osl::Module, except will search for its modules in the filter subdir
class filterModule : public osl::Module
{
public:
	sal_Bool filterLoad(String &rStr);
};

sal_Bool filterModule::filterLoad(String &rStr)
{
	sal_Bool bRet=sal_False;
	SvtPathOptions aOpt;
	if (aOpt.SearchFile(rStr, SvtPathOptions::PATH_FILTER))
	{
		rtl::OUString aPathURL;
		osl::FileBase::getFileURLFromSystemPath(rtl::OUString(rStr),aPathURL);
		bRet = load(aPathURL);
	}
	return bRet;
}

// calls the autodetect DLL from INSO and
// return the detected filter and version

// !! THIS function is for the DLL and EXE - code !!
USHORT AutoDetec( const String& rFileName, USHORT & rVersion )
{
	ByteString aFileNm( rFileName, ::gsl_getSystemTextEncoding() );
	USHORT nFileType = 0;

#if defined( WNT )
	String aAutoRecDLL(CREATE_CONST_ASC("autorec.dll"));
	SvtPathOptions aOpt;
	if( !aOpt.SearchFile( aAutoRecDLL, SvtPathOptions::PATH_FILTER ))
		return 0;

	ByteString sAutoRecDllNm( aAutoRecDLL, ::gsl_getSystemTextEncoding() );
	HANDLE hDLL = LoadLibrary( (LPSTR)sAutoRecDllNm.GetBuffer() );
	if( hDLL >= (HANDLE)HINSTANCE_ERROR )
	{
		FNautorec fnAutorec = (FNautorec)GetProcAddress( (HINSTANCE)hDLL,
													(LPSTR)"autorec" );

		long nVersion = 0;
		if( fnAutorec )
			nFileType = (*fnAutorec)( (LPSTR)aFileNm.GetBuffer(),
										0,
										(LPINT)&nVersion );
		rVersion = (USHORT)nVersion;
		FreeLibrary( (HINSTANCE)hDLL );
	}
#else
    //This is the nice modern code, the other stuff is a bit awful, but for
    //some reason the different platforms had different argument lists from
    //eachother, so we can't have super clean code :-(
    filterModule aAutoRec;
    String aTmpStr(CREATE_CONST_ASC(SVLIBRARY("autorec")));
    if (aAutoRec.filterLoad(aTmpStr))
    {
		typedef int (*autorec_t)(const char*, int*);
	    if (autorec_t autorec = (autorec_t)aAutoRec.getSymbol(C2U("autorec")))
        {
            int nVersion;
            if ((nFileType = (USHORT)autorec(aFileNm.GetBuffer(), &nVersion)))
                rVersion = (USHORT)nVersion;
        }
    }
#endif

	if( nFileType == 31 )	// Autorec-Bug umpopeln: Eine ASCII-Datei, die nur
		nFileType = 1;		// aus sehr vielen CRs besteht,
							// wird als VAX Mass-11 erkannt

	return nFileType == (USHORT)-1 ? 0 : nFileType;
}


// --------------------------------------------------------------------------
