package com.sun.star.wizards.tutorial.executer.officeHelper;

/**
 * Mouse and keyboard interfaces.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XControl extends XMouse {
    /**
     * Set the delay values for key, mouse and mouse scroll.
     *
     * @param Key time to delay in milliseconds
     * @param Mouse time to delay in milliseconds
     * @param Mouse scroll time to delay in milliseconds
     */
    public void setDelay(int keyMillis, int mouseMillis, int mouseSleepMillis, int mouseScrollMillis, int mouseStep);

    /**
     * Print set delay values
     */
    public void printSetDelayValues();

    /**
     * Reset delays. New values are 0.
     */
    public void reset_Key_Mouse_Scroll_Delay();

    /**
     * Reset mouse position. New mouse position is the screen center.
     */
    public void resetMousePosition();

    /**
     * Set mouse position
     *
     * @param mouse x position
     * @param mouse y position
     */
    public void setMousePosition(int x, int y);

    /**
     * set mouse animate activity.
     *
     * @param if true set the mouse animation to active else inactive
     */
    public void setMouseAnimate(boolean animate);

    /**
     * Get mouse animate status
     */
    public void printMouseAnimateStatus();

    /**
     * Move mouse to x, y coordinates.
     */
    public void mouseAnimate(int x, int y);

    /**
     * click mouse in the x, y coordinates.
     *
     * @param mouse x coordinate
     * @param mouse y coordinate
     */
    public void moveMouse_Click(int x, int y);

    /**
     * press relase a key.
     *
     * @param key code
     */
    public void key_Press_Release(int keycode);
}
