/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: predecla.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 11:49:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <cpp/predecla.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/cpp/usedtype.hxx>
#include <ary/cpp/c_namesp.hxx>
#include <ary/cpp/c_class.hxx>


namespace ary
{
namespace cpp
{

//****************		Less_UsedTypePtr		*************//

struct Less_UsedTypePtr
{
  bool          operator()(
						const ary::cpp::UsedType *
												i_p1,
						const ary::cpp::UsedType *
												i_p2 ) const;
};

bool
Less_UsedTypePtr::operator()( const ary::cpp::UsedType * i_p1,
							  const ary::cpp::UsedType * i_p2 ) const
{
	return *i_p1 < *i_p2;
}



//****************		CheshireCat				*************//

struct TypeOwnerNode::CheshireCat
{
	typedef std::set< const UsedType *, Less_UsedTypePtr >	TypeSet;
	typedef std::map< udmstri, ToNode_Class * >				Index_Name2ClassNode;

	TypeSet				aLocalTypes;
	Index_Name2ClassNode
						aClass_Children;
	udmstri				sName;
	Cid					nRelatedCe;
	TypeOwnerNode *		pParent;

						CheshireCat(
							const CodeEntity &	i_rRelatedCe,
							TypeOwnerNode *		io_pParent );
						~CheshireCat();
};

TypeOwnerNode::
CheshireCat::CheshireCat( const CodeEntity	&	i_rRelatedCe,
						  TypeOwnerNode *		io_pParent )
    :   // aLocalTypes,
        // aClass_Children
        sName( i_rRelatedCe.LocalName() ),
        nRelatedCe( i_rRelatedCe.Id() ),
        pParent( io_pParent )
{
}

TypeOwnerNode::
CheshireCat::~CheshireCat()
{
}


//****************		TypeOwnerNode			*************//

void
TypeOwnerNode::Add_Type( const UsedType & i_rType )
{
	access_Data().aLocalTypes.insert( &i_rType );
}

void
TypeOwnerNode::Add_LocalOwner( ToNode_Class & i_rNode_Class )
{
	access_Data().aClass_Children.insert(
			CheshireCat::Index_Name2ClassNode::value_type(
					i_rNode_Class.LocalName(), &i_rNode_Class) );
}

Cid
TypeOwnerNode::Id_Ce() const
{
	return my_Data().nRelatedCe;
}

const udmstri &
TypeOwnerNode::LocalName() const
{
	return my_Data().sName;
}

const Type *
TypeOwnerNode::Search_Type(	const UsedType & i_rType ) const
{
	CheshireCat::TypeSet::const_iterator itFound
			= my_Data().aLocalTypes.find( &i_rType );
	if ( itFound != my_Data().aLocalTypes.end() )
		return *itFound;
	return 0;
}

TypeOwnerNode *
TypeOwnerNode::Search_LocalOwner( const Class & i_rClass )
{
	return csv::value_from_map( access_Data().aClass_Children, i_rClass.LocalName() );
}


//****************		ToNode_Namespace		*************//

ToNode_Namespace::ToNode_Namespace( const Namespace &	i_rRelatedNamespace,
									TypeOwnerNode *		i_pParent )
	:	pNode( new CheshireCat(i_rRelatedNamespace, i_pParent) )
		// aNamespace_Children
{
}

ToNode_Namespace::~ToNode_Namespace()
{
}

ToNode_Namespace::CheshireCat &
ToNode_Namespace::access_Data()
{
	return *pNode;
}

void
ToNode_Namespace::do_Add_LocalOwner( ToNode_Namespace & i_rNode_Nsp )
{
	aNamespace_Children.insert(
			Index_Name2NspNode::value_type(
					i_rNode_Nsp.LocalName(), &i_rNode_Nsp) );
}

TypeOwnerNode *
ToNode_Namespace::access_Search_LocalOwner( const Namespace & i_rNsp )
{
	return csv::value_from_map( aNamespace_Children, i_rNsp.LocalName() );
}


//****************		ToNode_Class			*************//

ToNode_Class::ToNode_Class(	const Class &		i_rRelatedClass,
							TypeOwnerNode *		i_pParent )
	:	pNode( new CheshireCat(i_rRelatedClass, i_pParent) )
{
}

ToNode_Class::~ToNode_Class()
{
}

ToNode_Class::CheshireCat &
ToNode_Class::access_Data()
{
	return *pNode;
}

void
ToNode_Class::do_Add_LocalOwner( ToNode_Namespace & )
{
	// Must not happen.
	csv_assert(false);
}

TypeOwnerNode *
ToNode_Class::access_Search_LocalOwner( const Namespace & )
{
	// Must not happen.
	csv_assert(false);
    return 0;
}


}
}




