/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2ituple.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:52:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _BGFX_TUPLE_B2ITUPLE_HXX
#include <basegfx/tuple/b2ituple.hxx>
#endif
#ifndef _BGFX_TUPLE_B2DTUPLE_HXX
#include <basegfx/tuple/b2dtuple.hxx>
#endif
#ifndef INCLUDED_RTL_INSTANCE_HXX
#include <rtl/instance.hxx>
#endif

namespace { struct EmptyTuple : public rtl::Static<basegfx::B2ITuple, EmptyTuple> {}; }

namespace basegfx
{
    const B2ITuple& B2ITuple::getEmptyTuple()
    {
            return EmptyTuple::get();
    }

	// external operators
	//////////////////////////////////////////////////////////////////////////

	B2ITuple minimum(const B2ITuple& rTupA, const B2ITuple& rTupB) 
	{ 
		B2ITuple aMin(
			(rTupB.getX() < rTupA.getX()) ? rTupB.getX() : rTupA.getX(),
			(rTupB.getY() < rTupA.getY()) ? rTupB.getY() : rTupA.getY()); 
		return aMin;
	}

	B2ITuple maximum(const B2ITuple& rTupA, const B2ITuple& rTupB) 
	{ 
		B2ITuple aMax(
			(rTupB.getX() > rTupA.getX()) ? rTupB.getX() : rTupA.getX(),
			(rTupB.getY() > rTupA.getY()) ? rTupB.getY() : rTupA.getY()); 
		return aMax;
	}

	B2ITuple absolute(const B2ITuple& rTup) 
	{ 
		B2ITuple aAbs(
			(0 > rTup.getX()) ? -rTup.getX() : rTup.getX(),
			(0 > rTup.getY()) ? -rTup.getY() : rTup.getY()); 
		return aAbs;
	}

	B2DTuple interpolate(const B2ITuple& rOld1, const B2ITuple& rOld2, double t) 
	{ 
		B2DTuple aInt(
			((rOld2.getX() - rOld1.getX()) * t) + rOld1.getX(),
			((rOld2.getY() - rOld1.getY()) * t) + rOld1.getY()); 
		return aInt;
	}

	B2DTuple average(const B2ITuple& rOld1, const B2ITuple& rOld2) 
	{ 
		B2DTuple aAvg(
			(rOld1.getX() + rOld2.getX()) * 0.5,
			(rOld1.getY() + rOld2.getY()) * 0.5); 
		return aAvg;
	}
	
	B2DTuple average(const B2ITuple& rOld1, const B2ITuple& rOld2, const B2ITuple& rOld3)
	{ 
		B2DTuple aAvg(
			(rOld1.getX() + rOld2.getX() + rOld3.getX()) * (1.0 / 3.0),
			(rOld1.getY() + rOld2.getY() + rOld3.getY()) * (1.0 / 3.0)); 
		return aAvg;
	}

	B2ITuple operator+(const B2ITuple& rTupA, const B2ITuple& rTupB)
	{ 
		B2ITuple aSum(rTupA); 
		aSum += rTupB; 
		return aSum; 
	}

	B2ITuple operator-(const B2ITuple& rTupA, const B2ITuple& rTupB)
	{ 
		B2ITuple aSub(rTupA); 
		aSub -= rTupB; 
		return aSub; 
	}

	B2ITuple operator/(const B2ITuple& rTupA, const B2ITuple& rTupB)
	{ 
		B2ITuple aDiv(rTupA); 
		aDiv /= rTupB; 
		return aDiv; 
	}

	B2ITuple operator*(const B2ITuple& rTupA, const B2ITuple& rTupB)
	{ 
		B2ITuple aMul(rTupA); 
		aMul *= rTupB; 
		return aMul; 
	}

	B2ITuple operator*(const B2ITuple& rTup, sal_Int32 t)
	{ 
		B2ITuple aNew(rTup); 
		aNew *= t; 
		return aNew; 
	}

	B2ITuple operator*(sal_Int32 t, const B2ITuple& rTup)
	{ 
		B2ITuple aNew(rTup); 
		aNew *= t; 
		return aNew; 
	}

	B2ITuple operator/(const B2ITuple& rTup, sal_Int32 t)
	{ 
		B2ITuple aNew(rTup); 
		aNew /= t; 
		return aNew; 
	}

	B2ITuple operator/(sal_Int32 t, const B2ITuple& rTup)
	{
		B2ITuple aNew(t, t); 
		B2ITuple aTmp(rTup); 
		aNew /= aTmp; 
		return aNew; 
	}

} // end of namespace basegfx

// eof
