/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tp_SeriesStatistic.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:17:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_TP_SERIESSTATISTIC_HXX
#define _CHART2_TP_SERIESSTATISTIC_HXX

#include "SchSfxItemIds.hxx"
// header for enum SvxChartKindError
#include "SchAllDefinesFor_svx_chrtitem.hxx"
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

// header for SfxTabPage
#ifndef _SFXTABDLG_HXX
#include <sfx2/tabdlg.hxx>
#endif
// header for class ValueSet
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
// header for FixedText
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for CheckBox
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
// header for MetricField
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

class SchStatisticTabPage : public SfxTabPage
{
private:
	CheckBox    aCbxAverage;
	FixedLine   aFlDescr;
	RadioButton aRbtNone;
	RadioButton aRbtVariant;
	RadioButton aRbtSigma;
	RadioButton aRbtPercent;
	RadioButton aRbtBigError;
	RadioButton aRbtConst;
	MetricField aMtrFldPercent;
	MetricField aMtrFldBigError;
	FixedText	aFTConstPlus;
	MetricField aMtrFldConstPlus;
	FixedText	aFTConstMinus;
	MetricField aMtrFldConstMinus;
	FixedText	aFTIndicate;
	ValueSet 	aSet;
	FixedText	aFTRegress;
	ValueSet 	aRegression;

    bool                m_bEnableRegression;
	BOOL                bDisabled;
	SvxChartKindError   eKindError;
	SvxChartIndicate    eIndicate;
	SvxChartRegress     m_eRegression;

	DECL_LINK(CbxClick, CheckBox *);
	DECL_LINK(RBtnClick, Button *);
	DECL_LINK(SelectIndicate, void *);
	DECL_LINK(SelectRegression, void *);
// 	DECL_LINK(EditLoseFocusHdl, Control*);

    void FillValueSets();

public:
	SchStatisticTabPage (Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchStatisticTabPage ();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);

	virtual void	DataChanged( const DataChangedEvent& rDCEvt );

    /// per default regression is disabled
    void EnableRegression( bool bEnable = true );
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif
