/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DatapointGeometry.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:42:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _VIEW_DATAPOINTGEOMETRY_HXX
#define _VIEW_DATAPOINTGEOMETRY_HXX

#ifndef _COM_SUN_STAR_DRAWING_DIRECTION3D_HPP_
#include <com/sun/star/drawing/Direction3D.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POSITION3D_HPP_
#include <com/sun/star/drawing/Position3D.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_SIZE_HPP_
#include <com/sun/star/awt/Size.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_POINT_HPP_
#include <com/sun/star/awt/Point.hpp>
#endif

#ifndef _COM_SUN_STAR_DRAWING_HOMOGENMATRIX_HPP_
#include <com/sun/star/drawing/HomogenMatrix.hpp>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

//-----------------------------------------------------------------------------
/**
If used for 2 dimensional descriptions the third coordinate is ignored
*/
struct DataPointGeometry
{
    DataPointGeometry( const ::com::sun::star::drawing::Position3D& rPosition
                    , const ::com::sun::star::drawing::Direction3D& rSize );

    DataPointGeometry( const ::com::sun::star::drawing::Position3D& rPosition
                    , const ::com::sun::star::drawing::Direction3D& rSize
                    , const ::com::sun::star::drawing::Direction3D& rSize2 );

    ::com::sun::star::drawing::Position3D   m_aPosition;
    //-----------------------------------------------------------------------------
    /** The m_aSize gives the width and height, or radius and angle of the object.
    */
    ::com::sun::star::drawing::Direction3D  m_aSize;
    //-----------------------------------------------------------------------------
    /** The m_aSize2 gives additional information for the size.
    For example there is a second diameter needed for a ring element; this would be
    given as first coordinate in m_aSize2.
    Another example is a topless pyramid; the hight of the cutted top would be
    given as second coordinate in m_aSize2.
    */
    ::com::sun::star::drawing::Direction3D  m_aSize2;

    ::com::sun::star::awt::Point getPoint2D() const;
    ::com::sun::star::awt::Size  getSize2D() const;
};

//.............................................................................
} //namespace chart
//.............................................................................
#endif
