/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmldocproperties.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 11:20:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>

#ifndef __FRAMEWORK_HELPER_XMLDOCPROPERTIES_HXX_
#include <helper/xmldocproperties.hxx>
#endif

#ifndef	__FRAMEWORK_SERVICES_DOCUMENTPROPERTIES_HXX_
#include <services/documentproperties.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_ELEMENTEXISTEXCEPTION_HPP_
#include <com/sun/star/container/ElementExistException.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::xml::sax;

namespace framework
{

#define ELEMENT_META_GENERATOR				"meta:generator"
#define ELEMENT_DC_TITLE					"dc:title"
#define ELEMENT_DC_DESCRIPTION				"dc:description"
#define ELEMENT_DC_SUBJECT					"dc:subject"
#define ELEMENT_META_INITIALCREATOR			"meta:initial-creator"
#define ELEMENT_META_CREATIONDATE			"meta:creation-date"
#define ELEMENT_DC_DATE						"dc:date"
#define ELEMENT_META_PRINTEDBY				"meta:printed-by"
#define ELEMENT_META_PRINTDATE				"meta:print-date"
#define ELEMENT_META_KEYWORDS				"meta:keywords"
#define ELEMENT_META_KEYWORD				"meta:keyword"
#define ELEMENT_DC_LANGUAGE					"dc:language"
#define ELEMENT_META_EDITINGCYCLE			"meta:editing-cycles"
#define ELEMENT_META_EDITINGDURATION		"meta:editing-duration"
#define ELEMENT_META_HYPERLINKBEHAVIOUR		"meta:hyperlink-behaviour"
#define ELEMENT_META_AUTORELOAD				"meta:auto-reload"
#define ELEMENT_META_USERDEFINED			"meta:user-defined"
#define ELEMENT_META_DOCUMENTSTATISTIC		"meta:document-statistic"
#define ELEMENT_META_TEMPLATE				"meta:template"
#define ELEMENT_DC_CREATOR					"dc:creator"

#define ATTRIBUTE_META_NAME					"meta:name"
#define ATTRIBUTE_META_TABLECOUNT			"meta:table-count"
#define ATTRIBUTE_META_DRAWCOUNT			"meta:draw-count"
#define ATTRIBUTE_META_OLEOBJECTCOUNT		"meta:ole-object-count"
#define ATTRIBUTE_META_IMAGECOUNT			"meta:image-count"
#define ATTRIBUTE_META_OBJECTCOUNT			"meta:object-count"
#define ATTRIBUTE_META_PAGECOUNT			"meta:page-count"
#define ATTRIBUTE_META_PARAGRAPHCOUNT		"meta:paragraph-count"
#define ATTRIBUTE_META_WORDCOUNT			"meta:word-count"
#define ATTRIBUTE_META_CHARACTERCOUNT		"meta:character-count"
#define ATTRIBUTE_META_ROWCOUNT				"meta:row-count"
#define ATTRIBUTE_META_CELLCOUNT			"meta:cell-count"
#define ATTRIBUTE_META_DELAY				"meta:delay"
#define ATTRIBUTE_META_DATE					"meta:date"
#define ATTRIBUTE_OFFICE_TARGETFRAMENAME	"office:target-frame-name"
#define ATTRIBUTE_XLINK_SHOW				"xlink:show"
#define ATTRIBUTE_XLINK_HREF				"xlink:href"
#define ATTRIBUTE_XLINK_TYPE				"xlink:type"
#define ATTRIBUTE_XLINK_TITLE				"xlink:title"

static char sElementStrings[XMLDocumentPropertiesHandler::DOCPROPELEM_COUNT][30] =
{
	"\0",
	ELEMENT_META_GENERATOR,
	ELEMENT_DC_TITLE,
	ELEMENT_DC_DESCRIPTION,
	ELEMENT_DC_SUBJECT,
	ELEMENT_META_INITIALCREATOR,
	ELEMENT_META_CREATIONDATE,
	ELEMENT_DC_DATE,
	ELEMENT_META_PRINTEDBY,
	ELEMENT_META_PRINTDATE,
	ELEMENT_META_KEYWORDS,
	ELEMENT_META_KEYWORD,
	ELEMENT_DC_LANGUAGE,
	ELEMENT_META_EDITINGCYCLE,
	ELEMENT_META_EDITINGDURATION,
	ELEMENT_META_HYPERLINKBEHAVIOUR,
	ELEMENT_META_AUTORELOAD,
	ELEMENT_META_USERDEFINED,
	ELEMENT_META_DOCUMENTSTATISTIC,
	ELEMENT_META_TEMPLATE,
	ELEMENT_DC_CREATOR
};

XMLDocumentPropertiesHandlerBase::XMLDocumentPropertiesHandlerBase() :
	m_xLocator( 0 ),
	m_xReader( 0 )
{
}

XMLDocumentPropertiesHandlerBase::~XMLDocumentPropertiesHandlerBase()
{
}

Any SAL_CALL XMLDocumentPropertiesHandlerBase::queryInterface(
	const Type & rType )
throw( RuntimeException )
{
	Any a = ::cppu::queryInterface(
				rType ,
				SAL_STATIC_CAST( XDocumentHandler*, this ));
	if ( a.hasValue() )
		return a;

	return OWeakObject::queryInterface( rType );
}

void SAL_CALL XMLDocumentPropertiesHandlerBase::ignorableWhitespace(
	const OUString& )
throw( SAXException, RuntimeException )
{
}

void SAL_CALL XMLDocumentPropertiesHandlerBase::processingInstruction(
	const OUString& /*aTarget*/, const OUString& /*aData*/ )
throw( SAXException, RuntimeException )
{
}

void SAL_CALL XMLDocumentPropertiesHandlerBase::setDocumentLocator(
	const Reference< XLocator > &xLocator)
throw(	SAXException, RuntimeException )
{
	m_xLocator = xLocator;
}

::rtl::OUString XMLDocumentPropertiesHandlerBase::getErrorLineString()
{
	char buffer[32];

	if ( m_xLocator.is() )
	{
		snprintf( buffer, sizeof(buffer), "Line: %ld - ", m_xLocator->getLineNumber() );
		return OUString::createFromAscii( buffer );
	}
	else
		return OUString();
}

// -----------------------------------------------------------------------------

XMLDocumentPropertiesHandler::XMLDocumentPropertiesHandler(
	Reference< XNameContainer >& rNameContainer,
	FixedDocumentProperties& rFixedDocProperties ) :
	m_xNameContainer( rNameContainer ),
	m_rDocumentProperties( rFixedDocProperties ),
	m_nCurrentElement( DOCPROPELEM_NONE ),
	m_bKeywordsElementFound( sal_False ),
	m_nKeywords( 0 ),
	m_nUserData( 0 )
{
	for ( int i = 1; i < DOCPROPELEM_COUNT; i++ )
	{
		m_aDocPropHashMap.insert( DocPropHashMap::value_type(
		OUString::createFromAscii( sElementStrings[i] ), (DocPropertiesElement)i ));
	}
}

XMLDocumentPropertiesHandler::~XMLDocumentPropertiesHandler()
{
}

sal_Bool XMLDocumentPropertiesHandler::GetDateTime( const rtl::OUString& aDateTimeStr, ::com::sun::star::util::DateTime& aDateTime )
{
    sal_Int32 nPos = aDateTimeStr.indexOf( (sal_Unicode) 'T' );
    OUString aDateStr;
	OUString aTimeStr;

	if ( nPos >= 0 )
    {
        aDateStr = aDateTimeStr.copy( 0, nPos );
        aTimeStr = aDateTimeStr.copy( nPos + 1 );
    }

	if ( aDateStr.getLength() >= 10 )
	{
		aDateTime.Year		= (sal_uInt16)aDateStr.copy( 0, 4 ).toInt32();
		aDateTime.Month		= (sal_uInt16)aDateStr.copy( 5, 2 ).toInt32();
		aDateTime.Day		= (sal_uInt16)aDateStr.copy( 8, 2 ).toInt32();
	}
	else
	{
		return sal_False;
	}

	if ( nPos >= 0 )
	{
		if ( aTimeStr.getLength() >= 8 )
		{
			aDateTime.Hours		= (sal_uInt16)aTimeStr.copy( 0, 2 ).toInt32();
			aDateTime.Minutes	= (sal_uInt16)aTimeStr.copy( 3, 2 ).toInt32();
			aDateTime.Seconds	= (sal_uInt16)aTimeStr.copy( 6, 2 ).toInt32();
			aDateTime.HundredthSeconds = 0;
		}
		else
		{
			return sal_False;
		}
	}

	return sal_True;
}

sal_Bool XMLDocumentPropertiesHandler::GetDuration( const rtl::OUString& rString, sal_Int32& nDurationInSec )
{
    rtl::OUString aTrimmed = rString.trim();
    const sal_Unicode* pStr = aTrimmed.getStr();

    if ( *(pStr++) != sal_Unicode('P') ) // duration must start with "P"
        return sal_False;

    sal_Bool bSuccess = TRUE;
    sal_Bool bDone = sal_False;
    sal_Bool bTimePart = sal_False;
    sal_Int32 nDays  = 0;
    sal_Int32 nHours = 0;
    sal_Int32 nMins  = 0;
    sal_Int32 nSecs  = 0;
    sal_Int32 nTemp = 0;

    while ( bSuccess && !bDone )
    {
        sal_Unicode c = *(pStr++);
        if ( !c )                               // end
            bDone = sal_True;
        else if ( sal_Unicode('0') <= c && sal_Unicode('9') >= c )
        {
            if ( nTemp >= LONG_MAX / 10 )
                bSuccess = sal_False;
            else
            {
                nTemp *= 10;
                nTemp += (c - sal_Unicode('0'));
            }
        }
        else if ( bTimePart )
        {
            if ( c == sal_Unicode('H') )
            {
                nHours = nTemp;
                nTemp = 0;
            }
            else if ( c == sal_Unicode('M') )
            {
                nMins = nTemp;
                nTemp = 0;
            }
            else if ( c == sal_Unicode('S') )
            {
                nSecs = nTemp;
                nTemp = 0;
            }
            else
                bSuccess = sal_False;               // invalid characted
        }
        else
        {
            if ( c == sal_Unicode('T') )            // "T" starts time part
                bTimePart = TRUE;
            else if ( c == sal_Unicode('D') )
            {
                nDays = nTemp;
                nTemp = 0;
            }
            else if ( c == sal_Unicode('Y') || c == sal_Unicode('M') )
            {
                //! how many days is a year or month?
                bSuccess = sal_False;
            }
            else
                bSuccess = sal_False;               // invalid characted
        }
    }

    if ( bSuccess )
    {
        if ( nDays )
            nHours += nDays * 24;               // add the days to the hours part
        nDurationInSec = nDays * 86400 + nHours * 3600 + nMins * 60 + nSecs;
    }
    return bSuccess;
}


// XDocumentHandler
void SAL_CALL XMLDocumentPropertiesHandler::startDocument(void)
throw (	SAXException, RuntimeException )
{
}

void SAL_CALL XMLDocumentPropertiesHandler::endDocument(void)
throw( SAXException, RuntimeException )
{
}

void SAL_CALL XMLDocumentPropertiesHandler::startElement(
	const rtl::OUString& rName, const Reference< XAttributeList > &xAttribs )
throw(	SAXException, RuntimeException )
{
	DocPropHashMap::iterator p;
	p = m_aDocPropHashMap.find( rName );
	if ( p != m_aDocPropHashMap.end() )
	{
		m_aCharacters		= OUString();
		m_nCurrentElement	= p->second;

		// known element found!
		if ( m_nCurrentElement == DOCPROPELEM_META_KEYWORDS )
			m_bKeywordsElementFound = sal_True;

		for ( int i=0; i< xAttribs->getLength(); i++ )
		{
			OUString aName	= xAttribs->getNameByIndex( i );
			OUString aValue	= xAttribs->getValueByIndex( i );

			switch ( m_nCurrentElement )
			{
				case DOCPROPELEM_META_HYPERLINKBEHAVIOUR:
				{
					if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_OFFICE_TARGETFRAMENAME )) )
						m_rDocumentProperties.m_sDefaultTarget = aValue;
				}
				break;

				case DOCPROPELEM_META_AUTORELOAD:
				{
					if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_META_DELAY )) )
					{
						GetDuration( aValue, m_rDocumentProperties.m_nAutoloadSecs );
					}
					else if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_XLINK_HREF )) )
						m_rDocumentProperties.m_sAutoloadURL = aValue;
				}
				case DOCPROPELEM_META_USERDEFINED:
				{
					if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_META_NAME )) )
						m_aUserDataName = aValue;
				}
				break;

				case DOCPROPELEM_META_DOCUMENTSTATISTIC:
				{
				}
				break;

				case DOCPROPELEM_META_TEMPLATE:
				{
					if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_XLINK_TITLE )) )
						m_rDocumentProperties.m_sTemplate = aValue;
					else if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_META_DATE )) )
					{
						::com::sun::star::util::DateTime aTemplateDate;
						if ( GetDateTime( aValue, aTemplateDate ) )
							m_rDocumentProperties.m_aTemplateDate = aTemplateDate;
					}
					else if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_XLINK_HREF )) )
						m_rDocumentProperties.m_sTemplateFileName = aValue;
				}
				break;

				default:
				break;
			}
		}
	}
}

void SAL_CALL XMLDocumentPropertiesHandler::endElement(
	const rtl::OUString& aName)
throw(	SAXException, RuntimeException )
{
	DocPropHashMap::iterator p;
	p = m_aDocPropHashMap.find( aName );
	if ( p != m_aDocPropHashMap.end() )
	{
		if ( aName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ELEMENT_META_KEYWORDS )) )
		{
			if ( !m_bKeywordsElementFound )
			{
				throw SAXException(
					OUString( RTL_CONSTASCII_USTRINGPARAM( "End element meta:keywords used without opening first!" )),
					Reference< XInterface >(),
					Any() );
			}
			m_bKeywordsElementFound = sal_False;
		}
		else
		{
			if ( p->second != m_nCurrentElement )
			{
				throw SAXException(
					OUString( RTL_CONSTASCII_USTRINGPARAM( "Wrong end element found!" )),
					Reference< XInterface >(),
					Any() );
			}

			switch ( m_nCurrentElement )
			{
				case DOCPROPELEM_META_GENERATOR:
				{
				}
				break;

				case DOCPROPELEM_DC_TITLE:
				{
					m_rDocumentProperties.m_sTitle = m_aCharacters;
				}
				break;

				case DOCPROPELEM_DC_DESCRIPTION:
				{
					m_rDocumentProperties.m_sDescription = m_aCharacters;
				}
				break;

				case DOCPROPELEM_DC_SUBJECT:
				{
				}
				break;

				case DOCPROPELEM_META_INITIALCREATOR:
				{
					m_rDocumentProperties.m_sAuthor = m_aCharacters;
				}
				break;

				case DOCPROPELEM_META_CREATIONDATE:
				{
					::com::sun::star::util::DateTime aCreationDate;
					if ( GetDateTime( m_aCharacters, aCreationDate ) )
						m_rDocumentProperties.m_aCreationDate = aCreationDate;
				}
				break;

				case DOCPROPELEM_DC_DATE:
				{
					::com::sun::star::util::DateTime aModifyDate;
					if ( GetDateTime( m_aCharacters, aModifyDate ) )
						m_rDocumentProperties.m_aModifyDate = aModifyDate;
				}
				break;

				case DOCPROPELEM_META_PRINTEDBY:
				{
					m_rDocumentProperties.m_sPrintedBy = m_aCharacters;
				}
				break;

				case DOCPROPELEM_META_PRINTDATE:
				{
					::com::sun::star::util::DateTime aPrintDate;
					if ( GetDateTime( m_aCharacters, aPrintDate ) )
						m_rDocumentProperties.m_aPrintDate = aPrintDate;
				}
				break;

				case DOCPROPELEM_META_KEYWORD:
				{
					if ( m_bKeywordsElementFound )
					{
						if ( m_nKeywords == 0 )
							m_rDocumentProperties.m_sKeywords = m_aCharacters;
						else
						{
							// next keywords must be concated with ','
							m_rDocumentProperties.m_sKeywords += OUString( RTL_CONSTASCII_USTRINGPARAM( ", " ));
							m_rDocumentProperties.m_sKeywords += m_aCharacters;
						}

						++m_nKeywords;
					}
					else
					{
						throw SAXException(
							OUString( RTL_CONSTASCII_USTRINGPARAM( "Element meta:keyword found without meta:keywords!" )),
							Reference< XInterface >(),
							Any() );
					}
				}
				break;

				case DOCPROPELEM_DC_LANGUAGE:
				{
				}
				break;

				case DOCPROPELEM_META_EDITINGCYCLES:
				{
					m_rDocumentProperties.m_nEditingCycles = (sal_uInt16)m_aCharacters.toInt32();
				}
				break;

				case DOCPROPELEM_META_EDITINGDURATION:
				{
					GetDuration( m_aCharacters, m_rDocumentProperties.m_nEditingDuration );
				}
				break;

				case DOCPROPELEM_META_USERDEFINED:
				{
					try
					{
						m_rDocumentProperties.m_bUserData = sal_True;
						m_xNameContainer->insertByName( m_aUserDataName, makeAny( m_aCharacters ) );
					}
                    catch ( ::com::sun::star::lang::IllegalArgumentException& )
					{
					}
                    catch ( ::com::sun::star::container::ElementExistException& )
					{
					}
                    catch ( ::com::sun::star::lang::WrappedTargetException& )
					{
					}
				}
				break;

				case DOCPROPELEM_DC_CREATOR:
				{
					m_rDocumentProperties.m_sModifiedBy = m_aCharacters;
				}
				break;

				default:
				break;
			}
		}
	}

	m_nCurrentElement = DOCPROPELEM_NONE;
}

void SAL_CALL XMLDocumentPropertiesHandler::characters(
	const rtl::OUString& aChars)
throw(	SAXException, RuntimeException )
{
	m_aCharacters += aChars;
}

} // namespace framework
