

package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.EnumEntryCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateEnumEntryAction extends NodeAction
    implements Create
{

    public CreateEnumEntryAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((EnumEntryCreator)anode[0].getCookie(EnumEntryCreator.class)).createEnumEntry();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(EnumEntryCreator.class) != null;
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateMember");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_EnumEntry");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }


}
