
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ModuleCreatePanel;
import org.netbeans.modules.openoffice.wizard.keys.NameKey;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.NotifyDescriptor.Message;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import java.util.Vector;


public class ModuleNode extends MovableNode 
{  
    public ModuleNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/module");
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
                SystemAction.get(EditAction.class),
                SystemAction.get(DestroyAction.class),
                SystemAction.get(CreateConstantAction.class),
                SystemAction.get(CreateConstantsAction.class),
                SystemAction.get(CreateEnumAction.class),
                SystemAction.get(CreateExceptionAction.class),
                SystemAction.get(CreateInterfaceAction.class),
                SystemAction.get(CreateModuleAction.class),
                SystemAction.get(CreateServiceAction.class),
                SystemAction.get(CreateStructAction.class),
                SystemAction.get(CreateAliasAction.class),
          });
    }

    public String generateSelf(int i)
    {
        
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
          s1 = s1 + "    ";
         s = s1 + "module " + getName() + " {\n";
         Node anode[] = getChildren().getNodes();
         for(int k = 0; k < anode.length; k++)
        {
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);
            s = s + "\n";
        }

        s = s + s1 + "};\n";
        return s;
    }
    
    public boolean canDestroy()
    {
        return true;
    }

    public boolean canRename()
    {
        return false;
    }

    public BasePanel getEditPanel()
    {
        ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        modulepanel.setName(getName());
        return modulepanel;
    }

    public void reInit(BasePanel expanel)
    {
        if(expanel instanceof ModuleCreatePanel)
        {
            String s = ((ModuleCreatePanel)expanel).getName();
            if(!key.getName().equals(s))
            {
                setName(s);
                key.setName(s);
            }
        }
    }
 public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
}
