/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: excscen.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:17:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/



#ifndef _EXCSCEN_HXX
#define _EXCSCEN_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif


struct RootData;
class XclImpRoot;
class XclImpStream;
class ScDocument;



class ExcScenarioCell
{
private:
	String						aValue;
public:
	const UINT16				nCol;
	const UINT16				nRow;

								ExcScenarioCell( const UINT16 nC, const UINT16 nR );
	void						SetValue( const String& rVal );
	inline const String&		GetValue( void ) const;
};




class ExcScenario : protected List
{
private:
	friend class ExcScenarioList;
protected:
	String*						pName;
	String*						pComment;
	String*						pUserName;
	UINT8						nProtected;

	const UINT16				nTab;

    void                        Apply( const XclImpRoot& rRoot, const BOOL bLast = FALSE );
public:
								ExcScenario( XclImpStream& rIn, const RootData& rRoot );
	virtual						~ExcScenario();
};




class ExcScenarioList : protected List
{
private:
	UINT16						nLastScenario;
	inline ExcScenario*			_First( void )	{ return ( ExcScenario* ) List::First(); }
	inline ExcScenario*			_Next( void )	{ return ( ExcScenario* ) List::Next(); }
	inline ExcScenario*			_Last( void )	{ return ( ExcScenario* ) List::Last(); }
	inline ExcScenario*			_Prev( void )	{ return ( ExcScenario* ) List::Prev(); }
protected:
public:
                                ExcScenarioList( void );
	virtual						~ExcScenarioList();

	inline void					Append( ExcScenario* pNew );

	inline void					SetLast( const UINT16 nIndex4Last );

	inline const ExcScenario*	First( void );
	inline const ExcScenario*	Next( void );

	List::Count;

    void                        Apply( const XclImpRoot& rRoot );
};




inline const String& ExcScenarioCell::GetValue( void ) const
{
	return aValue;
}




inline ExcScenarioList::ExcScenarioList( void )
{
	nLastScenario = 0;
}


inline void ExcScenarioList::Append( ExcScenario* p )
{
	List::Insert( p, LIST_APPEND );
}


inline const ExcScenario* ExcScenarioList::First( void )
{
	return ( const ExcScenario* ) List::First();
}


inline const ExcScenario* ExcScenarioList::Next( void )
{
	return ( const ExcScenario* ) List::Next();
}


inline void ExcScenarioList::SetLast( const UINT16 n )
{
	nLastScenario = n;
}


#endif

