/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schview.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/25 12:22:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SOT_EXCHANGE_HXX //autogen
#include <sot/exchange.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _STRING_HXX //autogen wg. String
#include <tools/string.hxx>
#endif
// header for class INetURLObject
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
// header for class Svx3DChildWindow
#ifndef _SVX_F3DCHILD_HXX
#include <svx/f3dchild.hxx>
#endif

#include <tools/shl.hxx>
#include <sfx2/viewfrm.hxx>

// SdrVirtObj
#ifndef _SVDOVIRT_HXX
#include <svx/svdovirt.hxx>
#endif

#ifndef _SVDOOLE2_HXX
#include <svx/svdoole2.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "schview.hxx"
#include "schmod.hxx"
#include "schresid.hxx"
#include "chwindow.hxx"
#include "docshell.hxx"
#include "objid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "uninstit.hxx"
#include "uninsleg.hxx"
#include "unmultdp.hxx"
#include "viewshel.hxx"
#include "strings.hrc"
#include "glob.hrc"
#include "schgroup.hxx"
#include "eetext.hxx"
#include "docshell.hxx"
#include "viewshel.hxx"
#include "chaxis.hxx"
#include "axisobj.hxx"
#include "memchrt.hxx"
#include "SchTransferable.hxx"
#include "guiutil.hxx"

using namespace com::sun::star;
using namespace com::sun::star::uno;

/*************************************************************************
|*
|* Konstruktor 1
|*
\************************************************************************/

SchView::SchView(SchChartDocShell* pDocShell,
				 OutputDevice* pOutDev,
				 SchViewShell* pViewShell)
  : E3dView(&pDocShell->GetDoc(), pOutDev),
	pDoc(&pDocShell->GetDoc()),
	pDocSh(pDocShell),
	pViewSh(pViewShell),
	bDragActive (FALSE),
	nLogicalMarked(FALSE),
	nLogicalEntered(FALSE)
{
	// #114898#
	SetBufferedOutputAllowed(sal_True);

	Construct();
}

/*************************************************************************
|*
|* Konstruktor 2
|*
\************************************************************************/

SchView::SchView(ChartModel* pDocument,
				 OutputDevice* pOutDev)
  : E3dView(pDocument, pOutDev),
	pDoc(pDocument),
	pDocSh(NULL),
	pViewSh(NULL),
	bDragActive (FALSE),
	nLogicalMarked(FALSE),
	nLogicalEntered(FALSE)
{
	Construct();
}

/*************************************************************************
|*
|* Construct
|*
\************************************************************************/

void SchView::Construct()
{
	SetUseIncompatiblePathCreateInterface(TRUE);

	OutputDevice* pOut = GetWin(0);

	if( pOut )
		SetMinMoveDistancePixel( (USHORT)pOut->PixelToLogic( Size( 2, 0 )).Width());

	SetHitTolerancePixel (2);
	EnableExtendedKeyInputDispatcher (FALSE);
	EnableExtendedMouseEventDispatcher (FALSE);
	EnableExtendedCommandEventDispatcher (FALSE);
	bBordVisible = FALSE;

	if (pDocSh && pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED)
		bPageVisible = FALSE;

	bGlueVisible  =
	bGlueVisible2 =
	bGlueVisible3 = TRUE;
	SetCurrentObj(OBJ_RECT, SdrInventor);

	if (pDoc->GetPageCount() == 0L)
	{
		// Seite einfuegen
		BOOL bChanged = pDoc->IsChanged();
		SdrPage* pPage = pDoc->AllocPage(FALSE);

		if (pDocSh)
			pPage->SetSize(pDocSh->GetVisArea(ASPECT_CONTENT).GetSize());

		pDoc->InsertPage(pPage);
		pDoc->BuildChart(FALSE);
		pDoc->SetChanged(bChanged);
	}
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchView::~SchView()
{
    // release content of selection clipboard, if we own the content
    UpdateSelectionClipboard( TRUE );

	aTimer.Stop();
	for (USHORT nWin = 0; nWin < GetWinCount(); nWin++)
	{
		OutputDevice* pOutDev = GetWin(nWin);

		if (pOutDev->GetOutDevType() == OUTDEV_WINDOW)
			DelWin((SchWindow*)pOutDev);
	}
}

/*************************************************************************
|*
|* virtuelle Methode von SdrView, der die anfallenden Undo-Aktionen
|* uebergeben werden
|*
\************************************************************************/

BOOL SchView::NotifyNewUndoAction()
{
	return TRUE;
}

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

void SchView::MarkListHasChanged()
{
	E3dView::MarkListHasChanged();
	if ( pViewSh )
		pViewSh->SelectionHasChanged();

	aTimer.SetTimeoutHdl( LINK( this, SchView, NotifySelection) );
	// Timer reset
	aTimer.SetTimeout(100);
	aTimer.Start();
}

/*************************************************************************
|*
|* Entfernt Chart-Userdaten
|*
\************************************************************************/

void SchView::DeleteChartUserData(ChartModel& rDoc)
{
	SdrPage* pPage = rDoc.GetPage(0);
	DBG_ASSERT(pPage, "Keine Seite vorhanden!");

	SdrObjListIter aIterator(*pPage, IM_DEEPWITHGROUPS);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();

		USHORT nPos = 0;

		do
		{
			SdrObjUserData *pData = pObj->GetUserData(nPos);

			if (pData)
				switch (pData->GetId())
				{
					case SCH_LIGHTFACTOR_ID:
						DBG_ERROR("SCH_LIGHTFACTOR_ID ist im Chart abgeschafft!");
					case SCH_OBJECTID_ID:
					case SCH_OBJECTADJUST_ID:
					case SCH_DATAROW_ID:
					case SCH_DATAPOINT_ID:
						pObj->DeleteUserData(nPos);
						break;

					default:
						nPos++;
						break;
				}
				else
				nPos++;
		}
		while (nPos < pObj->GetUserDataCount());
	}
}

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

BOOL SchView::DoCut(Window* pWindow)
{
	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pDocSh->IsReadOnly())
		return FALSE;

	if( pOLV )
		((OutlinerView*)pOLV)->Cut();
	else if( AreObjectsMarked() && CanDeleteMarkedObjects())
	{
		BrkAction();

		DoCopy();
		DeleteMarkedObjects( String( SchResId( STR_UNDO_CUT )));
	}
	else
		return FALSE;

	return TRUE;
}

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

void SchView::DoCopy(Window* pWindow)
{
	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pOLV )
		( (OutlinerView*) pOLV)->Copy();
	else if( AreObjectsMarked())
	{
		BrkAction();
		CreateClipboardDataObject();
	}
}

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

void SchView::DoPaste(Window* pWindow)
{
	if( pDocSh->IsReadOnly())
		return;

	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pOLV )
	{
		((OutlinerView*)pOLV)->PasteSpecial();
	}
	else
	{
		Point aPos;
		SchTransferable* pTransferClip = SCH_MOD1()->GetClipboardTransferable();

		if( pWindow )
			aPos = pWindow->PixelToLogic( Rectangle( aPos, pWindow->GetOutputSizePixel()).Center());

		if( pTransferClip )
		{
			TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWindow ));

			if( aDataHelper.GetTransferable().is())
				InsertData( aDataHelper, aPos, DND_ACTION_COPY, FALSE );
		}
	}
}

/*************************************************************************
|*
|* Texteingabe beginnen
|*
\************************************************************************/

FASTBOOL SchView::BegTextEdit(SdrObject* pObj, SdrPageView* pPV, Window* pWin,
							  FASTBOOL bIsNewObj, SdrOutliner* pGivenOutliner,
							  OutlinerView* pGivenOutlinerView,
							  FASTBOOL bDontDeleteOutliner,
							  FASTBOOL bOnlyOneView)
{
	BOOL bReturn =
				E3dView::BegTextEdit(pObj, pPV, pWin, bIsNewObj, pGivenOutliner,
							 pGivenOutlinerView, bDontDeleteOutliner,
							 bOnlyOneView);

	if (bReturn)
	{
		// set undo manager at topmost shell ( SdDrawTextObjectBar )
		SdrOutliner* pOutliner = GetTextEditOutliner();
		if( pViewSh )
			pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->
				SetUndoManager(&pOutliner->GetUndoManager());
	}

	return bReturn;
}

/*************************************************************************
|*
|* Texteingabe beenden
|*
\************************************************************************/

SdrEndTextEditKind SchView::EndTextEdit()
{
	SdrEndTextEditKind eKind = E3dView::EndTextEdit( TRUE );

	// UndoManager an der obersten Shell setzen
	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
	SfxUndoManager* pUndoMgr = pDocShell->GetUndoManager();

	SfxShell* pTopMostShell = NULL;
	if( pViewSh )
		pTopMostShell = pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 );

	if( pTopMostShell->ISA( SchViewShell ))
	{
		pTopMostShell->SetUndoManager( pUndoMgr );
	}
	Window& rWin = (Window&)(*GetWin( 0 ));
	Rectangle aAll = Rectangle( 0, 0, 0, 0 );
	aAll.SetSize( rWin.GetOutputSize() );
	MakeVisible( aAll, rWin );

	return eKind;
}

/*************************************************************************
|*
|* Ermittelt, ob Chart-Objekt selektiert ist
|*
\************************************************************************/

BOOL SchView::IsChartObjSelected()
{
	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();

		for (ULONG i = 0; i < nCount; i++)
			if (GetObjectId(*GetMarkedObjectByIndex(i)))
				return TRUE;
	}

	return FALSE;
}

/*************************************************************************
|*
|* Prueft, ob Objekte geloescht werden koennen
|*
\************************************************************************/

BOOL SchView::CanDeleteMarkedObjects()
{

	if(pDocSh->IsReadOnly())return FALSE;
	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SchObjectId* pId = GetObjectId(*GetMarkedObjectByIndex(i));
			if (pId)
			{
				if (nCount > 1)
					return FALSE;

				switch (pId->GetObjId())
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_LEGEND:
						return TRUE;

					default:
						return FALSE;
				}
			}
		}
	}

	return TRUE;
}

/*************************************************************************
|*
|* Loescht ggf. markierte Objekte;
|* Liefert FALSE, wenn ein markiertes Chart-Objekt nicht geloescht
|* werden konnte.
|*
\************************************************************************/

BOOL SchView::DeleteMarkedObjects(const String& rUndoStr)
{
	if(pDocSh->IsReadOnly())return FALSE;
	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SchObjectId* pId = GetObjectId(*GetMarkedObjectByIndex(i));
			if (pId)
			{
				if (nCount > 1)
					return FALSE;

				UINT16 nId = pId->GetObjId();

				switch (nId)
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					{
						BOOL bOldShowMain   = pDoc->ShowMainTitle();
						String aOldMain     = pDoc->MainTitle();
						BOOL bOldShowSub    = pDoc->ShowSubTitle();
						String aOldSub      = pDoc->SubTitle();
						BOOL bOldShowXAxis  = pDoc->ShowXAxisTitle();
						String aOldXAxis    = pDoc->XAxisTitle();
						BOOL bOldShowYAxis  = pDoc->ShowYAxisTitle();
						String aOldYAxis    = pDoc->YAxisTitle();
						BOOL bOldShowZAxis  = pDoc->ShowZAxisTitle();
						String aOldZAxis    = pDoc->ZAxisTitle();

						BOOL bNewShowMain	= (nId == CHOBJID_TITLE_MAIN) ?
											  FALSE : bOldShowMain;
						BOOL bNewShowSub	= (nId == CHOBJID_TITLE_SUB) ?
											  FALSE : bOldShowSub;
						BOOL bNewShowXAxis	= (nId == CHOBJID_DIAGRAM_TITLE_X_AXIS) ?
											  FALSE : bOldShowXAxis;
						BOOL bNewShowYAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Y_AXIS) ?
											  FALSE : bOldShowYAxis;
						BOOL bNewShowZAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Z_AXIS) ?
											  FALSE : bOldShowZAxis;

						pDoc->ChangeTitle(bNewShowMain, aOldMain,
											bNewShowSub, aOldSub,
											bNewShowXAxis, aOldXAxis,
											bNewShowYAxis, aOldYAxis,
											bNewShowZAxis, aOldZAxis);

						SchUndoInsertTitle* pUndo =
							new SchUndoInsertTitle(*pDoc, bOldShowMain,
												   aOldMain, bOldShowSub,
												   aOldSub, bOldShowXAxis,
												   aOldXAxis, bOldShowYAxis,
												   aOldYAxis, bOldShowZAxis,
												   aOldZAxis,
												   bNewShowMain, aOldMain,
												   bNewShowSub, aOldSub,
												   bNewShowXAxis, aOldXAxis,
												   bNewShowYAxis, aOldYAxis,
												   bNewShowZAxis, aOldZAxis);
						pUndo->SetComment(rUndoStr);

						pDoc->GetObjectShell()->
							GetUndoManager()->AddUndoAction(pUndo);
						return TRUE;
					}

					case CHOBJID_LEGEND:
					{
						SfxItemSet aAttr = pDoc->GetLegendAttr();
						const SfxPoolItem *pPoolItem = NULL;
						BOOL bVisible = pDoc->GetShowLegend ();
						SvxChartLegendPos eOldPos =	(aAttr.GetItemState(SCHATTR_LEGEND_POS,
																		TRUE, &pPoolItem) == SFX_ITEM_SET)
														? ((const SvxChartLegendPosItem*)pPoolItem)->GetValue()
														: CHLEGEND_NONE;
						aAttr.Put(SvxChartLegendPosItem(CHLEGEND_NONE));
						pDoc->SetShowLegend (FALSE);
						pDoc->ChangeLegendAttr(aAttr);//, TRUE);
						SchUndoInsertLegend* pUndo = new SchUndoInsertLegend(*pDoc, eOldPos, CHLEGEND_NONE,
																			 bVisible, FALSE);
						pUndo->SetComment(rUndoStr);

						pDoc->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
						return TRUE;
					}

					default:
						return FALSE;
				}
			}
		}
		DeleteMarked();
	}

	return TRUE;
}

/*************************************************************************
|*
|* Ermittelt, ob Daten-Reihen/Punkt-Attribute gesetzt werden koennen
|*
\************************************************************************/

BOOL SchView::CanSetDataAttr()
{
	if (AreObjectsMarked() && GetMarkedObjectCount() == 1)
	{
		SdrObject* pObj = GetMarkedObjectByIndex(0);

		return GetDataRow(*pObj) || GetDataPoint(*pObj);
	}

	return FALSE;
}

/*************************************************************************
|*
|* Verschiebt die markierten Objekte an den angegebenen Objekt-Index
|*
\************************************************************************/

void SchView::PutMarkedToPos(ULONG nObjPos)
{
	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SdrObject*	pObj = GetMarkedObjectByIndex(i);
			SdrObjList* pList = pObj->GetObjList();
			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
			pList->SetObjectOrdNum(pObj->GetOrdNum(), nObjPos++);
			MarkListHasChanged();
		}
	}
}

/*************************************************************************
|*
|* Verschiebt die markierten Objekte um eine Indexposition zum
|* angegebenen Objekt-Index
|*
\************************************************************************/

void SchView::MovMarkedToPos(ULONG nObjPos)
{
	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SdrObject*	pObj = GetMarkedObjectByIndex(i);
			SdrObjList* pList = pObj->GetObjList();
			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
			ULONG nIndex = pObj->GetOrdNum();
			if (nIndex	> nObjPos)
			{
				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex - 1);
				MarkListHasChanged();
			}
			else if (nIndex < nObjPos)
			{
				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex + 1);
				MarkListHasChanged();
			}
		}
	}
}

/*************************************************************************
|*
|* Kontext-String fuer Statusbar
|*
\************************************************************************/

String SchView::GetContext()
{
	SdrObject	 *pObj  = NULL;
	SchDataRow	 *pRow  = NULL;
	SchDataPoint *pPoint= NULL;

	long nSubRow=-1;
	String aResult( SchResId( STR_MARKED ));

	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();
		if (nCount >= 1)//>=, da im 3D alle Unterobjekte markiert
		{
			pObj=GetMarkedObjectByIndex(0);
			SchObjectId* pId = GetObjectId(*pObj);
			if (pId)
			{
				USHORT nId = GuiUtilities::GetObjectNameResId(pId->GetObjId(), *pDoc);

				if(STR_DIAGRAM_ROW == nId)
				{
					pRow = GetDataRow(*pObj);
					if(!pRow)
					{
						pPoint  = GetDataPoint(*pObj);
						nSubRow = pPoint->GetRow();
						pPoint  = NULL;
					}
				}
				if(STR_STATUS_DATAPOINT_MARKED==nId)
					pPoint = GetDataPoint(*pObj);

				if (nId != 0)
				{
					if(pRow)
					{
						SchResId aSchResId(nId);
						String aStrObj( aSchResId );
						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( pRow->GetRow() + 1 ));
						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
						return aResult;
					}
					else if(nSubRow!=-1) //3D-Unterobjekte
					{
						SchResId aSchResId(nId);
						String aStrObj( aSchResId );
						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( nSubRow + 1 ));
						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
						return aResult;
					}
					if(pPoint)
					{
						long nCol=pPoint->GetCol();
						long nRow=pPoint->GetRow();
						String aText;
						long nUId=((const SfxInt32Item&)pDoc->GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue();
						ChartAxis *pAxis=pDoc->GetAxisByUID(nUId);
						long nNumf=pAxis->GetNumFormat(FALSE);

						Color* pDummy = NULL;
						pDoc->GetNumFormatter()->GetOutputString(
							pDoc->GetData(nCol,nRow),nNumf,aText,&pDummy);

						aResult = String( SchResId( STR_STATUS_DATAPOINT_MARKED ));
						aResult.SearchAndReplaceAscii( "$(PT_NUM)",  String::CreateFromInt32( nCol + 1 ) );
						aResult.SearchAndReplaceAscii( "$(ROW_NUM)", String::CreateFromInt32( nRow + 1 ) );
						aResult.SearchAndReplaceAscii( "$(VALUE)",   aText );

						return  aResult;
					}

					aResult.SearchAndReplaceAscii( "$(OBJ)", String( SchResId( nId )) );
					return  aResult;
				}
			}
		}
	}

	return E3dView::GetStatusText();
}

/*************************************************************************
|*
|* Kontext-Typ-String fuer Statusbar
|*
\************************************************************************/

String SchView::GetContextType()
{
	USHORT nDimId, nTypeId, nVariantId;
	String aString;

	switch (pDoc->ChartStyle())
	{
		case CHSTYLE_2D_LINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDLINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTLINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_COLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDCOLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTCOLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_BAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDBAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTBAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_AREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDAREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTAREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_PIE:
			nDimId		= STR_2D;
			nTypeId		= STR_CIRCLES;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_3D_STRIPE:
			nDimId		= STR_3D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_COLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_FLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_3D_STACKEDFLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_3D_AREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_STACKEDAREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_3D_PERCENTAREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_3D_PIE:
			nDimId		= STR_3D;
			nTypeId		= STR_CIRCLES;
			nVariantId	= STR_NORMAL;
			break;

		default:
			return aString;
	}

	aString += String(SchResId(nDimId));
	aString += String(SchResId(nTypeId));
	aString += sal_Unicode( ' ' );
	aString += String(SchResId(nVariantId));

	return aString;
}

/*************************************************************************
|*
|* DragServer starten
|*
\************************************************************************/

BOOL SchView::BeginDrag( Window* pWindow, Point aStartPos )
{
	BOOL bReturn = FALSE;

	if( AreObjectsMarked())
	{
		BrkAction();

		SdrMarkList aMarkList( GetMarkedObjectList());

		CreateDragDropDataObject( this, *pWindow, aStartPos );
	}

	return bReturn;
}

BOOL SchView::InsertGraphic( const Graphic& rGraphic, const Point& rPos )
{
	/**********************************************************************
	* Es wird ein neues Objekt erzeugt
	**********************************************************************/
	const SdrPage*	pPage = GetPageViewPvNum( 0 )->GetPage();
	const MapMode	aMap100( MAP_100TH_MM );
	Size			aPageSize( pPage->GetSize() );
	Size			aSize;

	// Falls der PrefMapMode der Graphic MAP_PIXEL ist,
	// machen wir die logische Umrechnung ueber das Fenster,
	// um eine 1:1-Abbildung auf Pixel zu erreichen
	OutputDevice* pOut = GetWin( 0 );
	if( pOut && rGraphic.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
		aSize = pOut->PixelToLogic( rGraphic.GetPrefSize(), aMap100 );	// #67730#
	else
		aSize = OutputDevice::LogicToLogic( rGraphic.GetPrefSize(), rGraphic.GetPrefMapMode(), aMap100 );

	// Groesse ggf. auf Seitengroesse begrenzen
	aPageSize.Width() -= pPage->GetLftBorder() + pPage->GetRgtBorder();
	aPageSize.Height() -= pPage->GetUppBorder() + pPage->GetLwrBorder();

	// Falls Grafik zu gross, wird die Grafik
	// in die Seite eingepasst
	if ( aSize.Height() && aPageSize.Height() &&
		( aSize.Height() > aPageSize.Height() ) || ( aSize.Width()	> aPageSize.Width() ) )
	{
		double fGrfWH =	(double) aSize.Width() / aSize.Height();
		double fWinWH =	(double) aPageSize.Width() / aPageSize.Height();

		// Grafik an Pagesize anpassen (skaliert)
		if ( fGrfWH < fWinWH )
		{
			aSize.Width() = (long) ( aPageSize.Height() * fGrfWH );
			aSize.Height()= aPageSize.Height();
		}
		else if ( fGrfWH > 0. )
		{
			aSize.Width() = aPageSize.Width();
			aSize.Height()= (long) ( aPageSize.Width() / fGrfWH );
		}
	}

	const Point	aPos( rPos.X() - ( aSize.Width() >> 1 ), rPos.Y() - ( aSize.Height() >> 1 ) );

    LeaveAllGroup();
	InsertObject( new SdrGrafObj( rGraphic, Rectangle( aPos, aSize ) ),
				  *GetPageViewPvNum( 0 ), SDRINSERT_SETDEFLAYER );

	return TRUE;
}

void SchView::InvalidateOneWin(Window& rWin, const Rectangle& rRect)
{
	rWin.Invalidate(rRect);
}

long SchView::GetSelectedRow() const
{
	long nRow=-1;

	if (AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = GetMarkedObjectList();

		for (USHORT nMark = 0;
			 nMark < rMarkList.GetMarkCount();// && bResult;
			 nMark++)
		{
			SdrMark* pMark = rMarkList.GetMark( 0 );
			SdrObject* pObj = pMark->GetMarkedSdrObj();
			SchDataRow *pRow=GetDataRow(*pObj);
			if(pRow)
				nRow=pRow->GetRow();
		}
	}
	return nRow;
}

/*************************************************************************
|*
|* SetDefault, die Datenpunktattribute der selektierten Datenreihe(n) loeschen
|*
\************************************************************************/

void SchView::SetDefault()
{
	CHART_TRACE( "Chart SchView::SetDefault Datenpunktattribute der selektierten Datenreihe(n) loeschen" );
	const SdrMarkList& rMarkList = GetMarkedObjectList();

	for (USHORT nMark = 0; nMark < rMarkList.GetMarkCount(); nMark++)
	{
		SdrMark* pMark = rMarkList.GetMark(0);
		SdrObject* pObj = pMark->GetMarkedSdrObj();
		SchObjectId* pObjId = GetObjectId(*pObj);

		UINT16 nObjId = pObjId->GetObjId();

		if (nObjId == CHOBJID_DIAGRAM_ROWGROUP)
		{
			// das MUSS eine Gruppe sein
			SchObjGroup* pGroup = (SchObjGroup*)pObj;
			SdrObjList* pSubList = pObj->GetSubList();

			USHORT nSubCount = (USHORT)pSubList->GetObjCount();


			if (nSubCount)
			{
				// UndoAction erzeugen
				SchUndoMultipleDataPoints* pUndoAction =
					new SchUndoMultipleDataPoints(*pDoc);

				SvxChartStyle aStyle = GetDoc().ChartStyle();

				// keine Datenpunkt-Objekte im Drawing-Layer?
				if (aStyle == CHSTYLE_2D_LINE           ||
					aStyle == CHSTYLE_2D_STACKEDLINE    ||
					aStyle == CHSTYLE_2D_PERCENTLINE    ||
					aStyle == CHSTYLE_2D_AREA           ||
					aStyle == CHSTYLE_2D_STACKEDAREA    ||
					aStyle == CHSTYLE_2D_PERCENTAREA    ||
					aStyle == CHSTYLE_3D_STRIPE         ||
					aStyle == CHSTYLE_3D_AREA           ||
					aStyle == CHSTYLE_3D_STACKEDAREA    ||
					aStyle == CHSTYLE_3D_PERCENTAREA    ||
					aStyle == CHSTYLE_3D_SURFACE        ||
					aStyle == CHSTYLE_2D_NET            ||
					aStyle == CHSTYLE_2D_NET_STACK      ||
					aStyle == CHSTYLE_2D_NET_PERCENT    ||
					aStyle == CHSTYLE_2D_CUBIC_SPLINE   ||
					aStyle == CHSTYLE_2D_B_SPLINE       ||
					aStyle == CHSTYLE_2D_CUBIC_SPLINE_XY ||
					aStyle == CHSTYLE_2D_B_SPLINE_XY    ||
					aStyle == CHSTYLE_3D_COLUMN         ||
					aStyle == CHSTYLE_3D_BAR)
				{
					SdrObject* pRow = pSubList->GetObj(0);
					SchDataRow* pDataRow = GetDataRow(*pRow);
					short nRow = pDataRow->GetRow();

					long nColCount = GetDoc().GetColCount();
					for( long nCol = 0; nCol < nColCount; nCol++ )
					{
						// an der UndoAction registrieren
						pUndoAction->AddPoint((short)nCol, (short)nRow);

						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
						aSet.ClearItem();
						GetDoc().PutDataPointAttr(nCol, nRow, aSet,FALSE);
					}
				}
				else
				{
					for (USHORT nObj = 0; nObj < nSubCount; nObj++)
					{
						SdrObject* pPoint = pSubList->GetObj(nObj);
						SchDataPoint* pDataPoint = GetDataPoint(*pPoint);
						short nCol = pDataPoint->GetCol();
						short nRow = pDataPoint->GetRow();

						// an der UndoAction registrieren
						pUndoAction->AddPoint(nCol, nRow);

						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
						aSet.ClearItem();
							// nicht mergen, nicht BuildChart rufen
						GetDoc().ChangeDataPointAttr(aSet, *pPoint, FALSE, FALSE);
					}
				}

				// die neuen Attribute in der UndoAction speichern und die
				// Action dem UndoManager uebergeben
				pUndoAction->CopyNewAttributes();

				// get undo manager from topmost shell
				if( pViewSh )
				{
					SfxUndoManager* pUndoMgr =
						pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->GetUndoManager();

					pUndoMgr->AddUndoAction( pUndoAction );
				}
			}
		}
	}
}


/*************************************************************************
|*
|* Markierungs-Handles setzen, ggf. logische 3D-Gruppen beruecksichtigen
|*
\************************************************************************/

void SchView::SetMarkHandles()
{
	SdrView::SetMarkHandles();

	SdrMark* pMark = GetSdrMarkByIndex(0);
	if( pMark )
	{
		SdrPageView* pPageView = pMark->GetPageView();
		if( pPageView )
		{
			SdrObject* pObj = pMark->GetMarkedSdrObj();

			if( pObj->ISA( Sch3dAxisObj ) )
			{
				aHdl.Clear();
				pObj->AddToHdlList( aHdl );
			}
			else
			if( ( nLogicalMarked != 0 && GetMarkedObjectCount() == 1 ) && pObj->ISA(E3dObject) )
			{
				E3dObject* p3DObj = (E3dObject*) pObj;
				USHORT nGroup = p3DObj->GetLogicalGroup();

				if ( nGroup > 0 )
				{
					SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
											   IM_DEEPWITHGROUPS);

					while ( a3DIterator.IsMore() )
					{
						p3DObj = (E3dObject*) a3DIterator.Next();
						DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");

						if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
							p3DObj->AddToHdlList(aHdl);
					}
				}
			}
		}
	}
}

/*************************************************************************
|*
|* logische Gruppe betreten
|*
\************************************************************************/

FASTBOOL SchView::EnterMarkedGroup()
{
	if ( nLogicalMarked != 0 )
	{
		nLogicalEntered = nLogicalMarked;
		nLogicalMarked = 0;
		UnmarkAll();
		return TRUE;
	}
	else
	{
		nLogicalEntered = 0;
		return SdrView::EnterMarkedGroup();
	}
}

/*************************************************************************
|*
|* logische Gruppe verlassen
|*
\************************************************************************/

void SchView::LeaveOneGroup()
{
	nLogicalMarked = 0;

	if ( nLogicalEntered != 0 )
		nLogicalEntered = 0;
	else
		SdrView::LeaveOneGroup();
}

/*************************************************************************
|*
|* alle Gruppen verlassen
|*
\************************************************************************/

void SchView::LeaveAllGroup()
{
	nLogicalMarked = 0;
	nLogicalEntered = 0;
	SdrView::LeaveAllGroup();
}


/*************************************************************************
|*
|* logische Gruppe markieren
|*
\************************************************************************/

void SchView::MarkLogicalGroup()
{
	if ( nLogicalEntered == 0 && GetMarkedObjectCount() == 1 )
	{
		SdrObject* pObj = GetMarkedObjectByIndex(0);

		if ( pObj->ISA(E3dObject) )
			nLogicalMarked = ((E3dObject*) pObj)->GetLogicalGroup();

		if ( nLogicalMarked )
		{
			FASTBOOL bVis = bHdlShown;
			if ( bVis ) HideMarkHdl(NULL);
			CheckMarked();
			SetMarkRects();
			SetMarkHandles();
			if ( bVis ) ShowMarkHdl(NULL);
		}
	}
	else
		nLogicalMarked = 0;
}

/*************************************************************************
|*
|* Objekt an Position vorhanden?
|*
\************************************************************************/


// BOOL SchView::PickObj(const Point& rPnt, short nTol, SdrObject*& rpObj, SdrPageView*& rpPV, ULONG nOptions) const
// {
// 	return PickObj(rPnt,nTol,rpObj,rpPV,nOptions,NULL,NULL,NULL);
// }

BOOL SchView::PickObj(const Point& rPnt, short nTol, SdrObject*& prObj,
                      SdrPageView*& prPV,ULONG nOptions) const
{
//  	BOOL bRet = SdrView::PickObj(rPnt, nTol, prObj, prPV, nOptions);
    BOOL bRet = ChartPickObj( rPnt, nTol, prObj, prPV, nOptions );

	if ( bRet && nLogicalEntered != 0 && prObj->ISA(E3dObject) )
	{
		E3dObject* p3DObj = (E3dObject*&) prObj;
		E3dObject* pParent = p3DObj->GetParentObj();

		if ( p3DObj->GetLogicalGroup() != nLogicalEntered && pParent &&
			 pParent->GetLogicalGroup() != nLogicalEntered )
		{
			bRet = FALSE;
			prObj = NULL;
			prPV = NULL;
		}
	}
	return bRet;
}

BOOL SchView::MarkObj(const Point& rPnt, short nTol /*=-2*/,
                      BOOL bToggle /*=FALSE*/,
                      BOOL bDeep /*=FALSE*/)
{
	SdrObject* pObj;
	SdrPageView* pPV;
	nTol=ImpGetHitTolLogic(nTol,NULL);
	ULONG nOptions=SDRSEARCH_PICKMARKABLE;
	if (bDeep) nOptions=nOptions|SDRSEARCH_DEEP;
	BOOL bRet=PickObj(rPnt,(USHORT)nTol,pObj,pPV,nOptions);
	if (bRet) {
		BOOL bUnmark=bToggle && IsObjMarked(pObj);
		MarkObj(pObj,pPV,bUnmark);
	}
	return bRet;
}

void SchView::MarkObj(SdrObject* pObj, SdrPageView* pPV, BOOL bUnmark, BOOL bImpNoSetMarkHdl)
{
    SdrMarkView::MarkObj( pObj, pPV, bUnmark, bImpNoSetMarkHdl );
}

/*************************************************************************
|*
|* markiertes Objekt (auch von logischer Gruppe) getroffen?
|*
\************************************************************************/

BOOL SchView::IsMarkedHit(const Point& rPnt, short nTol) const
{
	BOOL bRet = SdrView::IsMarkedHit(rPnt, nTol);

	// falls SvDraw kein Objekt gefunden hat, ggf. auch logische Gruppe pruefen
	if ( !bRet && nLogicalMarked != 0 )
	{
		SdrObject*	 pObj;
		SdrPageView* pPV;

		// wenn Objekt vorhanden und Gruppe uebereinstimmt -> TRUE
		if ( PickObj(rPnt, nTol, pObj, pPV) && pObj->ISA(E3dObject) &&
			((E3dObject*) pObj)->GetLogicalGroup() == nLogicalMarked )
			bRet = TRUE;
	}
	return bRet;
}

/*************************************************************************
|*
|* Liste der markierten Objekte einer logischen Gruppe zurueckgeben
|*
\************************************************************************/

E3dLogicalObjList SchView::GetLogicalObjList()
{
	E3dLogicalObjList aObjList;

	if ( nLogicalMarked != 0 && GetMarkedObjectCount() == 1 )
	{
		SdrMark*	pMark = GetSdrMarkByIndex(0);
		SdrObject*	pObj = pMark->GetMarkedSdrObj();

		if ( pObj->ISA(E3dObject) )
		{
			E3dObject* p3DObj = (E3dObject*) pObj;
			USHORT nGroup = p3DObj->GetLogicalGroup();

			if ( nGroup > 0 )
			{
				SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
											IM_DEEPWITHGROUPS);

				while ( a3DIterator.IsMore() )
				{
					p3DObj = (E3dObject*) a3DIterator.Next();
					DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");

					if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
						aObjList.Insert(p3DObj, LIST_APPEND);
				}
			}
		}
	}
	return aObjList;
}

IMPL_LINK(SchView,NotifySelection ,void*, EMPTYARG)
//void ::NotifySelection()
{
	SchMemChart* pMemChart = (SchMemChart*)pDoc->GetMemChart();
	if( pMemChart == NULL )
		return 0;

	ChartSelectionInfo aInfo;

	SdrObject	 *pObj  = NULL;
	SchDataRow	 *pRow  = NULL;
	SchDataPoint *pPoint= NULL;

	aInfo.nSelection=CHART_SEL_NONE;

	if (AreObjectsMarked())
	{
		ULONG nCount = GetMarkedObjectCount();
		if (nCount == 1)
		{
			pObj=GetMarkedObjectByIndex(0);
			SchObjectId* pId = GetObjectId(*pObj);
			if (pId)
			{
				switch (pId->GetObjId())
				{
					case CHOBJID_DIAGRAM_AREA:
					case CHOBJID_DIAGRAM:
						aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ALL;
						break;

					case CHOBJID_LEGEND_SYMBOL_ROW:
					case CHOBJID_DIAGRAM_ROWGROUP:
					case CHOBJID_DIAGRAM_ROWS:
					case CHOBJID_DIAGRAM_ROWSLINE:
					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
						{
							pRow=GetDataRow(*pObj);
							if(pRow)
							{
								if(!pDoc->IsDataSwitched())
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ROW;
									aInfo.nRow=pRow->GetRow();
								}
								else
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_COL;
									aInfo.nCol=pRow->GetRow();
								}
							}
						}
						break;
					case CHOBJID_LEGEND_SYMBOL_COL:
					case CHOBJID_DIAGRAM_DATA:
						{
							pPoint=GetDataPoint(*pObj);
							if(pPoint)
							{
							/*	SfxItemSet aAttr=pDoc->GetDataRowAttr(pPoint->GetRow());
								aAttr.Put(pDoc->GetDataPointAttr(pPoint->GetCol(),pPoint->GetRow()));	*/
								if(!pDoc->IsDataSwitched())
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
									aInfo.nCol=pPoint->GetCol();
									aInfo.nRow=pPoint->GetRow();
								}
								else
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
									aInfo.nCol=pPoint->GetRow();
									aInfo.nRow=pPoint->GetCol();
								}
							}
						}
						break;

/*					case CHOBJID_DIAGRAM_DESCRGROUP:
					case CHOBJID_DIAGRAM_DESCR_ROW:
					case CHOBJID_DIAGRAM_DESCR_COL:
					case CHOBJID_LEGEND:

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_WALL:
					case CHOBJID_DIAGRAM_FLOOR:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_DIAGRAM_X_AXIS:
					case CHOBJID_DIAGRAM_Y_AXIS:       sowie auch A,B,C:
					case CHOBJID_DIAGRAM_Z_AXIS:
					case CHOBJID_DIAGRAM_X_GRID_MAIN:
					case CHOBJID_DIAGRAM_Y_GRID_MAIN:
					case CHOBJID_DIAGRAM_Z_GRID_MAIN:
					case CHOBJID_DIAGRAM_X_GRID_HELP:
					case CHOBJID_DIAGRAM_Y_GRID_HELP:
					case CHOBJID_DIAGRAM_Z_GRID_HELP:*/
					default:
						break;
				}
			}
		}
	}
	pMemChart->SubmitSelection(aInfo);
	return 0;
}


// ********************************************************************************
//
//  Drag and Drop / Clipboard
//
// ********************************************************************************

// ========================================
// create transferable for drag&drop
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateDragDropDataObject(
	SchView* pView, Window& rWindow, const Point& rDragPos )
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;

	aObjDesc.maSize = GetAllMarkedRect().GetSize();
	aObjDesc.maDragStartPos = rDragPos;
	aObjDesc.mbCanLink = FALSE;

	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
	if( pDocShell )
    {
        pDocShell->FillTransferableObjectDescriptor( aObjDesc );
		aObjDesc.maDisplayName = pDocShell->GetMedium()->GetURLObject().GetURLNoPass();
    }

	SchTransferable* pTransferable = new SchTransferable( NULL, pView, aObjDesc, sal_False );
	Reference< datatransfer::XTransferable > xRet( pTransferable );

	SCH_MOD1()->SetDragTransferable( pTransferable );

	pTransferable->StartDrag( &rWindow, DND_ACTION_COPYMOVE | DND_ACTION_LINK );

	return xRet;
}

// ========================================
// create transferable for clipboard
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateClipboardDataObject()
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;
	const Rectangle aMarkRect = GetAllMarkedRect();

	aObjDesc.maSize = aMarkRect.GetSize();
	aObjDesc.mbCanLink = FALSE;

    SdrModel* pModel = GetMarkedObjModel();

	SchTransferable* pTransferable = new SchTransferable( pModel, NULL, aObjDesc, sal_False );
	Reference< datatransfer::XTransferable > xRet( pTransferable );

	SCH_MOD1()->SetClipboardTransferable( pTransferable );

	pTransferable->CopyToClipboard( GetWindow());

	return xRet;
}

// ========================================
// create transferable for selection clipboard
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateSelectionDataObject( SchView* pWorkView, Window& rWindow )
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;
	const Rectangle aMarkRect = GetAllMarkedRect();

	aObjDesc.maSize = aMarkRect.GetSize();
	aObjDesc.mbCanLink = FALSE;

//    SdrModel* pModel = GetMarkedObjModel();

	SchTransferable* pTransferable = new SchTransferable( NULL, pWorkView, aObjDesc, sal_True );
	Reference< datatransfer::XTransferable > xRet( pTransferable );

	SCH_MOD1()->SetSelectionClipboardTransferable( pTransferable );

    pTransferable->CopyToSelection( &rWindow );

	return xRet;
}

void SchView::UpdateSelectionClipboard( BOOL bForceDeselect )
{
    if( pViewSh && pViewSh->GetWindow() )
    {
        if( ! bForceDeselect && GetMarkedObjectList().GetMarkCount() )
            CreateSelectionDataObject( this, *pViewSh->GetWindow() );
        else if( SCH_MOD1()->GetSelectionClipboardTransferable() &&
				 ( SCH_MOD1()->GetSelectionClipboardTransferable()->GetView() == this ) )
        {
            TransferableHelper::ClearSelection( pViewSh->GetWindow() );
            SCH_MOD1()->SetSelectionClipboardTransferable( NULL );
        }
    }
}

// ========================================
// drag action requested for this view
// ========================================

sal_Int8 SchView::AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pDocSh->IsReadOnly())
		return nRet;

	SdrPageView* pPV = GetPageViewPvNum( 0 );

	if( ! pPV->IsLayerLocked( GetActiveLayer()) )
	{
		sal_Bool bIsInsideOutlinerView = sal_False;

		const OutlinerView* pOLV = GetTextEditOutlinerView();

		if( pOLV && pWin )
		{
			Rectangle aRect( pOLV->GetOutputArea() );

			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );

			if( aRect.IsInside( aPos ))
			{
				bIsInsideOutlinerView = sal_True;
			}
		}

		if( ! bIsInsideOutlinerView )
		{
			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();

			if( pDragTransferable )
			{
//  				const SchView* pSourceView = pDragTransferable->GetView();

//  				if( pSourceView )
//  				{
//  					if( !( rEvt.maDragEvent.DropAction & DND_ACTION_LINK ) ||
//  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//  						nRet = rEvt.maDragEvent.DropAction;
//  				}
			}
			// else: support of alien formats
		}
	}

	return nRet;
}

// ========================================
// drop an object into this view
// ========================================

sal_Int8 SchView::ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pDocSh->IsReadOnly())
		return nRet;

	sal_Int8 nDropAction = rEvt.mnAction;
	SdrPageView* pPV = GetPageViewPvNum( 0 );

	if( ! pPV->IsLayerLocked( GetActiveLayer()))
	{
		const OutlinerView* pOLV = GetTextEditOutlinerView();
		sal_Bool bIsInsideOutlinerView = sal_False;

		if( pOLV && pWin )
		{
			Rectangle aRect( pOLV->GetOutputArea());
			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );

			if( aRect.IsInside( aPos ))
			{
				bIsInsideOutlinerView = sal_True;
			}
		}

		if( ! bIsInsideOutlinerView )
		{
			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();

			if( pDragTransferable )
			{
//  				const SchView* pSourceView = pDragTransferable->GetView();

//  				if( pSourceView )
//  				{
//  					if( !( nDropAction & DND_ACTION_LINK ) ||
//  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//  						nRet = nDropAction;
//  				}
			}
			// else: support of alien formats
		}
	}

	return nRet;
}

// ========================================
// insert object into document
// ========================================

sal_Bool SchView::InsertData( TransferableDataHelper& rDataHelper, const Point& rPos, BOOL bCopy, ULONG nFormat )
{
    sal_Bool     bReturn  = sal_False;
    SdrPage*     pPage    = GetDoc().GetPage( 0 );

//      Reference< XInterface > xInterface( rDataHelper.GetTransferable(), UNO_QUERY );
//      SchTransferable* pOwnData = SchTransferable::getImplementation( xInterface );

//      if( pOwnData &&
//          ! ( pOwnData == SCH_MOD1()->GetDragTransferable() ||
//              pOwnData == SCH_MOD1()->GetClipboardTransferable()))
//          pOwnData = NULL;

//  	if( pOwnData && nFormat == 0 )
//  	{
        // own data
//  		const SchView* pSourceView = pOwnData->GetView();

//  		if( pSourceView )
//  		{
//  			if( pSourceView == this )
//  			{
//                  // same view
//                  TransferableObjectDescriptor aDescr;
//                  if( rDataHelper.GetTransferableObjectDescriptor( SOT_FORMAT_PRIVATE, aDescr ))
//                  {

//                      Size aVector( rPos.X() - aDescr.maDragStartPos.X(),
//                                    rPos.Y() - aDescr.maDragStartPos.Y());
//                      MoveAllMarked( aVector, bCopy );
//                  }
//  			}
//  			else
//  			{
//                  // different views

                // insert selected objects in current page
//  				ChartModel* pDoc = SAL_STATIC_CAST( ChartModel*, pSourceView->GetAllMarkedModel() );
//  				DeleteChartUserData( *pDoc );
//  				bReturn = Paste( *pDoc, rPos, pPage );
//  				delete pDoc;
//  			}
//  		}
//  		else
//  		{
//  			// internal paste

//  			ChartModel* pDoc = pOwnData->GetWorkDocument();
//  			DeleteChartUserData( *pDoc );
//  			bReturn = Paste( *pDoc, rPos, pPage );
//  		}
//  	}
//  	else
    if( ( nFormat == SOT_FORMATSTR_ID_SVXB || nFormat == 0 )&&
        rDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ))
    {
        // graphic exchange format

		SotStorageStreamRef xStm;

		if( rDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_SVXB, xStm ) )
		{
			Graphic aGraphic;
            *xStm >> aGraphic;

            InsertGraphic( aGraphic, rPos );
            bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_GDIMETAFILE || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_GDIMETAFILE ))
    {
		GDIMetaFile aMtf;

		if( rDataHelper.GetGDIMetaFile( FORMAT_GDIMETAFILE, aMtf ) )
		{
			InsertGraphic( aMtf, rPos );
			bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_BITMAP || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_BITMAP ))
    {
        Bitmap aBmp;

        if( rDataHelper.GetBitmap( FORMAT_BITMAP, aBmp ) )
		{
            InsertGraphic( aBmp, rPos );
            bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_STRING || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_STRING ))
	{
        String aString;

        if( rDataHelper.GetString( FORMAT_STRING, aString ) )
            bReturn = SdrExchangeView::Paste( aString, rPos, pPage );
	}

	MarkListHasChanged();

	return bReturn;
}

Window* SchView::GetWindow() const
{
    if( pViewSh )
        return pViewSh->GetWindow();
    return NULL;
}

/// SfxListener::Notify
void SchView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    if( rHint.ISA( SfxSimpleHint ) &&
        SAL_STATIC_CAST( const SfxSimpleHint&, rHint ).GetId() == SFX_HINT_MODECHANGED &&
        rBC.ISA( ChartModel ))
    {
        if( pViewSh )
            pViewSh->UIFeatureChanged();
    }
    else
        E3dView::Notify( rBC, rHint );
}

// #117447# old SdrMarkView::PickObj() method before fix for #110988#
#define SDRSEARCH_IMPISMASTER 0x80000000 /* MasterPage wird gerade durchsucht */
SdrObject* SchView::ImpCheckObjHit(const Point& rPnt, USHORT nTol, SdrObject* pObj, SdrPageView* pPV, ULONG nOptions, const SetOfByte* pMVisLay) const
{
	if ((nOptions & SDRSEARCH_IMPISMASTER) !=0 && pObj->IsNotVisibleAsMaster()) {
		return NULL;
	}
	BOOL bCheckIfMarkable=(nOptions & SDRSEARCH_TESTMARKABLE)!=0;
	BOOL bBack=(nOptions & SDRSEARCH_BACKWARD)!=0;
	BOOL bDeep=(nOptions & SDRSEARCH_DEEP)!=0;
	BOOL bOLE=pObj->ISA(SdrOle2Obj);
	SdrObject* pRet=NULL;
	Point aPnt1(rPnt-pPV->GetOffset()); // rPnt auf PageView transformieren
	Rectangle aRect(pObj->GetCurrentBoundRect());
	USHORT nTol2=nTol;
	// Doppelte Tolezanz fuer ein an dieser View im TextEdit befindliches Objekt
	if (bOLE || pObj==((SdrObjEditView*)this)->GetTextEditObject()) nTol2*=2;
	aRect.Left  ()-=nTol2; // Einmal Toleranz drauf fuer alle Objekte
	aRect.Top   ()-=nTol2;
	aRect.Right ()+=nTol2;
	aRect.Bottom()+=nTol2;
	if (aRect.IsInside(aPnt1)) {
		if ((!bCheckIfMarkable || IsObjMarkable(pObj,pPV))) {
			SdrObjList* pOL=pObj->GetSubList();
			if (pOL!=NULL && pOL->GetObjCount()!=0) {
				SdrObject* pTmpObj;
                // OD 30.06.2003 #108784# - adjustment hit point for virtual
                // objects.
                Point aPnt( rPnt );
                if ( pObj->ISA(SdrVirtObj) )
                {
                    Point aOffset = static_cast<SdrVirtObj*>(pObj)->GetOffset();
                    aPnt.Move( -aOffset.X(), -aOffset.Y() );
                }
                pRet=ImpCheckObjHit(aPnt,nTol,pOL,pPV,nOptions,pMVisLay,pTmpObj);
			} else {
				SdrLayerID nLay=pObj->GetLayer();
				if (pPV->GetVisibleLayers().IsSet(nLay) &&
					(pMVisLay==NULL || pMVisLay->IsSet(nLay)))
				{
					pRet=pObj->CheckHit(aPnt1,nTol2,&pPV->GetVisibleLayers());
				}
			}
		}
	}
	if (!bDeep && pRet!=NULL) pRet=pObj;
	return pRet;
}

SdrObject* SchView::ImpCheckObjHit(const Point& rPnt, USHORT nTol, SdrObjList* pOL, SdrPageView* pPV, ULONG nOptions, const SetOfByte* pMVisLay, SdrObject*& rpRootObj) const
{
	BOOL bBack=(nOptions & SDRSEARCH_BACKWARD)!=0;
	SdrObject* pRet=NULL;
	rpRootObj=NULL;
	if (pOL!=NULL) 
	{
		ULONG nObjAnz=pOL->GetObjCount();
		ULONG nObjNum=bBack ? 0 : nObjAnz;
		while (pRet==NULL && (bBack ? nObjNum<nObjAnz : nObjNum>0)) {
			if (!bBack) nObjNum--;
 			SdrObject* pObj=pOL->GetObj(nObjNum);

			pRet=ImpCheckObjHit(rPnt,nTol,pObj,pPV,nOptions,pMVisLay);
			if (pRet!=NULL) rpRootObj=pObj;
			if (bBack) nObjNum++;
		}
	}
	return pRet;
}

USHORT SchView::ImpGetHitTolLogic(short nHitTol, const OutputDevice* pOut) const
{
    USHORT nResult = 0;

    if( nHitTol >= 0 )
        nResult = nHitTol;
    else
    {
        if( pOut == 0 )
            pOut = GetWin(0);
        if( pOut != 0 )
            nResult = short( - pOut->PixelToLogic( Size( nHitTol, 0 )).Width());
	}

    return nResult;
}

BOOL SchView::ChartPickObj(
    const Point& rPnt, short nTol,
    SdrObject*& rpObj, SdrPageView*& rpPV,
    ULONG nOptions) const
{
    SortMarkedObjects();
    rpObj=NULL;
    rpPV=NULL;
    BOOL bWholePage=(nOptions & SDRSEARCH_WHOLEPAGE) !=0;
    BOOL bMarked=(nOptions & SDRSEARCH_MARKED) !=0;
    BOOL bMasters=!bMarked && (nOptions & SDRSEARCH_ALSOONMASTER) !=0;
    BOOL bBack=(nOptions & SDRSEARCH_BACKWARD) !=0;

    if (nTol<0) nTol=ImpGetHitTolLogic(nTol,NULL);
    Point aPt(rPnt);
    SdrObject* pObj=NULL;
    SdrObject* pHitObj=NULL;
    SdrPageView* pPV=NULL;
    if (!bBack && ((SdrObjEditView*)this)->IsTextEditFrameHit(rPnt)) {
        pObj=((SdrObjEditView*)this)->GetTextEditObject();
        pHitObj=pObj;
        pPV=((SdrObjEditView*)this)->GetTextEditPageView();
    }
    if (bMarked) {
        ULONG nMrkAnz=GetMarkedObjectCount();
        ULONG nMrkNum=bBack ? 0 : nMrkAnz;
        while (pHitObj==NULL && (bBack ? nMrkNum<nMrkAnz : nMrkNum>0)) {
            if (!bBack) nMrkNum--;
            SdrMark* pM=GetSdrMarkByIndex(nMrkNum);
            pObj=pM->GetMarkedSdrObj();
            pPV=pM->GetPageView();
            pHitObj=ImpCheckObjHit(aPt,nTol,pObj,pPV,nOptions,NULL);
            if (bBack) nMrkNum++;
        }
    } else {
        USHORT nPvAnz=GetPageViewCount();
        USHORT nPvNum=bBack ? 0 : nPvAnz;
        while (pHitObj==NULL && (bBack ? nPvNum<nPvAnz : nPvNum>0)) {
            if (!bBack) nPvNum--;
            pPV=GetPageViewPvNum(nPvNum);
            SdrPage* pPage=pPV->GetPage();
            USHORT nPgAnz=1;

            if(bMasters && pPage->TRG_HasMasterPage())
            {
                nPgAnz++;
            }

            BOOL bExtraPassForWholePage=bWholePage && pPage!=pPV->GetObjList();
            if (bExtraPassForWholePage) nPgAnz++; // Suche erst in AktObjList, dann auf der gesamten Page
            USHORT nPgNum=bBack ? 0 : nPgAnz;
            while (pHitObj==NULL && (bBack ? nPgNum<nPgAnz : nPgNum>0)) {
                ULONG nTmpOptions=nOptions;
                if (!bBack) nPgNum--;
                const SetOfByte* pMVisLay=NULL;
                SdrObjList* pObjList=NULL;
                if (nPgNum>=nPgAnz-1 || (bExtraPassForWholePage && nPgNum>=nPgAnz-2))
                {
                    pObjList=pPV->GetObjList();
                    if (bExtraPassForWholePage && nPgNum==nPgAnz-2) {
                        pObjList=pPage;
                    }
                }
                else
                {
                    // sonst MasterPage
                    SdrPage& rMasterPage = pPage->TRG_GetMasterPage();
                    pMVisLay = &pPage->TRG_GetMasterPageVisibleLayers();
                    pObjList = &rMasterPage;

                    nTmpOptions=nTmpOptions | SDRSEARCH_IMPISMASTER;
                }
                pHitObj=ImpCheckObjHit(aPt,nTol,pObjList,pPV,nTmpOptions,pMVisLay,pObj);
                if (bBack) nPgNum++;
            }
            if (bBack) nPvNum++;
        }

    }
    if (pHitObj!=NULL) {
        if ((nOptions & SDRSEARCH_DEEP) !=0) pObj=pHitObj;
        if ((nOptions & SDRSEARCH_TESTTEXTEDIT) !=0) {
            if (!pObj->HasTextEdit() || pPV->GetLockedLayers().IsSet(pObj->GetLayer())) {
                pObj=NULL;
            }
        }
        if (pObj!=NULL && (nOptions & SDRSEARCH_TESTMACRO) !=0) {
            Point aP(aPt); aP-=pPV->GetOffset();
            SdrObjMacroHitRec aHitRec;
            aHitRec.aPos=aPt;
            aHitRec.aDownPos=aPt;
            aHitRec.nTol=nTol;
            aHitRec.pVisiLayer=&pPV->GetVisibleLayers();
            aHitRec.pPageView=pPV;
            if (!pObj->HasMacro() || !pObj->IsMacroHit(aHitRec)) pObj=NULL;
        }
        if (pObj!=NULL && (nOptions & SDRSEARCH_WITHTEXT) !=0 && pObj->GetOutlinerParaObject()==NULL) pObj=NULL;
        if (pObj!=NULL && (nOptions & SDRSEARCH_TESTTEXTAREA) !=0) {
            Point aP(aPt); aP-=pPV->GetOffset();
            if (!pObj->IsTextEditHit(aPt,0/*nTol*/,NULL)) pObj=NULL;
        }
        if (pObj!=NULL) {
            rpObj=pObj;
            rpPV=pPV;
        }
    }
    return rpObj!=NULL;
}
