/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: array.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 13:09:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/array.hxx>

// NOT FULLY DEFINED SERVICES


namespace udm
{

Data::accessor_type
Array::inq_Type() const
{
 	return t_Array;
}

Array &
Array::access_Array()
{
 	return *this;
}




//*********************       Array_Null      *******************//

class Array_Null : public Array
{
  public:
    virtual             ~Array_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual description inq_TypeDescription() const;
    // Interface Array:
    virtual Object      op_Array(
                            uintt               i_nIndex ) const;
    virtual uintt       inq_Size() const;
};

Array_Null::~Array_Null()
{
}

void                Array_Null::do_Dispose() { }
void                Array_Null::do_BinWrite( csv::bostream & ) const    {}
Data::description   Array_Null::inq_TypeDescription() const { return "A{}"; }


Object
Array_Null::op_Array( uintt ) const
{
 	return Object();
}

uintt
Array_Null::inq_Size() const
{
 	return 0;
}


template <>
Array &
get_null<Array>( csv::Type2Type<Array> )
{
    static Array * pNull_ = new Array_Null;
    return *pNull_;
}


}   // namespace udm


