/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: nassound.cxx,v $
 *
 *  $Revision: 1.8.90.1 $
 *
 *  last change: $Author: hr $ $Date: 2006/08/10 14:56:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <salimpsound.hxx>
#include <salsound.h>

#ifdef USE_NAS

#define INT8 AU_INT8
#include <audio/audiolib.h>
#include <audio/soundlib.h>
#undef INT8

#include <salunx.h>
#include <saldata.hxx>
#include <saldisp.hxx>

#include <unistd.h>

using namespace vcl_sal;
using namespace vos;

BOOL						NASSound::s_bFailedOnce = FALSE;
NASSound::NASSoundList		NASSound::s_aSounds;
void*						NASSound::s_pServer = NULL;

void NASSound::callback( void*, void*, void* event, void* pThis )
{
	SalDbgAssert( "NASSound::callback called\n" );

	NASSound* pSound = (NASSound*)pThis;
	if( s_aSounds.GetPos( pSound ) != LIST_ENTRY_NOTFOUND )
	{
		AuEvent* pEvent = (AuEvent*)event;
		SalDbgAssert( "   on event type %d\n", pEvent->type );
		if( pSound->m_pSalSound &&
			pEvent->type == AuEventTypeElementNotify )
		{
			switch( pEvent->auelementnotify.cur_state )
			{
				case AuStateStop:
				{
					pSound->m_nFlowID = 0;
					pSound->m_pSalSound->changeStateStop();
					break;
				}
				case AuStatePause:
					pSound->m_pSalSound->changeStatePause();
					break;
				case AuStateStart:
					pSound->m_pSalSound->changeStateCont();
					break;
				default:
					break;
			}
		}
	}
	else
		SalDbgAssert( "NASSound %p is adressed in callback but unknown !\n", pSound );
}

BOOL NASSound::connect()
{
	if( ! s_pServer && ! s_bFailedOnce )
	{
		char* pServerMessage = NULL;
		s_pServer = AuOpenServer( NULL, 0, NULL, 0, NULL, &pServerMessage );
		if( ! s_pServer )
		{
			SalDbgAssert( "AuOpenServer failed: %s\n",
						  pServerMessage ?
						  pServerMessage : "<unknown reason>" );
			AuFree( pServerMessage );
			s_bFailedOnce = TRUE;
		}
		else
		{
			GetX11SalData()->GetLib()->Insert( AuServerConnectionNumber( (AuServer*)s_pServer ),
											NULL,
											(YieldFunc)pending,
											(YieldFunc)queued,
											(YieldFunc)handleEvents );
			SalDbgAssert( "AudioConnectionNumber is %d, DisplayConnectionNumber is %d\n",
						  AuServerConnectionNumber( (AuServer*)s_pServer ),
						  ConnectionNumber( GetX11SalData()->GetDisplay()->GetDisplay() ) );
		}
	}
	return s_pServer ? TRUE : FALSE;
}

void NASSound::disconnect()
{
	if( s_pServer )
	{
		GetX11SalData()->GetLib()->Remove( AuServerConnectionNumber( (AuServer*)s_pServer ) );
		AuCloseServer( (AuServer*)s_pServer );
		s_pServer = NULL;
	}
}

int NASSound::pending( int, void* )
{
	return s_pServer ? AuEventsQueued( (AuServer*)s_pServer, AuEventsQueuedAlready ) : 0;
}

int NASSound::queued( int fd, void* pDummy )
{
	return pending( fd, pDummy );
}

int NASSound::handleEvents( int, void* )
{
	if( s_pServer )
	{
		for( int i = pending(0,0); i && s_pServer; i-- )
		{
			AuEvent aEvent;
			AuNextEvent( (AuServer*)s_pServer, AuTrue, &aEvent );
			AuDispatchEvent( (AuServer*)s_pServer, &aEvent );
		}
	}
	return 1;
}

NASSound::NASSound( ::X11SalSound* pSalSound ) :
		VSound( pSalSound ),
		m_nFlowID( 0 )
{
	s_aSounds.Insert( this );
}

NASSound::~NASSound()
{
	s_aSounds.Remove( this );
	if( s_aSounds.Count() < 1 )
		disconnect();
}

void NASSound::play()
{
	BOOL bStarted = FALSE;

	if( ! s_pServer )
		connect();
	
	if( s_pServer && m_pSalSound )
	{
		AuFlowID aID;
		AuStatus aStatus;
		if( AuSoundPlayFromFile( (AuServer*)s_pServer,
								 m_pSalSound->m_aSoundFile.GetBuffer(),
								 AuNone,
								 AuFixedPointFromSum( 1, 0 ),
								 (void(*)(AuServer*,AuEventHandlerRec*,AuEvent*,void*))callback,
								 (AuPointer)this,
								 &aID,
								 NULL,
								 NULL,
								 &aStatus )
			)
		{
			SalDbgAssert( "AuSoundPlayFromFile yields flow id %d and status %d\n",
						  aID, aStatus );

 			AuElementState aState;
 			aState.flow = aID;
 			aState.element_num = 0;
 			for( int n = 0; n < 20 && ! bStarted; n++ )
 			{
                TimeValue aVal;
                aVal.Seconds = 0;
                aVal.Nanosec = 20000000;
                osl_waitThread( &aVal );
 				AuHandleEvents( (AuServer*)s_pServer );

 				int nStates = 1;
 				AuElementState* pState =
 					AuGetElementStates( (AuServer*)s_pServer,
 										&nStates,
 										&aState,
 										&aStatus );
 				if( pState )
 				{
 					if( pState->state == AuStateStart )
 						bStarted = TRUE;
 					AuFreeElementStates( (AuServer*)s_pServer,
 										 1, pState );
 				}
 				else
 				{
 					SalDbgAssert( "AuGetElementStates failed\n" );
 					break;
 				}
 			}

            if ( bStarted )
			    SalDbgAssert( "   sound started\n" );
            else
			    SalDbgAssert( "   sound failed to start\n" );

			m_pSalSound->m_bPlaying = bStarted;
			if( bStarted )
				m_nFlowID = aID;
		}
	}

	if( ! bStarted && m_pSalSound )
		m_pSalSound->setError( SOUNDERR_INVALID_FILE );
}

void NASSound::stop()
{
  	if( s_pServer && m_nFlowID )
	{
  		AuStopFlow( (AuServer*)s_pServer, m_nFlowID, NULL );
		m_nFlowID = 0;
	}
}

void NASSound::pause()
{
  	if( s_pServer && m_nFlowID )
  		AuPauseFlow( (AuServer*)s_pServer, m_nFlowID, NULL );
}

void NASSound::cont()
{
  	if( s_pServer && m_nFlowID )
  		AuStartFlow( (AuServer*)s_pServer, m_nFlowID, NULL );
}

BOOL NASSound::isValid()
{
	if( ! m_pSalSound )
		return FALSE;
	if( ! s_pServer )
		connect();
	if( ! s_pServer )
		return FALSE;

	return access( m_pSalSound->m_aSoundFile.GetBuffer(), R_OK ) ? FALSE : TRUE;
}

#endif
