/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class SimpleMerge
extends Task {
    private File dest;
    private Vector modules = new Vector();
    private List topdirs = new ArrayList();
    private List subdirs = new ArrayList();

    public void setDest(File file) {
        this.dest = file;
    }

    public void setModules(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        this.modules = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            this.modules.addElement(stringTokenizer.nextToken());
        }
    }

    public void setTopdir(File file) {
        this.topdirs.add(file);
    }

    public Topdir createTopdir() {
        return new Topdir();
    }

    public void setSubdir(String string) {
        this.subdirs.add(string);
    }

    public Subdir createSubdir() {
        return new Subdir();
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.location);
        }
        if (this.subdirs.isEmpty()) {
            throw new BuildException("You must set at least one subdir attribute", this.location);
        }
        this.log("Starting merge to " + this.dest.getAbsolutePath());
        int n = 0;
        while (n < this.topdirs.size()) {
            File file = (File)this.topdirs.get(n);
            int n2 = 0;
            while (n2 < this.modules.size()) {
                String string = (String)this.modules.elementAt(n2);
                int n3 = 0;
                while (n3 < this.subdirs.size()) {
                    String string2 = (String)this.subdirs.get(n3);
                    File file2 = new File(new File(file, string), string2);
                    if (!file2.exists()) {
                        this.log("Dir " + file2 + " does not exist, skipping...", 1);
                    } else {
                        Copy copy = (Copy)this.project.createTask("copy");
                        FileSet fileSet = new FileSet();
                        fileSet.setDir(file2);
                        copy.addFileset(fileSet);
                        copy.setTodir(this.dest);
                        copy.setIncludeEmptyDirs(true);
                        copy.init();
                        copy.setLocation(this.location);
                        copy.execute();
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.log("Merge finished");
    }

    public class Subdir {
        public void setPath(String string) {
            SimpleMerge.this.subdirs.add(string);
        }
    }

    public class Topdir {
        public void setPath(File file) {
            SimpleMerge.this.topdirs.add(file);
        }
    }
}

