/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Keymap;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class Actions {
    private static Object GLOBAL_KEYMAP;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$org$openide$awt$Actions;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    public static String findKey(SystemAction systemAction) {
        return Actions.findKey((Action)systemAction);
    }

    private static String findKey(Action action) {
        Keymap keymap = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = Actions.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (keymap == null) {
            return null;
        }
        KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
        if (keyStrokeArray.length == 0) {
            return null;
        }
        KeyStroke keyStroke = keyStrokeArray[0];
        int n = keyStroke.getModifiers();
        String string = "";
        if (n > 0) {
            string = KeyEvent.getKeyModifiersText(n);
            string = string + "+";
        } else if (keyStroke.getKeyCode() == 0) {
            return "";
        }
        string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        return string;
    }

    public static void connect(JMenuItem jMenuItem, SystemAction systemAction, boolean bl) {
        Actions.connect(jMenuItem, (Action)systemAction, bl);
    }

    static void connect(JMenuItem jMenuItem, Action action, boolean bl) {
        MenuBridge menuBridge = new MenuBridge(jMenuItem, action, bl);
        ((Bridge)menuBridge).updateState(null);
    }

    public static void connect(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
        CheckMenuBridge checkMenuBridge = new CheckMenuBridge(jCheckBoxMenuItem, booleanStateAction, bl);
        ((Bridge)checkMenuBridge).updateState(null);
    }

    public static void connect(AbstractButton abstractButton, SystemAction systemAction) {
        Actions.connect(abstractButton, (Action)systemAction);
    }

    static void connect(AbstractButton abstractButton, Action action) {
        ButtonBridge buttonBridge = new ButtonBridge(abstractButton, action);
        ((Bridge)buttonBridge).updateState(null);
    }

    public static void connect(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
        BooleanButtonBridge booleanButtonBridge = new BooleanButtonBridge(abstractButton, booleanStateAction);
        ((Bridge)booleanButtonBridge).updateState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addKeymapListener(PropertyChangeListener propertyChangeListener) {
        if (GLOBAL_KEYMAP == null) {
            Class clazz = class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = Actions.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions;
            synchronized (clazz) {
                if (GLOBAL_KEYMAP == null) {
                    try {
                        Class<?> clazz2 = Class.forName("org.openide.awt.Actions$GlobalKeymapL");
                        GLOBAL_KEYMAP = (PropertyChangeSupport)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        GLOBAL_KEYMAP = new Object();
                    }
                    catch (LinkageError linkageError) {
                        GLOBAL_KEYMAP = new Object();
                    }
                }
            }
        }
        if (GLOBAL_KEYMAP instanceof PropertyChangeSupport) {
            ((PropertyChangeSupport)GLOBAL_KEYMAP).addPropertyChangeListener(WeakListener.propertyChange(propertyChangeListener, GLOBAL_KEYMAP));
        }
    }

    private static KeyStroke[] getKeyStrokesForAction(Action action) {
        Keymap keymap = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = Actions.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (keymap != null) {
            return keymap.getKeyStrokesForAction(action);
        }
        return new KeyStroke[0];
    }

    public static void setMenuText(AbstractButton abstractButton, String string, boolean bl) {
        if (string == null) {
            abstractButton.setText(null);
            return;
        }
        int n = string.indexOf(38);
        String string2 = string;
        if (n < 0) {
            abstractButton.setText(string);
            if (bl) {
                abstractButton.setMnemonic(0);
            }
        } else if (n == string.length() - 1) {
            abstractButton.setText(string.substring(0, n));
            if (bl) {
                abstractButton.setMnemonic(0);
            }
        } else {
            abstractButton.setText(string.substring(0, n) + string.substring(n + 1));
            if (bl) {
                abstractButton.setMnemonic(string.charAt(n + 1));
            }
        }
    }

    public static String cutAmpersand(String string) {
        String string2 = string;
        int n = string.indexOf("(&");
        string2 = n >= 0 ? (n + 4 < string.length() ? string.substring(0, n) + string.substring(n + 4) : string.substring(0, n)) : ((n = string.indexOf(38)) < 0 ? string : (n == string.length() - 1 ? string.substring(0, n) : string.substring(0, n) + string.substring(n + 1)));
        return string2;
    }

    private static HelpCtx findHelp(Action action) {
        if (action instanceof SystemAction) {
            return ((SystemAction)action).getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    static void invokeAction(Action action, ActionEvent actionEvent) {
        Exception exception = null;
        try {
            Class<?> clazz = Class.forName("org.openide.actions.ActionManager");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object != null) {
                Method method = clazz.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = Actions.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = Actions.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                method.invoke(object, action, actionEvent);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            ErrorManager.getDefault().notify(1, exception);
        }
        action.actionPerformed(actionEvent);
    }

    static void prepareMargins(JMenuItem jMenuItem, Action action) {
        Insets insets = jMenuItem.getMargin();
        insets.left = 0;
        jMenuItem.setMargin(insets);
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setHorizontalAlignment(2);
    }

    static void updateKey(JMenuItem jMenuItem, Action action) {
        if (jMenuItem instanceof SubMenu || !(jMenuItem instanceof JMenu)) {
            if (jMenuItem instanceof SubMenu && !((SubMenu)jMenuItem).useAccel()) {
                jMenuItem.setAccelerator(null);
            } else {
                KeyStroke[] keyStrokeArray = Actions.getKeyStrokesForAction(action);
                if (keyStrokeArray.length != 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                } else {
                    jMenuItem.setAccelerator(null);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class GlobalKeymapL
    extends PropertyChangeSupport
    implements PropertyChangeListener,
    Runnable {
        GlobalKeymapL() {
            super(TopManager.getDefault());
            TopManager.getDefault().addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("globalKeymap" == propertyChangeEvent.getPropertyName()) {
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            this.firePropertyChange("globalKeymap", null, null);
        }
    }

    public static class SubMenu
    extends JMenuPlus {
        int previousCount = -1;
        ActionListener oneItemListener;
        private KeyStroke accelerator;
        private SubMenuModel subModel;
        static final long serialVersionUID = -4446966671302959091L;

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel) {
            this(systemAction, subMenuModel, true);
        }

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel, boolean bl) {
            this.subModel = subMenuModel;
            new SubMenuBridge(this, systemAction, subMenuModel, bl).updateState(null);
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            Component[] componentArray;
            if (keyStroke.equals(this.accelerator) && (componentArray = this.getMenuComponents()).length > 0 && componentArray[0] instanceof JComponent) {
                Action action;
                JComponent jComponent = (JComponent)componentArray[0];
                ActionMap actionMap = jComponent.getActionMap();
                if (actionMap != null && jComponent.isEnabled() && (action = actionMap.get("doClick")) != null) {
                    return SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers());
                }
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
            ActionListener actionListener;
            if (this.getMenuComponentCount() <= 1 && Arrays.equals(menuElementArray, MenuSelectionManager.defaultManager().getSelectedPath()) && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && (actionListener = this.oneItemListener) != null) {
                menuSelectionManager.setSelectedPath(new MenuElement[0]);
                actionListener.actionPerformed(new ActionEvent(keyEvent.getSource(), 0, null));
                return;
            }
            super.processKeyEvent(keyEvent, menuElementArray, menuSelectionManager);
        }

        public String getUIClassID() {
            if (this.previousCount == 0) {
                return "MenuItemUI";
            }
            return this.previousCount == 1 ? "MenuItemUI" : "MenuUI";
        }

        boolean useAccel() {
            return this.subModel.getCount() <= 1;
        }

        public void setAccelerator(KeyStroke keyStroke) {
            KeyStroke keyStroke2 = this.accelerator;
            this.accelerator = keyStroke;
            this.firePropertyChange("accelerator", keyStroke2, this.accelerator);
        }

        public KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public void menuSelectionChanged(boolean bl) {
            if (this.previousCount <= 1) {
                this.setArmed(bl);
            } else {
                super.menuSelectionChanged(bl);
            }
        }

        public void setSelected(boolean bl) {
            if (this.isEnabled() || !bl) {
                super.setSelected(bl);
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (!bl) {
                super.setSelected(false);
            }
        }

        public void doClick(int n) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.oneItemListener != null) {
                this.oneItemListener.actionPerformed(null);
            } else {
                super.doClick(n);
            }
        }
    }

    public static interface SubMenuModel {
        public int getCount();

        public String getLabel(int var1);

        public HelpCtx getHelpCtx(int var1);

        public void performActionAt(int var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static class ToolbarToggleButton
    extends org.openide.awt.ToolbarToggleButton {
        static final long serialVersionUID = -4783163952526348942L;

        public ToolbarToggleButton(BooleanStateAction booleanStateAction) {
            super((Icon)null, false);
            Actions.connect((AbstractButton)this, booleanStateAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class ToolbarButton
    extends org.openide.awt.ToolbarButton {
        static final long serialVersionUID = 6564434578524381134L;

        public ToolbarButton(SystemAction systemAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, systemAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class CheckboxMenuItem
    extends JCheckBoxMenuItem {
        static final long serialVersionUID = 6190621106981774043L;

        public CheckboxMenuItem(BooleanStateAction booleanStateAction, boolean bl) {
            Actions.connect(this, booleanStateAction, !bl);
        }
    }

    public static class MenuItem
    extends JMenuItem {
        static final long serialVersionUID = -21757335363267194L;

        public MenuItem(SystemAction systemAction, boolean bl) {
            Actions.connect((JMenuItem)this, systemAction, !bl);
        }
    }

    private static final class SubMenuBridge
    extends MenuBridge
    implements ChangeListener,
    Runnable {
        private SubMenuModel model;
        private SubMenu menu;

        public SubMenuBridge(SubMenu subMenu, SystemAction systemAction, SubMenuModel subMenuModel, boolean bl) {
            super(subMenu, systemAction, bl);
            Actions.prepareMargins(subMenu, systemAction);
            this.menu = subMenu;
            this.model = subMenuModel;
        }

        public void addNotify() {
            super.addNotify();
            this.model.addChangeListener(this);
            this.generateSubMenu();
        }

        public void removeNotify() {
            this.model.removeChangeListener(this);
            super.removeNotify();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Mutex.EVENT.readAccess(this);
        }

        public void run() {
            this.generateSubMenu();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void generateSubMenu() {
            boolean bl;
            block14: {
                block13: {
                    bl = false;
                    try {
                        this.menu.removeAll();
                        int n = this.model.getCount();
                        if (n != this.menu.previousCount) {
                            bl = true;
                        }
                        this.menu.previousCount = n;
                        if (this.menu.oneItemListener != null) {
                            this.menu.removeActionListener(this.menu.oneItemListener);
                        }
                        if (n == 0) {
                            this.menu.setEnabled(false);
                            if (this.menu.oneItemListener != null) {
                                this.menu.removeActionListener(this.menu.oneItemListener);
                                this.menu.oneItemListener = null;
                            }
                            Object var10_3 = null;
                            if (!bl) return;
                            break block13;
                        }
                        this.menu.setEnabled(true);
                        if (n == 1) {
                            this.menu.oneItemListener = new ISubActionListener(0, this.model);
                            this.menu.addActionListener(this.menu.oneItemListener);
                            HelpCtx helpCtx = this.model.getHelpCtx(0);
                            this.associateHelp(this.menu, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
                            break block14;
                        }
                        boolean bl2 = false;
                        int n2 = this.model.getCount();
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n2) {
                                this.associateHelp(this.menu, Actions.findHelp(this.action));
                                break block14;
                            }
                            String string = this.model.getLabel(n3);
                            if (string == null) {
                                bl2 = this.menu.getComponentCount() > 0;
                            } else {
                                if (bl2) {
                                    this.menu.addSeparator();
                                    bl2 = false;
                                }
                                JMenuItem jMenuItem = new JMenuItem();
                                Actions.setMenuText(jMenuItem, string, true);
                                if (n3 == 0) {
                                    Actions.updateKey(jMenuItem, this.action);
                                }
                                jMenuItem.addActionListener(new ISubActionListener(n3, this.model));
                                HelpCtx helpCtx = this.model.getHelpCtx(n3);
                                this.associateHelp(jMenuItem, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
                                this.menu.add(jMenuItem);
                            }
                            ++n3;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_5 = null;
                        if (!bl) throw throwable;
                        this.menu.updateUI();
                        throw throwable;
                    }
                }
                this.menu.updateUI();
                return;
            }
            Object var10_4 = null;
            if (!bl) return;
            this.menu.updateUI();
        }

        private void associateHelp(JComponent jComponent, HelpCtx helpCtx) {
            if (helpCtx != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString(jComponent, helpCtx.getHelpID());
            } else {
                HelpCtx.setHelpIDString(jComponent, null);
            }
        }

        private static class ISubActionListener
        implements ActionListener {
            int index;
            SubMenuModel support;

            public ISubActionListener(int n, SubMenuModel subMenuModel) {
                this.index = n;
                this.support = subMenuModel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.support.performActionAt(this.index);
            }
        }
    }

    private static final class CheckMenuBridge
    extends BooleanButtonBridge {
        private boolean popup;

        public CheckMenuBridge(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
            super((AbstractButton)jCheckBoxMenuItem, booleanStateAction);
            this.popup = bl;
            if (bl) {
                Actions.prepareMargins(jCheckBoxMenuItem, booleanStateAction);
            }
        }

        public void updateState(String string) {
            Object object;
            super.updateState(string);
            if (string == null || !string.equals("accelerator")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if ((string == null || string.equals("name")) && (object = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)object, !this.popup);
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class MenuBridge
    extends ButtonBridge {
        private boolean popup;

        public MenuBridge(JMenuItem jMenuItem, Action action, boolean bl) {
            super(jMenuItem, action);
            this.popup = bl;
            if (bl) {
                Actions.prepareMargins(jMenuItem, action);
            }
        }

        public void updateState(String string) {
            Object object;
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || !string.equals("accelerator")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if (!this.popup && (string == null || string.equals("icon")) && (object = this.action.getValue("SmallIcon")) instanceof Icon) {
                this.button.setIcon((Icon)object);
            }
            if ((string == null || string.equals("name")) && (object = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)object, !this.popup);
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class BooleanButtonBridge
    extends ButtonBridge {
        public BooleanButtonBridge(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
            super(abstractButton, (Action)booleanStateAction);
        }

        public void updateState(String string) {
            super.updateState(string);
            if (string == null || string.equals("booleanState")) {
                this.button.setSelected(((BooleanStateAction)this.action).getBooleanState());
            }
        }
    }

    private static class ButtonBridge
    extends Bridge
    implements ActionListener {
        protected AbstractButton button;

        public ButtonBridge(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
            abstractButton.addActionListener(this);
            this.button = abstractButton;
        }

        public void updateState(String string) {
            Object object;
            boolean bl = false;
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || string.equals("icon")) {
                if (this.action instanceof SystemAction) {
                    object = (SystemAction)this.action;
                    this.button.setIcon(((SystemAction)object).getIcon(this.useTextIcons()));
                } else {
                    object = this.action.getValue("SmallIcon");
                    if (object instanceof Icon) {
                        this.button.setIcon((Icon)object);
                    }
                }
            }
            if ((string == null || string.equals("ShortDescription")) && (object = (String)this.action.getValue("ShortDescription")) != null && !((String)object).equals(this.action.getValue("Name"))) {
                this.button.setToolTipText((String)object);
                bl = true;
            }
            if (!bl && (string == null || string.equals("globalKeymap"))) {
                object = Actions.findKey(this.action);
                String string2 = Actions.cutAmpersand((String)this.action.getValue("Name"));
                if (object == null || ((String)object).equals("")) {
                    this.button.setToolTipText(string2);
                } else {
                    this.button.setToolTipText(NbBundle.getMessage(class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = Actions.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions, "FMT_ButtonHint", string2, object));
                }
            }
            if (this.button instanceof Accessible && (string == null || string.equals("Name"))) {
                this.button.getAccessibleContext().setAccessibleName((String)this.action.getValue("Name"));
            }
        }

        protected boolean useTextIcons() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.invokeAction(this.action, actionEvent);
        }
    }

    private static abstract class Bridge
    implements PropertyChangeListener {
        protected JComponent comp;
        protected Action action;

        public Bridge(JComponent jComponent, Action action) {
            this.comp = jComponent;
            this.action = action;
            this.comp.addPropertyChangeListener(new VisL());
            if (this.comp.isShowing()) {
                this.addNotify();
            }
            Actions.addKeymapListener(this);
            HelpCtx helpCtx = Actions.findHelp(action);
            if (helpCtx != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString(jComponent, helpCtx.getHelpID());
            }
        }

        public void addNotify() {
            this.action.addPropertyChangeListener(this);
            this.updateState(null);
        }

        public void removeNotify() {
            this.action.removePropertyChangeListener(this);
        }

        public abstract void updateState(String var1);

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.readAccess(new Runnable(this, propertyChangeEvent){
                private final /* synthetic */ PropertyChangeEvent val$ev;
                private final /* synthetic */ Bridge this$0;
                {
                    this.this$0 = bridge;
                    this.val$ev = propertyChangeEvent;
                }

                public void run() {
                    this.this$0.updateState(this.val$ev.getPropertyName());
                }
            });
        }

        private class VisL
        implements PropertyChangeListener {
            private VisL() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        Bridge.this.addNotify();
                    } else {
                        Bridge.this.removeNotify();
                    }
                }
            }
        }
    }
}

