/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;

final class FolderChildren
extends Children.Keys
implements PropertyChangeListener {
    private DataFolder folder;
    private DataFilter filter;
    private Task initTask;
    private Task refreshTask;
    private PropertyChangeListener listener;
    private ErrorManager err;
    private static final int TIME_DELAY = 256;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_refresher");

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        this.folder = dataFolder;
        this.filter = dataFilter;
        this.listener = WeakListener.propertyChange(this, this.folder);
        this.err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPackageName('.'));
        if (!this.err.isLoggable(1)) {
            this.err = null;
        }
    }

    DataFilter getFilter() {
        return this.filter;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_CHILDREN");
            }
            this.refreshChildren();
            return;
        }
        if ("sortMode".equals(propertyChangeEvent.getPropertyName()) || "order".equals(propertyChangeEvent.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_SORT_MODE or PROP_ORDER");
            }
            this.refreshChildren();
            return;
        }
    }

    void refreshChildren() {
        this.initialize(true, false);
    }

    static Object createKey(DataObject dataObject) {
        return new Pair(dataObject.getPrimaryFile());
    }

    private static FileObject getFile(Object object) {
        return ((Pair)object).primaryFile;
    }

    protected Node[] createNodes(Object object) {
        if (this.err != null) {
            this.err.log("createNodes: " + object);
        }
        FileObject fileObject = FolderChildren.getFile(object);
        try {
            DataObject dataObject = DataObject.find(fileObject);
            if (this.filter == null || this.filter.acceptDataObject(dataObject)) {
                return new Node[]{dataObject.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, dataObjectNotFoundException);
            return new Node[0];
        }
    }

    public Node findChild(String string) {
        Node[] nodeArray = this.getNodes();
        class Jst
        implements Runnable {
            public boolean checkReadOrWrite;
            public boolean inReadAccess;
            public boolean inWriteAccess;
            private final /* synthetic */ FolderChildren this$0;

            Jst(FolderChildren folderChildren) {
                this.this$0 = folderChildren;
                this.inReadAccess = true;
                this.inWriteAccess = true;
            }

            public void run() {
                if (this.checkReadOrWrite) {
                    this.inReadAccess = false;
                } else {
                    this.inWriteAccess = false;
                }
            }
        }
        Jst jst = new Jst(this);
        Children.MUTEX.postWriteRequest(jst);
        jst.checkReadOrWrite = true;
        Children.MUTEX.postReadRequest(jst);
        if (!jst.inReadAccess && !jst.inWriteAccess) {
            this.initialize(string == null, false).waitFinished();
            this.refreshTask.waitFinished();
        }
        Node node = super.findChild(string);
        return node;
    }

    protected void addNotify() {
        this.initialize(true, true);
        this.folder.addPropertyChangeListener(this.listener);
    }

    protected void removeNotify() {
        this.folder.removePropertyChangeListener(this.listener);
        this.setKeys(Collections.EMPTY_SET);
    }

    private Task initialize(boolean bl, boolean bl2) {
        EventListener eventListener;
        Task task = this.initTask;
        if (task != null && task.isFinished()) {
            eventListener = FolderList.find(this.folder.getPrimaryFile(), true);
            ((FolderList)eventListener).waitProcessingFinished();
            task = this.initTask;
        }
        if (task != null && !bl) {
            return task;
        }
        eventListener = new Addition(bl2);
        this.initTask = task = this.folder.computeChildrenList((FolderListListener)((Object)eventListener));
        task.addTaskListener((TaskListener)eventListener);
        if (bl2) {
            ((Addition)eventListener).waitFirst();
        }
        this.refreshTask = ((Addition)eventListener).refTask;
        return task;
    }

    public String toString() {
        return this.folder.getPrimaryFile().toString();
    }

    static /* synthetic */ RequestProcessor access$100() {
        return refRP;
    }

    private static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject fileObject) {
            this.primaryFile = fileObject;
            this.seq = DataObjectPool.getPOOL().registrationCount(fileObject);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object object) {
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.primaryFile.equals(pair.primaryFile) && this.seq == pair.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }

    private class Addition
    implements TaskListener,
    FolderListListener,
    Runnable {
        static final long serialVersionUID = -4194617547214845940L;
        private long time = System.currentTimeMillis() + 256L;
        private int delay = 256;
        private boolean processingUpdate;
        private List refKeys;
        private RequestProcessor.Task refTask = FolderChildren.access$100().create(this);

        public Addition(boolean bl) {
            this.processingUpdate = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(DataObject dataObject, List list) {
            if (!FolderChildren.this.filter.acceptDataObject(dataObject)) {
                return;
            }
            boolean bl = list.isEmpty();
            list.add(dataObject);
            if (!this.processingUpdate) {
                return;
            }
            if (bl) {
                Addition addition = this;
                synchronized (addition) {
                    this.notify();
                    this.refreshKeys(list);
                }
                return;
            }
            if (System.currentTimeMillis() > this.time) {
                if (!list.isEmpty()) {
                    Addition addition = this;
                    synchronized (addition) {
                        this.refreshKeys(list);
                    }
                    this.delay *= 2;
                }
                this.time = System.currentTimeMillis() + (long)this.delay;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(List list) {
            Addition addition = this;
            synchronized (addition) {
                this.notify();
                this.refreshKeys(list);
            }
        }

        public synchronized void waitFirst() {
            try {
                this.wait(50L);
            }
            catch (InterruptedException interruptedException) {
                throw new InternalError();
            }
        }

        public void taskFinished(Task task) {
            FolderChildren.this.initTask = Task.EMPTY;
        }

        private void refreshKeys(List list) {
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("refreshKeys: " + list);
            }
            ListIterator listIterator = list.listIterator();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (listIterator.hasNext()) {
                DataObject dataObject = (DataObject)listIterator.next();
                linkedList.add(FolderChildren.createKey(dataObject));
            }
            this.refKeys = linkedList;
            this.refTask.schedule(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list;
            Addition addition = this;
            synchronized (addition) {
                list = this.refKeys;
                this.refKeys = null;
            }
            if (list != null) {
                if (FolderChildren.this.err != null) {
                    FolderChildren.this.err.log("setKeys: " + list);
                }
                FolderChildren.super.setKeys(list);
            }
        }
    }
}

