/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.windows.WindowManager;

public final class NodeOp {
    private static SystemAction[] defaultActions;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    private NodeOp() {
    }

    public static SystemAction[] getDefaultActions() {
        if (defaultActions == null) {
            defaultActions = NodeOp.createFromNames(new String[]{"Tools", "Properties"});
        }
        return defaultActions;
    }

    public static void setDefaultActions(SystemAction[] systemActionArray) {
        throw new SecurityException();
    }

    public static JPopupMenu findContextMenu(Node[] nodeArray) {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        Object object = jComponent.getClientProperty("hack.pendingNodeActivator");
        jComponent.putClientProperty("hack.pendingNodeActivator", null);
        if (object instanceof Runnable) {
            ((Runnable)object).run();
        }
        if (nodeArray.length != 1) {
            return NodeOp.findContextMenuImpl(nodeArray);
        }
        return nodeArray[0].getContextMenu();
    }

    static JPopupMenu findContextMenuImpl(Node[] nodeArray) {
        JPopupMenuPlus jPopupMenuPlus;
        block14: {
            int n;
            int n2;
            HashSet<SystemAction> hashSet;
            SystemAction[] systemActionArray;
            jPopupMenuPlus = new JPopupMenuPlus();
            HashMap<SystemAction, Integer> hashMap = new HashMap<SystemAction, Integer>();
            int n3 = 0;
            while (n3 < nodeArray.length) {
                systemActionArray = nodeArray[n3].getActions();
                if (systemActionArray == null) {
                    systemActionArray = NodeOp.getDefaultActions();
                }
                hashSet = new HashSet<SystemAction>();
                n2 = 0;
                while (n2 < systemActionArray.length) {
                    if (systemActionArray[n2] != null && !hashSet.contains(systemActionArray[n2])) {
                        hashSet.add(systemActionArray[n2]);
                        Integer n4 = (Integer)hashMap.get(systemActionArray[n2]);
                        n = n4 == null ? 0 : n4;
                        hashMap.put(systemActionArray[n2], new Integer(n + 1));
                    }
                    ++n2;
                }
                ++n3;
            }
            if (hashMap.isEmpty()) break block14;
            systemActionArray = nodeArray[0].getActions();
            if (systemActionArray == null) {
                systemActionArray = defaultActions;
            }
            hashSet = new HashSet();
            n2 = 0;
            int n5 = 0;
            while (n5 < systemActionArray.length) {
                block16: {
                    block15: {
                        int n6;
                        n = 1;
                        if (systemActionArray[n5] == null) break block15;
                        if (hashSet.contains(systemActionArray[n5])) break block16;
                        hashSet.add(systemActionArray[n5]);
                        Integer n7 = (Integer)hashMap.get(systemActionArray[n5]);
                        int n8 = n6 = n7 == null ? 0 : n7;
                        if (n6 == nodeArray.length) {
                            JMenuItem jMenuItem;
                            n = 0;
                            n2 = 1;
                            if (systemActionArray[n5] instanceof Presenter.Popup) {
                                jMenuItem = ((Presenter.Popup)((Object)systemActionArray[n5])).getPopupPresenter();
                                if (jMenuItem == null) {
                                    NullPointerException nullPointerException = new NullPointerException("findContextMenuImpl, getPopupPresenter returning null for " + systemActionArray[n5]);
                                    NodeOp.exception(nullPointerException);
                                }
                            } else {
                                jMenuItem = new JMenuItem(systemActionArray[n5].getName());
                                jMenuItem.setEnabled(false);
                            }
                            jPopupMenuPlus.add(jMenuItem);
                        }
                    }
                    if (n != 0 && n2 != 0) {
                        jPopupMenuPlus.addSeparator();
                        n2 = 0;
                    }
                }
                ++n5;
            }
        }
        return jPopupMenuPlus;
    }

    public static boolean isSon(Node node, Node node2) {
        return node2.getParentNode() == node;
    }

    public static String[] createPath(Node node, Node node2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (node != null && node != node2) {
            if (node.getName() == null) {
                boolean bl = false;
                if (node instanceof FilterNode) {
                    bl = true;
                }
                throw new IllegalArgumentException("Node:" + node.getClass() + "[" + node.getDisplayName() + "]" + (bl ? " of original:" + ((FilterNode)node).getOriginal().getClass() : "") + " gets null name!");
            }
            linkedList.addFirst(node.getName());
            node = node.getParentNode();
        }
        String[] stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    public static Node findChild(Node node, String string) {
        return node.getChildren().findChild(string);
    }

    public static Node findPath(Node node, Enumeration enumeration) throws NodeNotFoundException {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Node node2 = NodeOp.findChild(node, string);
            if (node2 == null) {
                throw new NodeNotFoundException(node, string, n);
            }
            node = node2;
            ++n;
        }
        return node;
    }

    public static Node findPath(Node node, String[] stringArray) throws NodeNotFoundException {
        return NodeOp.findPath(node, new ArrayEnumeration(stringArray));
    }

    public static Node findRoot(Node node) {
        Node node2;
        while ((node2 = node.getParentNode()) != null) {
            node = node2;
        }
        return node;
    }

    static final int[] computeSortingPermutation(Node[] nodeArray) {
        return NodeOp.computeSortingPermutation(nodeArray, null);
    }

    static final int[] computeSortingPermutation(Node[] nodeArray, Comparator comparator) {
        TreeMap<Node, Integer> treeMap = comparator == null ? new TreeMap<Node, Integer>() : new TreeMap(comparator);
        int n = 0;
        while (n < nodeArray.length) {
            treeMap.put(nodeArray[n], new Integer(n));
            ++n;
        }
        int[] nArray = new int[nodeArray.length];
        Iterator iterator = treeMap.entrySet().iterator();
        int n2 = 0;
        while (n2 < nArray.length) {
            Map.Entry entry = iterator.next();
            int n3 = (Integer)entry.getValue();
            nArray[n3] = n2++;
        }
        return nArray;
    }

    public static int[] computePermutation(Node[] nodeArray, Node[] nodeArray2) throws IllegalArgumentException {
        if (nodeArray.length != nodeArray2.length) {
            int n = Math.max(nodeArray.length, nodeArray2.length);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(n2 + " ");
                if (n2 < nodeArray.length) {
                    stringBuffer.append(nodeArray[n2].getName());
                } else {
                    stringBuffer.append("---");
                }
                stringBuffer.append(" = ");
                if (n2 < nodeArray2.length) {
                    stringBuffer.append(nodeArray2[n2].getName());
                } else {
                    stringBuffer.append("---");
                }
                stringBuffer.append('\n');
                ++n2;
            }
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        int n = 0;
        while (n < nodeArray2.length) {
            hashMap.put(nodeArray2[n], new Integer(n));
            ++n;
        }
        int[] nArray = new int[nodeArray.length];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nodeArray.length) {
            Integer n5 = (Integer)hashMap.get(nodeArray[n4]);
            if (n5 == null) {
                throw new IllegalArgumentException("Missing permutation index " + n4);
            }
            nArray[n4] = n5;
            if (nArray[n4] != n4) {
                ++n3;
            }
            ++n4;
        }
        return n3 == 0 ? null : nArray;
    }

    public static Node.Handle[] toHandles(Node[] nodeArray) {
        LinkedList<Node.Handle> linkedList = new LinkedList<Node.Handle>();
        int n = 0;
        while (n < nodeArray.length) {
            Node.Handle handle = nodeArray[n].getHandle();
            if (handle != null) {
                linkedList.add(handle);
            }
            ++n;
        }
        return linkedList.toArray(new Node.Handle[linkedList.size()]);
    }

    public static Node[] fromHandles(Node.Handle[] handleArray) throws IOException {
        Node[] nodeArray = new Node[handleArray.length];
        int n = 0;
        while (n < handleArray.length) {
            nodeArray[n] = handleArray[n].getNode();
            ++n;
        }
        return nodeArray;
    }

    static SystemAction[] createFromNames(String[] stringArray) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = NodeOp.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        LinkedList<SystemAction> linkedList = new LinkedList<SystemAction>();
        int n = 0;
        while (n < stringArray.length) {
            block5: {
                if (stringArray[n] == null) {
                    linkedList.add(null);
                } else {
                    String string = "org.openide.actions." + stringArray[n] + "Action";
                    try {
                        Class<?> clazz = Class.forName(string);
                        linkedList.add(SystemAction.get(clazz));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (errorManager == null) break block5;
                        errorManager.log(1, "NodeOp.java: Missing class " + string);
                    }
                }
            }
            ++n;
        }
        return linkedList.toArray(new SystemAction[linkedList.size()]);
    }

    static void exception(Throwable throwable) {
        ErrorManager.getDefault().notify(1, throwable);
    }

    static void warning(Throwable throwable) {
        ErrorManager.getDefault().notify(16, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

