/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.tr.Result;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MultiNamespaceResult
extends ResultBase {
    private NamespacePrefixMap[] elementMaps = new NamespacePrefixMap[20];
    private NamespacePrefixMap currentMap = null;
    private int elementDepth = 0;
    private String[] attributeNameStrings = new String[20];
    private String[] pseudoAttributeValues = new String[10];
    private int nPseudoAttributes = 0;

    public MultiNamespaceResult(OutputMethodHandler outputMethodHandler, ErrorHandler errorHandler) {
        super(outputMethodHandler, errorHandler);
    }

    public MultiNamespaceResult(DocumentHandler documentHandler, ErrorHandler errorHandler) {
        super(documentHandler, errorHandler);
    }

    private void addPseudoAttribute(String string, String string2) {
        if (this.nPseudoAttributes >= this.pseudoAttributeValues.length) {
            this.pseudoAttributeValues = ResultBase.grow(this.pseudoAttributeValues);
        }
        this.pseudoAttributeValues[this.nPseudoAttributes] = string2;
        int n = this.nPseudoAttributes++ + super.getLength();
        while (n >= this.attributeNameStrings.length) {
            this.attributeNameStrings = ResultBase.grow(this.attributeNameStrings);
        }
        this.attributeNameStrings[n] = string;
    }

    public Result createResult(String string) throws XSLException {
        OutputMethodHandler outputMethodHandler;
        if (this.outputMethodHandler != null && (outputMethodHandler = this.outputMethodHandler.createOutputMethodHandler(string)) != null) {
            return new MultiNamespaceResult(outputMethodHandler, this.errorHandler);
        }
        return null;
    }

    protected void endElementContent(Name name) throws XSLException {
        try {
            this.getDocumentHandler().endElement(name.toString());
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
        }
        this.currentMap = this.elementMaps[--this.elementDepth];
    }

    private String getAttributeNameString(Name name) throws XSLException {
        String string = name.getNamespace();
        if (string == null) {
            return name.toString();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml:" + name.getLocalPart();
        }
        String string2 = name.getPrefix();
        if (string2 != null && string.equals(this.currentMap.getNamespace(string2))) {
            return name.toString();
        }
        String string3 = this.currentMap.getPrefix(string);
        if (string3 != null) {
            return String.valueOf(string3) + ":" + name.getLocalPart();
        }
        if (string2 != null && this.currentMap.getNamespace(string2) == null) {
            this.addPseudoAttribute("xmlns:" + string2, string);
            this.currentMap = this.currentMap.bind(string2, string);
            return name.toString();
        }
        int n = 0;
        while (this.currentMap.getPrefix(string3 = "ns" + Integer.toString(n)) != null) {
            ++n;
        }
        this.addPseudoAttribute("xmlns:" + string3, string);
        this.currentMap = this.currentMap.bind(string3, string);
        return String.valueOf(string3) + ":" + name.getLocalPart();
    }

    public int getLength() {
        return super.getLength() + this.nPseudoAttributes;
    }

    public String getName(int n) {
        return this.attributeNameStrings[n];
    }

    public String getValue(int n) {
        int n2 = super.getLength();
        if (n < n2) {
            return super.getValue(n);
        }
        return this.pseudoAttributeValues[n - n2];
    }

    public void resultTreeFragment(ResultTreeFragment resultTreeFragment) throws XSLException {
        try {
            this.flush();
            resultTreeFragment.emit(this.getDocumentHandler());
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
        }
    }

    protected void startElementContent(Name name, NamespacePrefixMap namespacePrefixMap) throws XSLException {
        int n;
        int n2;
        if (this.elementDepth >= this.elementMaps.length) {
            NamespacePrefixMap[] namespacePrefixMapArray = this.elementMaps;
            this.elementMaps = new NamespacePrefixMap[namespacePrefixMapArray.length * 2];
            System.arraycopy(namespacePrefixMapArray, 0, this.elementMaps, 0, namespacePrefixMapArray.length);
        }
        this.elementMaps[this.elementDepth++] = this.currentMap;
        this.nPseudoAttributes = 0;
        if (namespacePrefixMap != this.currentMap) {
            String string;
            int n3 = namespacePrefixMap.getSize();
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                string = namespacePrefixMap.getPrefix(n4);
                String string2 = namespacePrefixMap.getNamespace(n4);
                if (this.currentMap == null || !string2.equals(this.currentMap.getNamespace(string))) {
                    n2 = 1;
                    this.addPseudoAttribute("xmlns:" + string, string2);
                }
                ++n4;
            }
            string = namespacePrefixMap.getDefaultNamespace();
            if (string == null) {
                if (this.currentMap == null) {
                    n2 = 1;
                } else if (this.currentMap.getDefaultNamespace() != null) {
                    this.addPseudoAttribute("xmlns", "");
                    n2 = 1;
                }
            } else if (this.currentMap == null || !string.equals(this.currentMap.getDefaultNamespace())) {
                n2 = 1;
                this.addPseudoAttribute("xmlns", string);
            }
            if (n2 != 0) {
                this.currentMap = namespacePrefixMap;
            }
        }
        if (this.attributeNameStrings.length <= (n = super.getLength())) {
            this.attributeNameStrings = new String[n];
        }
        n2 = 0;
        while (n2 < n) {
            this.attributeNameStrings[n2] = this.getAttributeNameString(this.getAttributeName(n2));
            ++n2;
        }
        try {
            this.getDocumentHandler().startElement(name.toString(), this);
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
        }
    }
}

