/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.FileDestination;
import com.jclark.xsl.sax.HTMLOutputHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XmlToHtml {
    static Parser createParser() {
        String string = System.getProperty("com.jclark.xsl.sax.parser");
        if (string == null) {
            string = System.getProperty("org.xml.sax.parser");
        }
        if (string == null) {
            string = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.toString());
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return new InputSource(new URL("file", "", string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static InputSource fileInputSource(String string) {
        return XmlToHtml.fileInputSource(new File(string));
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("xmltohtml xml html");
            System.exit(1);
        }
        Parser parser = XmlToHtml.createParser();
        HTMLOutputHandler hTMLOutputHandler = new HTMLOutputHandler();
        hTMLOutputHandler.init(new FileDestination(stringArray[1]), new SingleAttributeList("encoding", "iso-8859-1"));
        parser.setDocumentHandler(hTMLOutputHandler);
        try {
            parser.parse(XmlToHtml.fileInputSource(stringArray[0]));
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage());
            System.exit(1);
        }
    }

    static class EmptyAttributeList
    implements AttributeList {
        EmptyAttributeList() {
        }

        public int getLength() {
            return 0;
        }

        public String getName(int n) {
            return null;
        }

        public String getType(int n) {
            return null;
        }

        public String getType(String string) {
            return null;
        }

        public String getValue(int n) {
            return null;
        }

        public String getValue(String string) {
            return null;
        }
    }

    static class SingleAttributeList
    implements AttributeList {
        String name;
        String value;

        SingleAttributeList(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public int getLength() {
            return 0;
        }

        public String getName(int n) {
            if (n == 0) {
                return this.name;
            }
            return null;
        }

        public String getType(int n) {
            if (n == 0) {
                return "CDATA";
            }
            return null;
        }

        public String getType(String string) {
            if (string.equals(this.name)) {
                return "CDATA";
            }
            return null;
        }

        public String getValue(int n) {
            if (n == 0) {
                return this.value;
            }
            return null;
        }

        public String getValue(String string) {
            if (string.equals(this.name)) {
                return this.value;
            }
            return null;
        }
    }
}

