/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Debug;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.SQLError;
import org.gjt.mm.mysql.Util;

public abstract class MysqlIO {
    private Socket _Mysql_Conn;
    private BufferedInputStream _Mysql_Buf_Input;
    private BufferedOutputStream _Mysql_Buf_Output;
    private DataInputStream _Mysql_Input;
    private DataOutputStream _Mysql_Output;
    private ResultSet _PendingResultSet;
    static int MAXBUF = 65535;
    static final int HEADER_LENGTH = 4;
    static final int COMP_HEADER_LENGTH = 3;
    private byte _packetSequence;
    private byte _protocol_V;
    private String _Server_V;
    private int _server_major_version;
    private int _server_minor_version;
    private int _server_sub_minor_version;
    private int _port = 3306;
    private String _Host;
    private Deflater _Deflater;
    private Inflater _Inflater;
    private Buffer _ReusablePacket;
    private Buffer _SendPacket;
    SQLWarning _Warning;
    private static int CLIENT_LONG_PASSWORD = 1;
    private static int CLIENT_FOUND_ROWS = 2;
    private static int CLIENT_LONG_FLAG = 4;
    private static int CLIENT_CONNECT_WITH_DB = 8;
    private static int CLIENT_NO_SCHEMA = 16;
    private static int CLIENT_COMPRESS = 32;
    private static int CLIENT_ODBC = 64;
    private static int CLIENT_LOCAL_FILES = 128;
    private static int CLIENT_IGNORE_SPACE = 256;
    private boolean use_compression = false;
    private Connection _Conn;

    public MysqlIO(String string, int n, Connection connection) throws IOException, SQLException {
        this._Conn = connection;
        this._ReusablePacket = new Buffer(this._Conn.getNetBufferLength(), this._Conn.getMaxAllowedPacket());
        this._port = n;
        this._Host = string;
        this._Mysql_Conn = new Socket(this._Host, this._port);
        this._Mysql_Buf_Input = new BufferedInputStream(this._Mysql_Conn.getInputStream());
        this._Mysql_Buf_Output = new BufferedOutputStream(this._Mysql_Conn.getOutputStream());
        this._Mysql_Input = new DataInputStream(this._Mysql_Buf_Input);
        this._Mysql_Output = new DataOutputStream(this._Mysql_Buf_Output);
    }

    void init(String string, String string2) throws SQLException {
        try {
            int n;
            int n2;
            Buffer buffer = this.readPacket();
            this._protocol_V = buffer.readByte();
            if (this._protocol_V == -1) {
                try {
                    this._Mysql_Conn.close();
                }
                catch (Exception exception) {}
                throw new SQLException("Server configuration denies access to data source", "08001", 0);
            }
            this._Server_V = buffer.readString();
            int n3 = this._Server_V.indexOf(".");
            if (n3 != -1) {
                try {
                    int n4;
                    this._server_major_version = n4 = Integer.parseInt(this._Server_V.substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {}
                String string3 = this._Server_V.substring(n3 + 1, this._Server_V.length());
                n3 = string3.indexOf(".");
                if (n3 != -1) {
                    int n5;
                    try {
                        this._server_minor_version = n5 = Integer.parseInt(string3.substring(0, n3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    string3 = string3.substring(n3 + 1, string3.length());
                    n5 = 0;
                    while (n5 < string3.length()) {
                        if (string3.charAt(n5) < '0' || string3.charAt(n5) > '9') break;
                        ++n5;
                    }
                    try {
                        this._server_sub_minor_version = n2 = Integer.parseInt(string3.substring(0, n5));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            long l = buffer.readLong();
            String string4 = buffer.readString();
            n2 = 0;
            if (buffer.pos < buffer.buf_length) {
                n = buffer.readInt();
            }
            n2 = this._protocol_V > 9 ? (n2 |= CLIENT_LONG_PASSWORD) : (n2 &= ~CLIENT_LONG_PASSWORD);
            n = 0;
            if (string != null) {
                n = string.length();
            }
            int n6 = n + 16 + 6 + 4;
            Buffer buffer2 = new Buffer(n6);
            buffer2.writeInt(n2);
            buffer2.writeLongInt(n6);
            buffer2.writeString(string);
            if (this._protocol_V > 9) {
                buffer2.writeString(Util.newCrypt(string2, string4));
            } else {
                buffer2.writeString(Util.oldCrypt(string2, string4));
            }
            this.send(buffer2);
            Buffer buffer3 = this.readPacket();
            byte by = buffer3.readByte();
            if (by == -1) {
                String string5 = "";
                int n7 = 2000;
                if (this._protocol_V > 9) {
                    n7 = buffer3.readInt();
                    string5 = buffer3.readString();
                    this.clearReceive();
                    String string6 = SQLError.mysqlToXOpen(n7);
                    if (string6.equals("S1000")) {
                        throw new SQLException("Communication failure during handshake. Is there a server running on " + this._Host + ":" + this._port + "?");
                    }
                    throw new SQLException(String.valueOf(SQLError.get(string6)) + ": " + string5, string6, n7);
                }
                string5 = buffer3.readString();
                this.clearReceive();
                if (string5.indexOf("Access denied") != -1) {
                    throw new SQLException(String.valueOf(SQLError.get("28000")) + ": " + string5, "28000", n7);
                }
                throw new SQLException(String.valueOf(SQLError.get("08001")) + ": " + string5, "08001", n7);
            }
            if (by == 0) {
                if (this._server_major_version >= 3 && this._server_minor_version >= 22 && this._server_sub_minor_version >= 5) {
                    buffer2.newReadLength();
                    buffer2.newReadLength();
                    return;
                }
                buffer2.readLength();
                buffer2.readLength();
                return;
            }
            throw new SQLException("Unknown Status code from server", "08007", by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + iOException.getClass().getName(), "08S01", 0);
        }
    }

    String getServerVersion() {
        return this._Server_V;
    }

    final Buffer sendCommand(int n, String string, Buffer buffer) throws Exception {
        byte by;
        Buffer buffer2 = null;
        try {
            if (buffer == null) {
                int n2 = 8 + (string != null ? string.length() : 0) + 2;
                if (this._SendPacket == null) {
                    this._SendPacket = new Buffer(n2, this._Conn.getMaxAllowedPacket());
                }
                this._packetSequence = (byte)-1;
                this._SendPacket.clear();
                if (this.use_compression) {
                    this._SendPacket.pos += 3;
                }
                this._SendPacket.writeByte((byte)n);
                if (n == 2 || n == 5 || n == 6 || n == 3) {
                    this._SendPacket.writeStringNoNull(string);
                } else if (n == 12) {
                    long l = new Long(string);
                    this._SendPacket.writeLong(l);
                } else if (n == 7 && this._protocol_V > 9) {
                    Debug.msg(this, "Reload");
                }
                this.send(this._SendPacket);
            } else {
                this._packetSequence = (byte)-1;
                this.send(buffer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + exception.getClass().getName(), "08S01", 0);
        }
        try {
            buffer2 = this.readPacket();
            by = buffer2.readByte();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (Exception exception) {
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + exception.getClass().getName(), "08S01", 0);
        }
        try {
            if (by == -1) {
                int n3 = 2000;
                if (this._protocol_V > 9) {
                    n3 = buffer2.readInt();
                    String string2 = buffer2.readString();
                    this.clearReceive();
                    String string3 = SQLError.mysqlToXOpen(n3);
                    throw new SQLException(String.valueOf(SQLError.get(string3)) + ": " + string2, string3, n3);
                }
                String string4 = buffer2.readString();
                this.clearReceive();
                if (string4.indexOf("Unknown column") != -1) {
                    throw new SQLException(String.valueOf(SQLError.get("S0022")) + ": " + string4, "S0022", -1);
                }
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + string4, "S1000", -1);
            }
            if (by == 0) {
                if (n == 5 || n == 6) {
                    SQLWarning sQLWarning = new SQLWarning("Command=" + n + ": ");
                    if (this._Warning != null) {
                        sQLWarning.setNextException(this._Warning);
                    }
                    this._Warning = sQLWarning;
                }
            } else if (buffer2.isLastDataPacket()) {
                SQLWarning sQLWarning = new SQLWarning("Command=" + n + ": ");
                if (this._Warning != null) {
                    sQLWarning.setNextException(this._Warning);
                }
                this._Warning = sQLWarning;
            }
            return buffer2;
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + iOException.getClass().getName(), "08S01", 0);
        }
    }

    final ResultSet sqlQueryDirect(Buffer buffer, int n, Connection connection) throws Exception {
        long l = -1L;
        long l2 = -1L;
        this.clearAllReceive();
        Buffer buffer2 = this.sendCommand(3, null, buffer);
        --buffer2.pos;
        long l3 = buffer2.readLength();
        if (l3 == 0L) {
            try {
                if (this.versionMeetsMinimum(3, 22, 5)) {
                    long l4;
                    l = buffer2.newReadLength();
                    l2 = buffer2.newReadLength();
                    String string = buffer2.readString();
                    if (string.length() > 0 && (l4 = MysqlIO.getMatchedRows(string)) > -1L) {
                        l = l4;
                    }
                } else {
                    l = buffer2.readLength();
                    l2 = buffer2.readLength();
                }
            }
            catch (Exception exception) {
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + exception.getClass().getName(), "S1000", -1);
            }
            return this.buildResultSetWithUpdates(l, l2, connection);
        }
        return this.getResultSet(l3, n);
    }

    final ResultSet sqlQuery(String string, int n, String string2, Connection connection) throws Exception {
        int n2 = 5 + string.length() * 2 + 2;
        if (this._SendPacket == null) {
            this._SendPacket = new Buffer(n2, this._Conn.getMaxAllowedPacket());
        } else {
            this._SendPacket.clear();
        }
        this._SendPacket.writeByte((byte)3);
        if (string2 != null) {
            this._SendPacket.writeStringNoNull(string, string2);
        } else {
            this._SendPacket.writeStringNoNull(string);
        }
        return this.sqlQueryDirect(this._SendPacket, n, connection);
    }

    final ResultSet sqlQuery(String string, int n, String string2) throws Exception {
        return this.sqlQuery(string, n, string2, null);
    }

    final ResultSet sqlQuery(String string, int n) throws Exception {
        long l = -1L;
        long l2 = -1L;
        this.clearAllReceive();
        Buffer buffer = this.sendCommand(3, string, null);
        --buffer.pos;
        long l3 = buffer.readLength();
        if (l3 == 0L) {
            try {
                if (this.versionMeetsMinimum(3, 22, 5)) {
                    long l4;
                    l = buffer.newReadLength();
                    l2 = buffer.newReadLength();
                    String string2 = buffer.readString();
                    if (string2.length() > 0 && (l4 = MysqlIO.getMatchedRows(string2)) > -1L) {
                        l = l4;
                    }
                } else {
                    l = buffer.readLength();
                    l2 = buffer.readLength();
                }
            }
            catch (Exception exception) {
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + exception.getClass().getName(), "S1000", -1);
            }
            return this.buildResultSetWithUpdates(l, l2, null);
        }
        return this.getResultSet(l3, n);
    }

    protected ResultSet getResultSet(long l, int n) throws Exception {
        int n2;
        Object object;
        Object object2;
        Buffer buffer;
        Field[] fieldArray = new Field[(int)l];
        int n3 = 0;
        while ((long)n3 < l) {
            buffer = this.readPacket();
            object2 = buffer.readLenString();
            object = buffer.readLenString();
            n2 = buffer.readnBytes();
            int n4 = buffer.readnBytes();
            buffer.readByte();
            short s = (short)Buffer.ub(buffer.readByte());
            int n5 = Buffer.ub(buffer.readByte());
            fieldArray[n3] = new Field((String)object2, (String)object, n2, n4, s, n5);
            ++n3;
        }
        buffer = this.readPacket();
        object2 = new Vector();
        object = this.nextRow((int)l);
        n2 = 0;
        if (object != null) {
            ((Vector)object2).addElement(object);
            n2 = 1;
        }
        while (object != null && n2 < n) {
            object = this.nextRow((int)l);
            if (object == null) continue;
            ((Vector)object2).addElement(object);
            ++n2;
        }
        return this.buildResultSetWithRows(fieldArray, (Vector)object2, null);
    }

    private final byte[][] nextRow(int n) throws Exception {
        Buffer buffer = this.reuseAndReadPacket(this._ReusablePacket);
        if (buffer.readByte() == -1) {
            int n2 = 2000;
            if (this._protocol_V > 9) {
                n2 = buffer.readInt();
                String string = buffer.readString();
                String string2 = SQLError.mysqlToXOpen(n2);
                this.clearReceive();
                throw new SQLException(String.valueOf(SQLError.get(SQLError.get(string2))) + ": " + string, string2, n2);
            }
            String string = buffer.readString();
            this.clearReceive();
            throw new SQLException(string, SQLError.mysqlToXOpen(n2), n2);
        }
        --buffer.pos;
        int[] nArray = new int[n];
        byte[][] byArray = new byte[n][];
        if (!buffer.isLastDataPacket()) {
            int n3;
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = n3 = buffer.pos;
                buffer.pos = (int)buffer.readLength() + buffer.pos;
                ++n4;
            }
            n3 = 0;
            while (n3 < n) {
                buffer.pos = nArray[n3];
                byArray[n3] = buffer.readLenByteArray();
                ++n3;
            }
            return byArray;
        }
        return null;
    }

    final void quit() throws IOException {
        Buffer buffer = new Buffer(6);
        this._packetSequence = (byte)-1;
        buffer.writeByte((byte)1);
        this.send(buffer);
        this._Mysql_Conn.close();
    }

    final int getServerMajorVersion() {
        return this._server_major_version;
    }

    final int getServerMinorVersion() {
        return this._server_minor_version;
    }

    final int getServerSubMinorVersion() {
        return this._server_sub_minor_version;
    }

    private final Buffer readPacket() throws IOException {
        int n = this._Mysql_Input.readByte();
        int n2 = this._Mysql_Input.readByte();
        int n3 = this._Mysql_Input.readByte();
        int n4 = (n < 0 ? 256 + n : n) + 256 * (n2 < 0 ? 256 + n2 : n2) + 65536 * (n3 < 0 ? 256 + n3 : n3);
        this._Mysql_Input.readByte();
        byte[] byArray = new byte[n4 + 1];
        this._Mysql_Input.readFully(byArray, 0, n4);
        byArray[n4] = 0;
        return new Buffer(byArray);
    }

    private final Buffer reuseAndReadPacket(Buffer buffer) throws IOException {
        int n = this._Mysql_Input.readByte();
        int n2 = this._Mysql_Input.readByte();
        int n3 = this._Mysql_Input.readByte();
        int n4 = (n < 0 ? 256 + n : n) + 256 * (n2 < 0 ? 256 + n2 : n2) + 65536 * (n3 < 0 ? 256 + n3 : n3);
        this._Mysql_Input.readByte();
        buffer.pos = 0;
        buffer.send_length = 0;
        if (buffer.buf.length <= n4) {
            buffer.buf = new byte[n4 + 1];
        }
        buffer.buf_length = n4;
        this._Mysql_Input.readFully(buffer.buf, 0, n4);
        buffer.buf[n4] = 0;
        return buffer;
    }

    private final void send(Buffer buffer) throws IOException {
        int n = buffer.pos;
        this._packetSequence = (byte)(this._packetSequence + 1);
        buffer.pos = 0;
        buffer.writeLongInt(n - 4);
        buffer.writeByte(this._packetSequence);
        this._Mysql_Output.write(buffer.buf, 0, n);
        this._Mysql_Output.flush();
        this._Mysql_Buf_Output.flush();
    }

    private final void clearReceive() throws IOException {
        int n = this._Mysql_Buf_Input.available();
        if (n > 0) {
            this._Mysql_Input.skipBytes(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void clearAllReceive() throws SQLException {
        try {
            int n = this._Mysql_Buf_Input.available();
            if (n > 0) {
                Buffer buffer = this.readPacket();
                if (buffer.buf[0] == -1) {
                    this.clearReceive();
                    return;
                }
                while (!buffer.isLastDataPacket()) {
                    buffer = this.readPacket();
                    if (buffer.buf[0] != -1) continue;
                }
            }
            this.clearReceive();
            return;
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getClass().getName(), "08S01");
        }
    }

    protected abstract ResultSet buildResultSetWithRows(Field[] var1, Vector var2, Connection var3);

    protected abstract ResultSet buildResultSetWithUpdates(long var1, long var3, Connection var5);

    static int getMaxBuf() {
        return MAXBUF;
    }

    private static final int ub(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    private static final long getMatchedRows(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isDigit(c)) {
                if (bl) break;
                bl = true;
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            try {
                return Long.parseLong(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1L;
    }

    boolean versionMeetsMinimum(int n, int n2, int n3) {
        if (this._server_major_version >= n) {
            if (this._server_major_version == n) {
                if (this._server_minor_version >= n2) {
                    if (this._server_minor_version == n2) {
                        return this._server_sub_minor_version >= n3;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

