/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.jdbc2;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.jdbc2.Blob;
import org.gjt.mm.mysql.jdbc2.NotImplemented;
import org.gjt.mm.mysql.jdbc2.PreparedStatement;
import org.gjt.mm.mysql.jdbc2.ResultSetMetaData;

public class ResultSet
extends org.gjt.mm.mysql.ResultSet
implements java.sql.ResultSet {
    protected String _UpdateSQL = null;
    protected String _DeleteSQL = null;
    protected String _InsertSQL = null;
    protected PreparedStatement _Updater = null;
    protected PreparedStatement _Inserter = null;
    protected PreparedStatement _Deleter = null;
    protected Vector _PrimaryKeyIndicies = null;
    protected boolean _updatable = false;
    protected boolean _doing_updates = false;
    protected boolean _on_insert_row = false;
    protected int _fetch_direction = 1000;
    protected int _fetch_size = 0;

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.Rows, this.Fields);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new NotImplemented();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new NotImplemented();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new NotImplemented();
    }

    public boolean next() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return super.next();
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == -1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == this.Rows.size();
    }

    public synchronized boolean isFirst() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == 0;
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == this.Rows.size() - 1;
    }

    public synchronized void beforeFirst() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this.Rows.size() == 0) {
            return;
        }
        this.currentRow = -1;
        this.This_Row = null;
    }

    public void afterLast() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this.Rows.size() != 0) {
            this.currentRow = this.Rows.size();
            this.This_Row = null;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this.Rows.size() == 0) {
            return false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this.currentRow = 0;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this.currentRow = this.Rows.size() - 1;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public int getRow() throws SQLException {
        if (this.currentRow < 0 || this.currentRow > this.Rows.size() || this.Rows.size() == 0) {
            return 0;
        }
        return this.currentRow + 1;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        if (n == 0) {
            throw new SQLException("Cannot absolute position to row 0", "S1009");
        }
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (n == 1) {
            return this.first();
        }
        if (n == -1) {
            return this.last();
        }
        if (n > this.Rows.size()) {
            this.afterLast();
            return false;
        }
        if (n < 0) {
            int n2 = this.Rows.size() + n + 1;
            if (n2 <= 0) {
                this.beforeFirst();
                return false;
            }
            return this.absolute(n2);
        }
        this.currentRow = --n;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        int n2 = this.currentRow + n + 1;
        return this.absolute(n2);
    }

    public boolean previous() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return this.prev();
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001) {
            throw new SQLException("Illegal value for fetch direction", "S1009");
        }
        this._fetch_direction = n;
    }

    public int getFetchDirection() throws SQLException {
        return this._fetch_direction;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Value must be between 0 and getMaxRows()", "S1009");
        }
        this._fetch_size = n;
    }

    public int getFetchSize() throws SQLException {
        return this._fetch_size;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return this._updatable ? 1008 : 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public void updateNull(int n) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setNull(n, 0);
        } else {
            this._Inserter.setNull(n, 0);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBoolean(n, bl);
        } else {
            this._Inserter.setBoolean(n, bl);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setByte(n, by);
        } else {
            this._Inserter.setByte(n, by);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setShort(n, s);
        } else {
            this._Inserter.setShort(n, s);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setInt(n, n2);
        } else {
            this._Inserter.setInt(n, n2);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setLong(n, l);
        } else {
            this._Inserter.setLong(n, l);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setFloat(n, f);
        } else {
            this._Inserter.setFloat(n, f);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDouble(n, d);
        } else {
            this._Inserter.setDouble(n, d);
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBigDecimal(n, bigDecimal);
        } else {
            this._Inserter.setBigDecimal(n, bigDecimal);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setString(n, string);
        } else {
            this._Inserter.setString(n, string);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBytes(n, byArray);
        } else {
            this._Inserter.setBytes(n, byArray);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDate(n, date);
        } else {
            this._Inserter.setDate(n, date);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTime(n, time);
        } else {
            this._Inserter.setTime(n, time);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTimestamp(n, timestamp);
        } else {
            this._Inserter.setTimestamp(n, timestamp);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplemented();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplemented();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new NotImplemented();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(n, object);
        } else {
            this._Inserter.setObject(n, object);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(n, object);
        } else {
            this._Inserter.setObject(n, object);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplemented();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplemented();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new NotImplemented();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        if (!this._on_insert_row) {
            throw new SQLException("Not on insert row");
        }
        this._Inserter.executeUpdate();
        int n = this.Fields.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byArrayArray[n2] = this._Inserter.getBytes(n2);
            ++n2;
        }
        this.Rows.addElement(byArrayArray);
        this._Inserter.clearParameters();
    }

    public synchronized void updateRow() throws SQLException {
        if (this._doing_updates) {
            this._Updater.executeUpdate();
            int n = this.Fields.length;
            int n2 = 0;
            while (n2 < n) {
                this.This_Row[n2] = this._Updater.getBytes(n2);
                ++n2;
            }
            this._doing_updates = false;
        }
    }

    public void deleteRow() throws SQLException {
        if (this._on_insert_row) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this.Rows.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this._Deleter == null) {
            if (this._DeleteSQL == null) {
                this.generateStatements();
            }
            this._Deleter = (PreparedStatement)this.Conn.prepareStatement(this._DeleteSQL);
        }
        this._Deleter.clearParameters();
        String string = null;
        if (this.Conn.useUnicode()) {
            string = this.Conn.getEncoding();
        }
        try {
            int n = this._PrimaryKeyIndicies.size();
            if (n == 1) {
                int n2 = (Integer)this._PrimaryKeyIndicies.elementAt(0);
                String string2 = string == null ? new String(this.This_Row[n2]) : new String(this.This_Row[n2], string);
                this._Deleter.setString(1, string2);
            } else {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = (Integer)this._PrimaryKeyIndicies.elementAt(n3);
                    String string3 = string == null ? new String(this.This_Row[n4]) : new String(this.This_Row[n4], string);
                    this._Deleter.setString(n3 + 1, string3);
                    ++n3;
                }
            }
            this._Deleter.executeUpdate();
            this.Rows.removeElementAt(this.currentRow);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'");
        }
    }

    public void refreshRow() throws SQLException {
        throw new NotImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this._doing_updates) {
            this._doing_updates = false;
            this._Updater.clearParameters();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this._Inserter == null) {
            this.generateStatements();
            this._Inserter = (PreparedStatement)this.Conn.prepareStatement(this._InsertSQL);
        } else {
            this._Inserter.clearParameters();
        }
        this._on_insert_row = true;
        this._doing_updates = false;
    }

    public void moveToCurrentRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException("ResultSet not updatable");
        }
        this._on_insert_row = false;
    }

    public Statement getStatement() throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(int n) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(int n) throws SQLException {
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        return new Blob(this.This_Row[n - 1]);
    }

    public Clob getClob(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(String string) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public ResultSet(Field[] fieldArray, Vector vector, Connection connection) {
        super(fieldArray, vector, connection);
        this._updatable = this.isUpdateable();
    }

    public ResultSet(Field[] fieldArray, Vector vector) {
        super(fieldArray, vector);
    }

    public ResultSet(long l, long l2) {
        super(l, l2);
    }

    protected void generateStatements() throws SQLException {
        if (!this._updatable) {
            throw new SQLException("ResultSet not updatable");
        }
        String string = this.Fields[0].getTableName();
        this._PrimaryKeyIndicies = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (n < this.Fields.length) {
            if (this.Fields[n].isPrimaryKey()) {
                this._PrimaryKeyIndicies.addElement(new Integer(n));
                if (!bl2) {
                    stringBuffer2.append(" AND ");
                } else {
                    bl2 = false;
                }
                stringBuffer2.append(this.Fields[n].getName() + "=?");
            }
            if (bl) {
                bl = false;
                stringBuffer.append("SET ");
            } else {
                stringBuffer.append(",");
                stringBuffer3.append(",");
                stringBuffer4.append(",");
            }
            stringBuffer4.append("?");
            stringBuffer3.append(this.Fields[n].getName());
            stringBuffer.append(this.Fields[n].getName() + "=?");
            ++n;
        }
        this._UpdateSQL = "UPDATE " + string + " " + stringBuffer.toString() + " WHERE " + stringBuffer2.toString();
        this._InsertSQL = "INSERT INTO " + string + " (" + stringBuffer3.toString() + ") VALUES (" + stringBuffer4.toString() + ")";
        this._DeleteSQL = "DELETE FROM " + string + " WHERE " + stringBuffer2.toString();
    }

    synchronized void syncUpdate() throws SQLException {
        try {
            if (this._Updater == null) {
                if (this._UpdateSQL == null) {
                    this.generateStatements();
                }
                this._Updater = (PreparedStatement)this.Conn.prepareStatement(this._UpdateSQL);
            }
            int n = this.Fields.length;
            this._Updater.clearParameters();
            String string = null;
            if (this.Conn.useUnicode()) {
                string = this.Conn.getEncoding();
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.This_Row[n2] != null) {
                    String string2 = string == null ? new String(this.This_Row[n2]) : new String(this.This_Row[n2], string);
                    this._Updater.setString(n2 + 1, string2);
                } else {
                    this._Updater.setNull(n2 + 1, 0);
                }
                ++n2;
            }
            int n3 = this._PrimaryKeyIndicies.size();
            if (n3 == 1) {
                int n4 = (Integer)this._PrimaryKeyIndicies.elementAt(0);
                String string3 = string == null ? new String(this.This_Row[n4]) : new String(this.This_Row[n4], string);
                this._Updater.setString(n + 1, string3);
            } else {
                int n5 = n;
                while (n5 < n + n3 - 1) {
                    this._Updater.setBytes(n5 + 1, this.This_Row[(Integer)this._PrimaryKeyIndicies.elementAt(n5 - n)]);
                    ++n5;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'");
        }
    }

    boolean isUpdateable() {
        int n;
        if (this.Fields.length > 0) {
            String string = this.Fields[0].getTableName();
            n = 1;
            while (n < this.Fields.length) {
                if (string == null || !this.Fields[n].getTableName().equals(string)) {
                    return false;
                }
                ++n;
            }
            if (string == null || string.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        boolean bl = false;
        n = 0;
        while (n < this.Fields.length) {
            if (this.Fields[n].isPrimaryKey()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    int getResultSetType() {
        return 0;
    }
}

