/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.SigmaMathLib;
import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class BoxPlot
extends Chart {
    private final int SERIAL_NUM_CELL = 0;
    private final int DATA_NUM_CELL = 1;
    private final int EXCEPTION_NUM_CELL = 2;
    private final int AXIS_DATA_NUM_CELL = 3;
    private boolean m_connectMean;
    private boolean m_connectMedian;
    private Object[] m_group;
    private double[] m_data;
    private double[][] m_chartData;
    private double m_BoxWidth;
    private Vector m_boxData = new Vector();
    private Vector m_exceptionData = new Vector();
    private Vector m_BoxNumber = new Vector();
    private Vector m_AxisDataNum = new Vector();
    private int m_numOfBoxes;
    private String m_groupTitle;
    private String m_dataTitle;
    private double m_Ho;
    private double m_avg;
    private double m_confidenceHigh;
    private double m_confidenceLow;

    public BoxPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _data) throws InvalidInputException {
        this(_xMultiServiceFactory, _data, null);
    }

    public BoxPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _data, Object[] _group) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.ivistaportal.solibrary.Boxplot");
        if (_data == null) {
            throw new InvalidInputException("no data");
        }
        if (_group != null && _data != null && _data.length != _group.length) {
            throw new InvalidInputException("The size of data group are not the same");
        }
        if (_group == null && _data != null || _group != null && _data != null) {
            this.setData(_data);
            this.setGroup(_group);
        }
        this.setBoxWidth(5.0);
        this.setMeanConnection(false);
        this.setMedianConnection(false);
        this.setGroupTitle("");
        this.setDataTitle("");
        this.setHo(this.getEmptyValue());
        this.setAvg(this.getEmptyValue());
        this.setConfidenceHigh(this.getEmptyValue());
        this.setConfidenceLow(this.getEmptyValue());
    }

    protected void applyAppearance() throws Exception {
        this.applyXAxisStep(1.0);
        this.applyXMin(0.0);
        this.applyXMax(this.getNumOfBoxes() + 1);
        double[] minMax = new double[2];
        MathArrayUtils.getRadicalValuesWithoutEmpty((double[])this.m_chartData[1], (double[])minMax, (double)this.getNotANumber());
        double min = minMax[0];
        double max = minMax[1];
        min = Chart.changeValueByPercent(min, -10.0);
        max = Chart.changeValueByPercent(max, 10.0);
        max = Math.ceil(max);
        min = Math.floor(min);
        this.applyYMax(max);
        this.applyYMin(min);
        this.applyXAxisDescriptionVisibility(false);
        this.applyXAxisBreak(false);
        this.applyXInnerMarksMax();
        this.applySymbolsVisibility(true);
        this.applySymbolLine(false);
        this.applyLegendVisibility(false);
        this.applySeriesSymboleSandWatch(2);
        this.applySeriesSymboleInvisabile(3);
        this.applySeriesSymboleInvisabile(1);
        this.applyConnectMedian(false);
        this.applyConnectMean(false);
        this.applyXTitle(this.getGroupTitle());
        this.applyYTitle(this.getDataTitle());
        this.applyYLegendLabels();
        this.applySeriesTextLegend(3);
        if (this.m_Ho != this.getEmptyValue()) {
            this.applyHoPoint(this.m_Ho);
        }
        if (this.m_avg != this.getEmptyValue()) {
            this.applyAvgPoint(this.m_avg);
        }
        if (this.m_confidenceHigh != this.getEmptyValue()) {
            this.applyConfidenceHighLine(this.m_confidenceHigh);
        }
        if (this.m_confidenceLow != this.getEmptyValue()) {
            this.applyConfidenceLowLine(this.m_confidenceLow);
        }
    }

    private void calculateOneBox(double[] data, double _dataMin) throws Exception {
        SigmaMathLib lib = new SigmaMathLib(this.getXMultiServiceFactory());
        double Q1 = lib.quartile((Object[])FormatArrayUtils.toDouble((double[])data), 1.0);
        double Q2 = lib.quartile((Object[])FormatArrayUtils.toDouble((double[])data), 2.0);
        double mean = MathArrayUtils.arrayAverage((double[])data);
        double Q3 = lib.quartile((Object[])FormatArrayUtils.toDouble((double[])data), 3.0);
        double bottom = Q1 - 1.5 * (Q3 - Q1);
        double top = Q3 + 1.5 * (Q3 - Q1);
        double[] sortedArr = BasicArrayUtils.sort((double[])data);
        Vector<Double> V_outOfRange = new Vector<Double>();
        int j = 0;
        while ((double)j < Q1) {
            if (sortedArr[j] < bottom) {
                Double newExceptionData = new Double(sortedArr[j]);
                V_outOfRange.add(newExceptionData);
            } else if (sortedArr[j] >= bottom) break;
            ++j;
        }
        int j2 = sortedArr.length - 1;
        while ((double)j2 > Q3) {
            if (sortedArr[j2] > top) {
                Double newExceptionData = new Double(sortedArr[j2]);
                V_outOfRange.add(newExceptionData);
            } else if (sortedArr[j2] <= top) break;
            --j2;
        }
        this.m_boxData.addElement(new Double(bottom));
        this.m_boxData.addElement(new Double(Q1));
        this.m_boxData.addElement(new Double(Q2));
        this.m_boxData.addElement(new Double(mean));
        this.m_boxData.addElement(new Double(Q3));
        this.m_boxData.addElement(new Double(top));
        double boxNumber = this.m_BoxNumber.size() == 0 ? 1.0 : (Double)this.m_BoxNumber.lastElement() + 1.0;
        int i = 0;
        while (i < 6) {
            this.m_exceptionData.addElement(new Double(this.getNotANumber()));
            this.m_BoxNumber.addElement(new Double(boxNumber));
            this.m_AxisDataNum.addElement(new Double(this.getNotANumber()));
            ++i;
        }
        int i2 = 0;
        while (i2 < V_outOfRange.size()) {
            this.m_boxData.addElement(new Double(this.getNotANumber()));
            this.m_exceptionData.addElement(V_outOfRange.get(i2));
            this.m_BoxNumber.addElement(new Double(boxNumber));
            this.m_AxisDataNum.addElement(new Double(this.getNotANumber()));
            ++i2;
        }
        this.m_boxData.addElement(new Double(this.getNotANumber()));
        this.m_exceptionData.addElement(new Double(this.getNotANumber()));
        this.m_BoxNumber.addElement(new Double(boxNumber));
        this.m_AxisDataNum.addElement(new Double(_dataMin));
    }

    public double getBoxWidth() {
        return this.m_BoxWidth;
    }

    public double[] getData() {
        return this.m_data;
    }

    public String getDataTitle() {
        return this.m_dataTitle;
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    public int getNumOfBoxes() {
        return this.m_numOfBoxes;
    }

    public boolean isMeanConnect() {
        return this.m_connectMean;
    }

    public boolean isMedianConnect() {
        return this.m_connectMedian;
    }

    protected double[][] prepareChartData() throws Exception {
        double[] groups;
        HashMap groupHash = new HashMap();
        int dataSize = 4;
        if (this.getGroup() == null) {
            Object[] tmpGroup = new String[this.getData().length];
            Arrays.fill(tmpGroup, new String(""));
            groups = new double[this.getData().length];
            FormatArrayUtils.enumerate((Object[])tmpGroup, (double[])groups, groupHash);
        } else {
            groups = new double[this.getGroup().length];
            FormatArrayUtils.enumerate((Object[])this.getGroup(), (double[])groups, groupHash);
        }
        double[][] splitData = FormatArrayUtils.splitByKeyTiled((double[])groups, (double[])this.getData(), (double)this.getNotANumber());
        this.m_numOfBoxes = splitData.length;
        groups = BasicArrayUtils.sort((double[])groups);
        String[] rowsName = FormatArrayUtils.getKeysText((double[])groups, groupHash);
        double[] minMaxValues = new double[2];
        MathArrayUtils.getRadicalValues((double[])this.m_data, (double[])minMaxValues);
        minMaxValues[0] = Chart.changeValueByPercent(minMaxValues[0], -30.0);
        minMaxValues[1] = Chart.changeValueByPercent(minMaxValues[1], 10.0);
        minMaxValues[0] = Math.floor(minMaxValues[0]);
        minMaxValues[1] = Math.floor(minMaxValues[1]);
        int i = 0;
        while (i < splitData.length) {
            double[] dataEachBox = new double[splitData[i].length];
            int j = 0;
            while (j < splitData[i].length) {
                dataEachBox[j] = splitData[i][j];
                ++j;
            }
            this.calculateOneBox(dataEachBox, minMaxValues[0]);
            ++i;
        }
        this.m_chartData = new double[dataSize][this.m_boxData.size()];
        BasicArrayUtils.fill((double[][])this.m_chartData, (double)this.getNotANumber());
        int i2 = 0;
        while (i2 < this.m_boxData.size()) {
            this.m_chartData[0][i2] = (Double)this.m_BoxNumber.get(i2);
            this.m_chartData[1][i2] = (Double)this.m_boxData.get(i2);
            this.m_chartData[2][i2] = (Double)this.m_exceptionData.get(i2);
            this.m_chartData[3][i2] = (Double)this.m_AxisDataNum.get(i2);
            ++i2;
        }
        int numberOfStrting = 0;
        String[] sRowsDesc = new String[this.m_chartData[3].length];
        int i3 = 0;
        while (i3 < this.m_chartData[3].length) {
            if (this.m_chartData[3][i3] != this.getNotANumber()) {
                sRowsDesc[i3] = rowsName[numberOfStrting];
                ++numberOfStrting;
            } else {
                sRowsDesc[i3] = "";
            }
            ++i3;
        }
        this.setRowsDesc(sRowsDesc);
        return this.m_chartData;
    }

    public void setAvg(double _avg) {
        this.m_avg = _avg;
    }

    public void setBoxWidth(double _width) {
        this.m_BoxWidth = _width;
    }

    public void setConfidenceHigh(double _ch) {
        this.m_confidenceHigh = _ch;
    }

    public void setConfidenceLow(double _cl) {
        this.m_confidenceLow = _cl;
    }

    private void setData(double[] _data) {
        this.m_data = _data;
    }

    public void setDataTitle(String m_dataTitle) {
        this.m_dataTitle = m_dataTitle;
    }

    private void setGroup(Object[] _group) {
        this.m_group = _group;
    }

    public void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }

    public void setHo(double _Ho) {
        this.m_Ho = _Ho;
    }

    public void setMeanConnection(boolean _connect) {
        this.m_connectMean = _connect;
    }

    public void setMedianConnection(boolean _connect) {
        this.m_connectMedian = _connect;
    }
}

