/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.solibrary.protocols.ChartDiagramProtocol;
import com.ivistaportal.solibrary.protocols.ChartDocumentProtocol;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.awt.Size;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.lang.XMultiServiceFactory;

public abstract class Chart {
    protected final long[] COLOR = new long[]{SOColor.RED_COLOR, SOColor.DARK_SLATE_GREY_COLOR, SOColor.BLUE_COLOR, SOColor.BROWN_COLOR, SOColor.GREEN_COLOR, SOColor.LIGHT_GREY_COLOR};
    private String m_chartType;
    private String m_title;
    private XChartDocument m_xChartDocument;
    private XDiagram m_xDiagram;
    private XDiagram m_xServiceDiagram;
    private XMultiServiceFactory m_xMultiServiceFactory;
    private int m_chartYPos;
    private int m_chartXPos;
    private int m_width;
    private int m_height;
    private String[] m_columnDesc;
    private String[] m_rowsDesc;
    private double m_xMinValue;
    private double m_xMaxValue;
    private double m_yMinValue;
    private double m_yMaxValue;
    private boolean m_xAxisGridVisible;
    private boolean m_yAxisGridVisible;
    private boolean m_linesVisible;
    private boolean m_autoOrigin;
    private boolean m_visibleLegend;
    private double m_notANumber = Double.NaN;
    private int m_diagramWidthPercent = 0;
    private int m_diagramXPosPercent = 0;

    public Chart(XMultiServiceFactory _xMultiServiceFactory, String _chartType) throws NullPointerException {
        if (_xMultiServiceFactory == null) {
            throw new NullPointerException("Chart: multiservice factory was recieved as null");
        }
        if (_chartType == null) {
            throw new NullPointerException("Chart: chart type was recieved as null");
        }
        this.m_xMultiServiceFactory = _xMultiServiceFactory;
        this.setChartType(_chartType);
        this.setTitle("");
        this.setChartYPos(1000);
        this.setChartXPos(8000);
        this.setWidth(10000);
        this.setHeight(10000);
        this.setColumnDesc(null);
        this.setRowsDesc(null);
        this.setXMinValue(0.0);
        this.setYMinValue(0.0);
        this.setXMinValue(0.0);
        this.setYMinValue(0.0);
        this.setXAxisGridVisible(false);
        this.setYAxisGridVisible(false);
        this.setLinesVisible(false);
        this.setAutoOrigin(false);
        this.setVisibleLegend(true);
    }

    protected abstract void applyAppearance() throws Exception;

    protected void applyAreaLineVisible(boolean _visible) throws Exception {
        ChartDocumentProtocol.setAreaLineVisible(this.getXChartDocument(), _visible);
    }

    protected void applyAvgPoint(double _avg) throws Exception {
        ChartDiagramProtocol.setAvg(this.getXServiceDiagram(), _avg);
    }

    public void applyBoxWidth(double _width) throws Exception {
        ChartDiagramProtocol.setBoxWidth(this.getXServiceDiagram(), _width);
    }

    public void applyChartAppearance() throws Exception {
        this.applyDiagramBgColor();
        this.showGrid();
        this.applyAreaLineVisible(true);
        this.applyMainTitle();
        if (this.getDiagramWidthPercent() > 0 && this.getDiagramWidthPercent() <= 100) {
            int diagramWidth = this.getDrawingSize().Width;
            diagramWidth = diagramWidth * this.getDiagramWidthPercent() / 100;
            Size size = ChartDiagramProtocol.getDrawingSize(this.getXDiagram());
            ChartDiagramProtocol.setDrawingSize(this.getXDiagram(), size.Width * diagramWidth, size.Height);
        }
        if (this.getDiagramXPosPercent() > 0 && this.getDiagramXPosPercent() <= 100) {
            int diagramXPos = ChartDiagramProtocol.getDiagramXPosition(this.getXDiagram());
            diagramXPos = diagramXPos * this.getDiagramXPosPercent() / 100;
            ChartDiagramProtocol.setDiagramXPosition(this.getXDiagram(), diagramXPos);
        }
    }

    protected void applyChartData(double[][] _newChartData) throws Exception {
        ChartDocumentProtocol.setChartData(this.getXChartDocument(), FormatArrayUtils.rotateMatrix((double[][])_newChartData));
    }

    public void applyChartProperties() throws Exception {
        if (this.getXChartDocument() == null && this.getXDiagram() == null && this.getXServiceDiagram() == null) {
            return;
        }
        this.applyChartProperties(this.getXChartDocument(), this.getXServiceDiagram(), this.getNotANumber());
    }

    public void applyChartProperties(XChartDocument _xChartDocument, XDiagram _xServiceDiagram) throws Exception {
        this.applyChartProperties(_xChartDocument, _xServiceDiagram, ChartDocumentProtocol.getNotANumber(_xChartDocument));
    }

    public void applyChartProperties(XChartDocument _xChartDocument, XDiagram _xServiceDiagram, double _notANumber) throws Exception {
        if (_xChartDocument == null || _xServiceDiagram == null) {
            throw new NullPointerException("Chart: chart doc or chart diagram are null");
        }
        this.setXChartDocument(_xChartDocument);
        this.m_xDiagram = ChartDocumentProtocol.getXDiagram(this.getXChartDocument());
        this.m_xServiceDiagram = _xServiceDiagram;
        this.setNotANumber(_notANumber);
        double[][] chartData = this.prepareChartData();
        double[][] newChartData = FormatArrayUtils.rotateMatrix((double[][])chartData);
        ChartDocumentProtocol.setChartData(this.getXChartDocument(), newChartData);
        int i = 0;
        while (i < chartData.length) {
            this.applyDataRowPrimaryYAxis(i);
            ++i;
        }
        this.applyChartAppearance();
        this.applyAppearance();
    }

    protected void applyChartType(String _chartType) throws Exception {
        this.m_xServiceDiagram = ChartDocumentProtocol.setChartType(this.getXChartDocument(), _chartType);
    }

    protected void applyConfidenceHighLine(double _ch) throws Exception {
        ChartDiagramProtocol.setConfidenceHigh(this.getXServiceDiagram(), _ch);
    }

    protected void applyConfidenceLowLine(double _cl) throws Exception {
        ChartDiagramProtocol.setConfidenceLow(this.getXServiceDiagram(), _cl);
    }

    public void applyConnectMean(boolean _connect) throws Exception {
        ChartDiagramProtocol.applyConnectMean(this.getXServiceDiagram(), _connect);
    }

    public void applyConnectMedian(boolean _connect) throws Exception {
        ChartDiagramProtocol.applyconnectMedian(this.getXServiceDiagram(), _connect);
    }

    protected void applyDataRowPrimaryYAxis(int _dataRow) throws Exception {
        ChartDiagramProtocol.setDataRowPrimaryYAxis(this.getXDiagram(), _dataRow, true);
    }

    protected void applyDiagramBgColor() throws Exception {
        ChartDiagramProtocol.setDiagramBgColor(this.getXDiagram());
    }

    protected void applyDiagramXPosition(int _x) throws Exception {
        ChartDiagramProtocol.setDiagramXPosition(this.getXDiagram(), _x);
    }

    protected void applyDrawingXPos(int _xPos) throws Exception {
        ChartDiagramProtocol.setDiagramXPosition(this.getXDiagram(), _xPos);
    }

    protected void applyGridDashed() throws Exception {
        this.showGrid(true, true);
        ChartDiagramProtocol.setYGridDashed(this.getXDiagram());
        ChartDiagramProtocol.setXGridDashed(this.getXDiagram());
    }

    protected void applyHoPoint(double _Ho) throws Exception {
        ChartDiagramProtocol.setHo(this.getXServiceDiagram(), _Ho);
    }

    protected void applyLclVerticalLine(double _lcl) throws Exception {
        ChartDiagramProtocol.setLcl(this.getXServiceDiagram(), _lcl);
    }

    protected void applyLegendBg() throws Exception {
        ChartDocumentProtocol.setLegendBg(this.getXChartDocument());
    }

    protected void applyLegendVisibility() throws Exception {
        ChartDocumentProtocol.setLegendVisibility(this.getXChartDocument(), this.isVisibleLegend());
    }

    protected void applyLegendVisibility(boolean _visible) throws Exception {
        ChartDocumentProtocol.setLegendVisibility(this.getXChartDocument(), _visible);
    }

    protected void applyLineWidth(int _lineWidth) throws Exception {
        ChartDiagramProtocol.setLineWidth(this.getXDiagram(), _lineWidth);
    }

    protected void applyLinearRegression(boolean _isReg) throws Exception {
        ChartDiagramProtocol.setLinearRegressoin(this.getXDiagram(), _isReg);
    }

    protected void applyMainTitle() throws Exception {
        ChartDocumentProtocol.setTitleString(this.getXChartDocument(), this.getTitle());
    }

    protected void applyMainTitle(String _title) throws Exception {
        ChartDocumentProtocol.setTitleString(this.getXChartDocument(), _title);
    }

    protected void applyNumOfLines(int _numberOfLines) throws Exception {
        ChartDiagramProtocol.setNumberOfLines(this.getXDiagram(), _numberOfLines);
    }

    protected void applyPointSymbolVisibility(int _col, int _row, boolean _visible) throws Exception {
        ChartDiagramProtocol.setPointSymbolVisibility(this.getXDiagram(), _col, _row, _visible);
    }

    protected void applyPointTextColor(int _col, int _row, long _color) throws Exception {
        ChartDiagramProtocol.setPointTextColor(this.getXDiagram(), _col, _row, _color);
    }

    protected void applyPointTextLegend(int _col, int _row) throws Exception {
        ChartDiagramProtocol.setPointTextLegend(this.getXDiagram(), _col, _row);
    }

    protected void applyRectSymbols() throws Exception {
        ChartDiagramProtocol.setSymbolesType(this.getXDiagram(), 0);
    }

    protected void applyRoundSymbols() throws Exception {
        ChartDocumentProtocol.setRoundSymbols(this.getXChartDocument());
    }

    protected void applySeiresSymboleSize(int _rowDataNum, int _size) throws Exception {
        ChartDiagramProtocol.setSeriesSymboleSize(this.getXDiagram(), _rowDataNum, _size);
    }

    protected void applySeriesColor(int _seriesNo, long _color) throws Exception {
        ChartDiagramProtocol.setDataRowColor(this.getXDiagram(), _seriesNo, _color);
    }

    protected void applySeriesLineColor(int _seriesNo, long _color) throws Exception {
        ChartDiagramProtocol.setSeriesLineColor(this.getXDiagram(), _seriesNo, _color);
    }

    protected void applySeriesLineVisible(int _seriesNo, boolean _visible) throws Exception {
        ChartDiagramProtocol.setDataRowLineVisibile(this.getXDiagram(), _seriesNo, _visible);
    }

    protected void applySeriesLineWidth(int _rowNum, int _lineWidth) throws Exception {
        ChartDiagramProtocol.setSeriesLineWidth(this.getXDiagram(), _rowNum, _lineWidth);
    }

    protected void applySeriesLinesVisibile(int _dataRow, boolean _isLinesVisible) throws Exception {
        ChartDiagramProtocol.setSeriesLineVisibility(this.getXDiagram(), _dataRow, _isLinesVisible);
    }

    protected void applySeriesPointsLineVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setSeriesPointsLineVisibility(this.getXDiagram(), _visible);
    }

    protected void applySeriesSymboleInvisabile(int _row) throws Exception {
        ChartDiagramProtocol.setSeriesSymbolsType(this.getXDiagram(), _row, 9);
    }

    protected void applySeriesSymboleSandWatch(int _row) throws Exception {
        ChartDiagramProtocol.setSeriesSymbolsType(this.getXDiagram(), _row, 7);
    }

    protected void applySeriesSymboleType(int _type, int rowNum) throws Exception {
        ChartDiagramProtocol.setSeriesSymbolsType(this.getXDiagram(), rowNum, _type);
    }

    protected void applySeriesTextColor(int _dataRow, long _color) throws Exception {
        ChartDiagramProtocol.setSeriesTextColor(this.getXDiagram(), _dataRow, _color);
    }

    protected void applySeriesTextLegend(int _dataRow) throws Exception {
        ChartDiagramProtocol.setSeriesTextLegend(this.getXDiagram(), _dataRow);
    }

    protected void applySeriesTriangleSymbols(int _row) throws Exception {
        ChartDiagramProtocol.setSeriesSymbolsType(this.getXDiagram(), _row, 3);
    }

    protected void applyStacked(boolean _isStacked) throws Exception {
        ChartDiagramProtocol.setStacked(this.getXDiagram(), _isStacked);
    }

    protected void applySymbolLine(boolean _visible) throws Exception {
        ChartDiagramProtocol.setSymbolLine(this.getXDiagram(), _visible);
    }

    protected void applySymbolesSize(int _size) throws Exception {
        ChartDiagramProtocol.setSymbolesSize(this.getXDiagram(), _size);
    }

    protected void applySymbolsVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setSymbolsVisibility(this.getXDiagram(), _visible);
    }

    protected void applyTextLegendSymbols(boolean _isVisibleLegendSymbols) throws Exception {
        ChartDiagramProtocol.setTextLegendSymbols(this.getXDiagram(), _isVisibleLegendSymbols);
    }

    protected void applyUclVerticalLine(double _ucl) throws Exception {
        ChartDiagramProtocol.setUcl(this.getXServiceDiagram(), _ucl);
    }

    protected void applyUnvisibleBar(int _barNo) throws Exception {
        ChartDiagramProtocol.setDataRowVisibility(this.getXDiagram(), _barNo, false);
    }

    protected void applyUnvisibleSymbols(int _seriesNo) throws Exception {
        ChartDiagramProtocol.setSeriesSymbolsVisibility(this.getXDiagram(), _seriesNo, false);
    }

    protected void applyVertical(boolean _isVertical) throws Exception {
        ChartDiagramProtocol.setVertical(this.getXDiagram(), _isVertical);
    }

    protected void applyXAutoMax(boolean _autoMaxX) throws Exception {
        ChartDiagramProtocol.applyXAutoMax(this.getXDiagram(), _autoMaxX);
    }

    protected void applyXAutoMin(boolean _autoMinX) throws Exception {
        ChartDiagramProtocol.applyXAutoMin(this.getXDiagram(), _autoMinX);
    }

    protected void applyXAxisBreak(boolean _isBroken) throws Exception {
        ChartDiagramProtocol.setXAxisBreak(this.getXServiceDiagram(), _isBroken);
    }

    protected void applyXAxisDescriptionVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setXAxisDescriptionVisibility(this.getXDiagram(), _visible);
    }

    protected void applyXAxisMarksVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setXAxisMarksVisibility(this.getXDiagram(), _visible);
    }

    protected void applyXAxisStep(double _step) throws Exception {
        ChartDiagramProtocol.setXAxisStep(this.getXDiagram(), _step);
    }

    protected void applyXGapWidth(int _xGapWidth) throws Exception {
        ChartDiagramProtocol.setXGapWidth(this.getXDiagram(), _xGapWidth);
    }

    protected void applyXInnerMarksMax() throws Exception {
        ChartDiagramProtocol.applyXInnerMarksMax(this.getXDiagram());
    }

    protected void applyXLegendLabels() throws Exception {
        if (this.getColumnDesc() != null) {
            ChartDocumentProtocol.setXLegendLabels(this.getXChartDocument(), this.getColumnDesc(), true);
        }
    }

    protected void applyXLegendLabelsNoHeader() throws Exception {
        if (this.getColumnDesc() != null) {
            ChartDocumentProtocol.setXLegendLabels(this.getXChartDocument(), this.getColumnDesc(), false);
        }
    }

    protected void applyXMax(double _xMax) throws Exception {
        ChartDiagramProtocol.applyXMax(this.getXDiagram(), _xMax);
    }

    protected void applyXMin(double _xMin) throws Exception {
        ChartDiagramProtocol.applyXMin(this.getXDiagram(), _xMin);
    }

    protected void applyXTitle(String _title) throws Exception {
        ChartDiagramProtocol.setXAxisTitle(this.getXDiagram(), _title);
    }

    protected void applyYAutoMax(boolean _autoMaxY) throws Exception {
        ChartDiagramProtocol.applyYAutoMax(this.getXDiagram(), _autoMaxY);
    }

    protected void applyYAutoMin(boolean _autoMinY) throws Exception {
        ChartDiagramProtocol.applyYAutoMin(this.getXDiagram(), _autoMinY);
    }

    protected void applyYAutoOrigin(boolean _isAutoOrigin) throws Exception {
        ChartDiagramProtocol.applyYAutoOrigin(this.getXDiagram(), _isAutoOrigin);
    }

    protected void applyYAxisDescriptionVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setYAxisDescriptionVisibility(this.getXDiagram(), _visible);
    }

    protected void applyYAxisGridDashed() throws Exception {
        ChartDiagramProtocol.setYAxisGridDashed(this.getXDiagram());
    }

    protected void applyYAxisMarksVisibility(boolean _visible) throws Exception {
        ChartDiagramProtocol.setYAxisMarksVisibility(this.getXDiagram(), _visible);
    }

    protected void applyYAxisStep(double _step) throws Exception {
        ChartDiagramProtocol.setYAxisStep(this.getXDiagram(), _step);
    }

    protected void applyYLegendLabels() throws Exception {
        if (this.getRowsDesc() != null) {
            ChartDocumentProtocol.setYLegendLabels(this.getXChartDocument(), this.getRowsDesc());
        }
    }

    protected void applyYMax() throws Exception {
        if (this.getYMinValue() != this.getYMaxValue()) {
            ChartDiagramProtocol.applyYMax(this.getXDiagram(), this.getYMaxValue());
        }
    }

    protected void applyYMax(double _yMaxValue) throws Exception {
        ChartDiagramProtocol.applyYMax(this.getXDiagram(), _yMaxValue);
    }

    protected void applyYMin() throws Exception {
        if (this.getYMinValue() != this.getYMaxValue()) {
            ChartDiagramProtocol.applyYMin(this.getXDiagram(), this.getYMinValue());
        }
    }

    protected void applyYMin(double _yMinValue) throws Exception {
        ChartDiagramProtocol.applyYMin(this.getXDiagram(), _yMinValue);
    }

    protected void applyYScalePercent(boolean _isPercent) throws Exception {
        if (_isPercent) {
            ChartDiagramProtocol.applyYscalePercent(this.getXDiagram());
        }
    }

    protected void applyYTitle(String _title) throws Exception {
        ChartDiagramProtocol.setYAxisTitle(this.getXDiagram(), _title);
    }

    protected double[] axisRoundByPercent(double _min, double _max) throws Exception {
        double[] output = new double[]{_min, _max};
        output[0] = Chart.changeValueByPercent(output[0], -20.0);
        output[1] = Chart.changeValueByPercent(output[1], 10.0);
        int i = 0;
        while (i < 2) {
            output[i] = output[i] * 100.0;
            output[i] = Math.round(output[i]);
            output[i] = output[i] / 100.0;
            ++i;
        }
        return output;
    }

    protected double[] axisRoundByStep(double _min, double _max, double _step) throws Exception {
        double[] output = new double[3];
        int divider = _step > 1.0 ? 1 : 100;
        output[0] = _min * (double)divider;
        output[1] = _max * (double)divider;
        output[2] = _step * (double)divider;
        int i = 0;
        while (i < 3) {
            output[i] = Math.round(output[i]);
            output[i] = output[i] / (double)divider;
            ++i;
        }
        output[0] = output[0] - output[2];
        output[1] = output[1] + output[2];
        return output;
    }

    public static double changeValueByPercent(double _value, double _percent) {
        if (_value >= 0.0) {
            return _value + _value * _percent / 100.0;
        }
        return _value - _value * _percent / 100.0;
    }

    protected void expandXAxis() throws Exception {
        double xStep = ChartDiagramProtocol.getXAxisStep(this.getXDiagram());
        double xMin = ChartDiagramProtocol.getXMin(this.getXDiagram());
        double xMax = ChartDiagramProtocol.getXMax(this.getXDiagram());
        ChartDiagramProtocol.applyXMin(this.getXDiagram(), xMin - xStep);
        ChartDiagramProtocol.applyXMax(this.getXDiagram(), xMax + xStep);
    }

    protected void expandYAxis() throws Exception {
        this.expandYAxisUp();
        this.expandYAxisDown();
    }

    protected void expandYAxisDown() throws Exception {
        double yStep = ChartDiagramProtocol.getYAxisStep(this.getXDiagram());
        double yMin = ChartDiagramProtocol.getYMin(this.getXDiagram());
        ChartDiagramProtocol.applyYMin(this.getXDiagram(), yMin - yStep);
    }

    protected void expandYAxisUp() throws Exception {
        double yStep = ChartDiagramProtocol.getYAxisStep(this.getXDiagram());
        if (yStep > 0.0) {
            double yMax = ChartDiagramProtocol.getYMax(this.getXDiagram());
            ChartDiagramProtocol.applyYMax(this.getXDiagram(), yMax + yStep);
        }
    }

    public String getChartType() {
        return this.m_chartType;
    }

    public int getChartXPos() {
        return this.m_chartXPos;
    }

    public int getChartYPos() {
        return this.m_chartYPos;
    }

    public String[] getColumnDesc() {
        return this.m_columnDesc;
    }

    private int getDiagramWidthPercent() {
        return this.m_diagramWidthPercent;
    }

    private int getDiagramXPosPercent() {
        return this.m_diagramXPosPercent;
    }

    public Size getDrawingSize() {
        return ChartDiagramProtocol.getDrawingSize(this.getXDiagram());
    }

    public double getEmptyValue() {
        return Double.MAX_VALUE;
    }

    public int getHeight() {
        return this.m_height;
    }

    public double getNotANumber() {
        return this.m_notANumber;
    }

    private int getRealDiagramHeight() {
        return ChartDiagramProtocol.getDrawingSize((XDiagram)this.getXDiagram()).Height;
    }

    private int getRealDiagramXPos() {
        return ChartDiagramProtocol.getDiagramXPosition(this.getXDiagram());
    }

    private int getRealDocHeight() {
        return ChartDocumentProtocol.getSize((XChartDocument)this.getXChartDocument()).Height;
    }

    private int getRealDocWidth() {
        return ChartDocumentProtocol.getSize((XChartDocument)this.getXChartDocument()).Width;
    }

    public String[] getRowsDesc() {
        return this.m_rowsDesc;
    }

    public double getSynchronizeStart() {
        double diagramStart = this.getRealDiagramXPos();
        double chartWidth = this.getRealDocWidth();
        return diagramStart / chartWidth;
    }

    public double getSynchronizeWidth() {
        double diagramWidth = this.getDrawingSize().Width;
        double chartWidth = ChartDocumentProtocol.getSize((XChartDocument)this.getXChartDocument()).Width;
        return diagramWidth / chartWidth;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getWidth() {
        return this.m_width;
    }

    private XChartDocument getXChartDocument() {
        return this.m_xChartDocument;
    }

    private XDiagram getXDiagram() {
        return this.m_xDiagram;
    }

    public double getXMaxValue() {
        return this.m_xMaxValue;
    }

    protected XMultiServiceFactory getXMultiServiceFactory() {
        return this.m_xMultiServiceFactory;
    }

    private XDiagram getXServiceDiagram() {
        return this.m_xServiceDiagram;
    }

    public double getYMaxValue() {
        return this.m_yMaxValue;
    }

    public double getYMinValue() {
        return this.m_yMinValue;
    }

    public boolean isAutoOrigin() {
        return this.m_autoOrigin;
    }

    public boolean isLinesVisible() {
        return this.m_linesVisible;
    }

    public boolean isVisibleLegend() {
        return this.m_visibleLegend;
    }

    public boolean isXAxisGridVisible() {
        return this.m_xAxisGridVisible;
    }

    public boolean isYAxisGridVisible() {
        return this.m_yAxisGridVisible;
    }

    protected void lockChart(boolean _isLocked) throws Exception {
        ChartDocumentProtocol.setChartDocumentLock(this.getXChartDocument(), _isLocked);
    }

    protected abstract double[][] prepareChartData() throws Exception;

    protected int retrieveDrawingXPos() throws Exception {
        return ChartDiagramProtocol.getDiagramXPosition(this.getXDiagram());
    }

    protected double retrieveXMax() throws Exception {
        return ChartDiagramProtocol.getXMax(this.getXDiagram());
    }

    protected double retrieveXMin() throws Exception {
        return ChartDiagramProtocol.getXMin(this.getXDiagram());
    }

    protected double retrieveXStep() throws Exception {
        return ChartDiagramProtocol.getXAxisStep(this.getXDiagram());
    }

    protected double retrieveYMax() throws Exception {
        return ChartDiagramProtocol.getYMax(this.getXDiagram());
    }

    protected double retrieveYMin() throws Exception {
        return ChartDiagramProtocol.getYMin(this.getXDiagram());
    }

    protected double retrieveYStep() throws Exception {
        return ChartDiagramProtocol.getYAxisStep(this.getXDiagram());
    }

    public void setAutoOrigin(boolean m_autoOrigin) {
        this.m_autoOrigin = m_autoOrigin;
    }

    protected void setChartPosition(int _x, int _y) throws Exception {
        ChartDiagramProtocol.setDiagramPosition(this.getXDiagram(), _x, _y);
    }

    protected void setChartType(String m_chartType) {
        this.m_chartType = m_chartType;
    }

    public void setChartXPos(int m_chartXPos) {
        this.m_chartXPos = m_chartXPos;
    }

    public void setChartYPos(int m_chartYPos) {
        this.m_chartYPos = m_chartYPos;
    }

    protected void setColumnDesc(String[] m_columnDesc) {
        this.m_columnDesc = m_columnDesc;
    }

    protected void setDrawingPosition(int _x, int _y) throws Exception {
        ChartDiagramProtocol.setDrawingPosition(this.getXDiagram(), _x, _y);
    }

    protected void setDrawingSize(int _width, int _height) throws Exception {
        ChartDiagramProtocol.setDrawingSize(this.getXDiagram(), _width, _height);
    }

    public void setHeight(int m_height) {
        this.m_height = m_height;
    }

    public void setLinesVisible(boolean m_linesVisible) {
        this.m_linesVisible = m_linesVisible;
    }

    private void setNotANumber(double m_notANumber) {
        this.m_notANumber = m_notANumber;
    }

    protected void setRowsDesc(String[] m_rowsDesc) {
        this.m_rowsDesc = m_rowsDesc;
    }

    public void setTitle(String m_title) {
        this.m_title = m_title;
    }

    public void setVisibleLegend(boolean m_visibleLegend) {
        this.m_visibleLegend = m_visibleLegend;
    }

    public void setWidth(int m_width) {
        this.m_width = m_width;
    }

    public void setXAxisGridVisible(boolean m_xAxisGridVisible) {
        this.m_xAxisGridVisible = m_xAxisGridVisible;
    }

    public void setXChartDocument(XChartDocument m_xChartDocument) {
        this.m_xChartDocument = m_xChartDocument;
    }

    public void setXMaxValue(double m_xMaxValue) {
        this.m_xMaxValue = m_xMaxValue;
    }

    public void setXMinValue(double m_xMinValue) {
        this.m_xMinValue = m_xMinValue;
    }

    public void setYAxisGridVisible(boolean m_yAxisGridVisible) {
        this.m_yAxisGridVisible = m_yAxisGridVisible;
    }

    public void setYMaxValue(double m_yMaxValue) {
        this.m_yMaxValue = m_yMaxValue;
    }

    public void setYMinValue(double m_yMinValue) {
        this.m_yMinValue = m_yMinValue;
    }

    protected void showAxis(boolean _isXAxisVisible, boolean _isYAxisVisible) throws Exception {
        ChartDiagramProtocol.setAxisVisible(this.getXDiagram(), _isXAxisVisible, _isYAxisVisible);
    }

    protected void showGrid() throws Exception {
        ChartDiagramProtocol.setGridVisible(this.getXDiagram(), this.isXAxisGridVisible(), this.isYAxisGridVisible());
    }

    protected void showGrid(boolean _isXAxisGridVisible, boolean _isYAxisGridVisible) throws Exception {
        ChartDiagramProtocol.setGridVisible(this.getXDiagram(), _isXAxisGridVisible, _isYAxisGridVisible);
    }

    protected void showLines() throws Exception {
        ChartDiagramProtocol.setLinesVisible(this.getXDiagram(), this.isLinesVisible());
    }

    protected void showLines(boolean _isLinesVisible) throws Exception {
        ChartDiagramProtocol.setLinesVisible(this.getXDiagram(), _isLinesVisible);
    }

    public void synchronizeChartDiagram(double _diagramXPosPercentage, double _diagramWidthPercentage) throws Exception {
        int chartWidth = this.getRealDocWidth();
        int syncDiagramWidth = (int)((double)chartWidth * _diagramWidthPercentage);
        int diagramHeight = this.getRealDiagramHeight();
        int diagramStart = this.getRealDiagramXPos();
        int syncDiagramPos = (int)((double)chartWidth * _diagramXPosPercentage);
        this.applyDiagramXPosition(1200);
    }
}

