/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;

public class ConfidenceIntervals
extends Chart {
    private double m_min;
    private double m_max;
    private double m_low;
    private double m_high;
    private double m_value;

    public ConfidenceIntervals(XMultiServiceFactory _xMultiServiceFactory, double _min, double _low, double _value, double _high, double _max) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.BarDiagram");
        if (_min > _low || _low > _value || _value > _high || _high > _max) {
            throw new InvalidInputException("ConfidenceIntervals: values are out of order");
        }
        this.setMin(_min);
        this.setMax(_max);
        this.setLow(_low);
        this.setHigh(_high);
        this.setValue(_value);
        this.setTitle("");
        this.setVisibleLegend(false);
    }

    protected void applyAppearance() throws Exception {
        this.applyStacked(true);
        this.applyVertical(true);
        this.applyXAxisDescriptionVisibility(false);
        this.applyYAxisDescriptionVisibility(false);
        this.applyLegendVisibility();
        this.applySeriesColor(0, SOColor.LIGHT_GREY_COLOR);
        this.applySeriesColor(1, SOColor.RED_COLOR);
        this.applySeriesColor(2, SOColor.RED_COLOR);
        this.applySeriesColor(3, SOColor.LIGHT_GREY_COLOR);
        this.applyMainTitle();
        this.applyXGapWidth(0);
        this.applyXAxisBreak(false);
    }

    public double getHigh() {
        return this.m_high;
    }

    public double getLow() {
        return this.m_low;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMin() {
        return this.m_min;
    }

    public double getValue() {
        return this.m_value;
    }

    protected double[][] prepareChartData() throws InvalidInputException {
        if (this.getMin() > this.getLow() || this.getLow() > this.getValue() || this.getValue() > this.getHigh() || this.getHigh() > this.getMax()) {
            throw new InvalidInputException();
        }
        double firstBar = this.getLow() - this.getMin();
        double secondBar = this.getValue() - this.getLow();
        double thirdBar = this.getHigh() - this.getValue();
        double forthBar = this.getMax() - this.getHigh();
        double[][] chartData = new double[4][1];
        chartData[0][0] = firstBar;
        chartData[1][0] = secondBar;
        chartData[2][0] = thirdBar;
        chartData[3][0] = forthBar;
        return chartData;
    }

    public void setHigh(double m_high) {
        this.m_high = m_high;
    }

    public void setLow(double m_low) {
        this.m_low = m_low;
    }

    public void setMax(double m_max) {
        this.m_max = m_max;
    }

    public void setMin(double m_min) {
        this.m_min = m_min;
    }

    public void setValue(double m_value) {
        this.m_value = m_value;
    }
}

