/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;

abstract class Control
extends Chart {
    protected String m_xTitle;
    protected String m_yTitle;
    protected String[] m_groupLabels;
    private boolean m_test1Active;
    private boolean m_test2Active;
    private boolean m_test3Active;
    private double[][] m_chartData;
    private int m_firstTestIndex;
    private final int TIME_INDEX = 0;
    private final int UCL_INDEX = 1;
    private final int LCL_INDEX = 2;
    private final int MIDDLE_INDEX = 3;
    private final int DATA_INDEX = 4;

    public Control(XMultiServiceFactory _xMultiServiceFactory) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.XYDiagram");
        this.setTest1Active(false);
        this.setTest2Active(false);
        this.setTest3Active(false);
        this.setGroupLabels(null);
        this.setXTitle("");
        this.setYTitle("");
    }

    private int activeTests() {
        int activeTestResult = 0;
        if (this.isTest1Active()) {
            ++activeTestResult;
        }
        if (this.isTest2Active()) {
            ++activeTestResult;
        }
        if (this.isTest3Active()) {
            ++activeTestResult;
        }
        return activeTestResult;
    }

    protected void applyAppearance() throws Exception {
        int groupNo;
        this.applyYTitle(this.getYTitle());
        this.applyXTitle(this.getXTitle());
        this.applyYMax();
        this.applyYMin();
        this.applyRoundSymbols();
        this.showAxis(false, true);
        this.applyXAxisBreak(false);
        this.applyLegendVisibility(false);
        this.applyXLegendLabels();
        this.applyYLegendLabels();
        this.applyLegendBg();
        this.applySeriesLineColor(1, SOColor.RED_COLOR);
        this.applySeriesLineColor(2, SOColor.RED_COLOR);
        this.applySeriesLineColor(3, SOColor.GREEN_COLOR);
        this.applySeriesLineColor(4, SOColor.BLACK_COLOR);
        this.applyUnvisibleSymbols(1);
        this.applyUnvisibleSymbols(2);
        this.applyUnvisibleSymbols(3);
        int i = 5;
        while (i < this.m_chartData.length) {
            this.applySeriesLineVisible(i, false);
            this.applyUnvisibleSymbols(i);
            this.applySeriesTextLegend(i);
            this.applySeriesTextColor(i, SOColor.RED_COLOR);
            ++i;
        }
        if (this.getGroupLabels() == null) {
            groupNo = 0;
        } else {
            groupNo = this.getGroupLabels().length;
            this.applyGridDashed();
        }
        this.applyXMin(0.5);
        this.applyXMax((double)(this.m_chartData[0].length - groupNo) + 0.5);
        this.showGrid(true, false);
        if (groupNo != 0) {
            double interval = (this.m_chartData[0].length - groupNo) / groupNo;
            this.applyXAxisStep(interval);
            this.applySeriesTextColor(this.m_chartData.length - 1, SOColor.BROWN_COLOR);
        } else {
            this.showGrid(false, false);
            this.applyXAxisMarksVisibility(false);
        }
        this.applyXAxisDescriptionVisibility(false);
    }

    protected double[][] calcData(double[] _data, double _lcl, double _middle, double _ucl) throws InvalidInputException, Exception {
        int dataCount = _data.length;
        if (this.getGroupLabels() != null && dataCount % this.getGroupLabels().length != 0) {
            throw new InvalidInputException();
        }
        double[] time = new double[dataCount];
        double[] ucl = new double[dataCount];
        double[] lcl = new double[dataCount];
        double[] middle = new double[dataCount];
        double[][] test = new double[this.activeTests()][dataCount];
        String[] testLabels = new String[dataCount];
        this.calcTests(_data, _lcl, _middle, _ucl, test, testLabels);
        this.setRowsDesc(testLabels);
        double[] minMax = new double[2];
        MathArrayUtils.getRadicalValues((double[])_data, (double[])minMax);
        double dataMax = minMax[1];
        double dataMin = minMax[0];
        double yMin = Math.min(dataMin, _lcl);
        double yMax = Math.max(dataMax, _ucl);
        double step = (yMax - yMin) / 13.0;
        double[] yAxisValues = this.axisRoundByStep(yMin, yMax, step);
        this.applyYAxisStep(yAxisValues[2]);
        this.setYMinValue(yAxisValues[0]);
        this.setYMaxValue(yAxisValues[1]);
        this.setYMinValue(Chart.changeValueByPercent(Math.min(yAxisValues[0], _lcl), -10.0));
        this.setYMaxValue(Chart.changeValueByPercent(Math.max(yAxisValues[1], _ucl), 10.0));
        Arrays.fill(ucl, _ucl);
        Arrays.fill(lcl, _lcl);
        Arrays.fill(middle, _middle);
        int i = 0;
        while (i < time.length) {
            time[i] = i + 1;
            ++i;
        }
        double[][] chartData = BasicArrayUtils.mergeArrays((double[])time, (double[])ucl);
        chartData = BasicArrayUtils.mergeArrays((double[][])chartData, (double[])lcl);
        chartData = BasicArrayUtils.mergeArrays((double[][])chartData, (double[])middle);
        chartData = BasicArrayUtils.mergeArrays((double[][])chartData, (double[])_data);
        this.m_firstTestIndex = chartData.length;
        chartData = BasicArrayUtils.mergeArrays((double[][])chartData, (double[][])test);
        this.setColumnDesc(new String[]{"ucl", "lcl", "middle", "data"});
        if (this.getGroupLabels() != null) {
            this.setColumnDesc(new String[]{"ucl", "lcl", "middle", "data", "labels"});
            double[] emptyCol = new double[chartData[0].length];
            Arrays.fill(emptyCol, this.getNotANumber());
            chartData = BasicArrayUtils.mergeArrays((double[][])chartData, (double[])emptyCol);
            int groupsNo = this.getGroupLabels().length;
            int interval = dataCount / groupsNo;
            double[] groupData = new double[chartData.length];
            Arrays.fill(groupData, this.getNotANumber());
            int i2 = 0;
            while (i2 < groupsNo) {
                groupData[0] = interval * i2 + interval / 2;
                groupData[0] = Chart.changeValueByPercent(groupData[0], 10.0);
                groupData[groupData.length - 1] = Chart.changeValueByPercent(this.getYMaxValue(), -10.0);
                chartData = FormatArrayUtils.addRowAtEnd((double[][])chartData, (double[])groupData);
                ++i2;
            }
            Object[] groupLabels = new String[chartData[0].length];
            Arrays.fill(groupLabels, "");
            int i3 = 0;
            while (i3 < testLabels.length) {
                groupLabels[i3] = testLabels[i3];
                ++i3;
            }
            String[] groups = this.getGroupLabels();
            int i4 = 0;
            while (i4 < groupsNo) {
                groupLabels[i4 + _data.length] = groups[i4];
                ++i4;
            }
            this.setRowsDesc((String[])groupLabels);
        }
        this.m_chartData = chartData;
        return chartData;
    }

    protected void calcTests(double[] _data, double _lcl, double _middle, double _ucl, double[][] _testsResults, String[] _testsLabels) {
        int i;
        boolean[][] testsData = new boolean[this.activeTests()][_data.length];
        Arrays.fill(_testsLabels, "");
        int testIndex = 0;
        if (this.isTest1Active()) {
            testsData[testIndex] = this.test1(_data, _ucl, _lcl);
            i = 0;
            while (i < testsData[testIndex].length) {
                if (testsData[testIndex][i] && _testsLabels[i].equals("")) {
                    _testsLabels[i] = "1";
                }
                ++i;
            }
            ++testIndex;
        }
        if (this.isTest2Active()) {
            testsData[testIndex] = this.test2();
            i = 0;
            while (i < testsData[testIndex].length) {
                if (testsData[testIndex][i] && _testsLabels[i].equals("")) {
                    _testsLabels[i] = "2";
                }
                ++i;
            }
            ++testIndex;
        }
        if (this.isTest3Active()) {
            testsData[testIndex] = this.test3();
            i = 0;
            while (i < testsData[testIndex].length) {
                if (testsData[testIndex][i] && _testsLabels[i].equals("")) {
                    _testsLabels[i] = "3";
                }
                ++i;
            }
            ++testIndex;
        }
        BasicArrayUtils.fill((double[][])_testsResults, (double)this.getNotANumber());
        i = 0;
        while (i < _testsResults.length) {
            int j = 0;
            while (j < _testsResults[0].length) {
                if (testsData[i][j]) {
                    _testsResults[i][j] = _data[j];
                }
                ++j;
            }
            ++i;
        }
    }

    public String[] getGroupLabels() {
        return this.m_groupLabels;
    }

    public String getXTitle() {
        return this.m_xTitle;
    }

    public String getYTitle() {
        return this.m_yTitle;
    }

    public boolean isTest1Active() {
        return this.m_test1Active;
    }

    public boolean isTest2Active() {
        return this.m_test2Active;
    }

    public boolean isTest3Active() {
        return this.m_test3Active;
    }

    public void setGroupLabels(String[] m_groupLabels) {
        this.m_groupLabels = m_groupLabels;
    }

    public void setTest1Active(boolean m_test1Active) {
        this.m_test1Active = m_test1Active;
    }

    public void setTest2Active(boolean m_test2Active) {
        this.m_test2Active = m_test2Active;
    }

    public void setTest3Active(boolean m_test3Active) {
        this.m_test3Active = m_test3Active;
    }

    public void setXTitle(String m_xTitle) {
        this.m_xTitle = m_xTitle;
    }

    public void setYTitle(String m_yTitle) {
        this.m_yTitle = m_yTitle;
    }

    private boolean[] test1(double[] _data, double _ucl, double _lcl) {
        boolean[] testResults = new boolean[_data.length];
        int i = 0;
        while (i < testResults.length) {
            testResults[i] = _data[i] < _lcl || _data[i] > _ucl;
            ++i;
        }
        return testResults;
    }

    private boolean[] test2() {
        return new boolean[0];
    }

    private boolean[] test3() {
        return new boolean[0];
    }
}

