/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class DotPlot
extends Chart {
    private Object[] m_group;
    private double[] m_data;
    private String m_dataTitle;
    private String m_groupTitle;
    private double[][] m_chartData;
    private boolean m_meanLine;
    private int[] m_legendsIndex;
    private int[] m_meansIndex;
    private double m_Ho;
    private double m_avg;
    private double m_confidenceHigh;
    private double m_confidenceLow;
    private double m_xMin;
    private double m_xMax;

    public DotPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _data, String _dataTitle) throws Exception {
        this(_xMultiServiceFactory, _data, _dataTitle, null, null);
    }

    public DotPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _data, String _dataTitle, Object[] _group, String _groupTitle) throws Exception {
        super(_xMultiServiceFactory, "com.ivistaportal.solibrary.Dotplot");
        if (_data == null) {
            throw new NullPointerException("DotPlot: data was recieved an null");
        }
        if (_dataTitle == null) {
            throw new NullPointerException("DotPlot: data title was recieved an null");
        }
        if (_group != null) {
            if (_data.length != _group.length) {
                throw new InvalidInputException("DotPlot: wrong number of groups");
            }
            if (_groupTitle == null) {
                throw new InvalidInputException("DotPlot: group title was recieved as null");
            }
        }
        this.setData(_data);
        this.setGroup(_group);
        this.setDataTitle(_dataTitle);
        this.setGroupTitle(_groupTitle);
        this.setMeanLine(false);
        this.setHo(this.getEmptyValue());
        this.setAvg(this.getEmptyValue());
        this.setConfidenceHigh(this.getEmptyValue());
        this.setConfidenceLow(this.getEmptyValue());
    }

    protected void applyAppearance() throws Exception {
        this.showLines(false);
        this.applySymbolLine(false);
        this.applyYAutoOrigin(true);
        this.applyRectSymbols();
        this.applyXAxisDescriptionVisibility(false);
        this.applyYAxisDescriptionVisibility(true);
        this.applyXMin(this.m_xMin);
        this.applyXMax(this.m_xMax);
        this.showAxis(true, true);
        this.expandYAxisUp();
        this.applyYMin();
        this.applyLegendBg();
        this.applyXLegendLabels();
        this.applyYTitle(this.getDataTitle());
        this.applyLegendVisibility(false);
        this.applyYLegendLabels();
        this.applyXInnerMarksMax();
        this.applyXAxisStep(1.0);
        this.applyXAxisBreak(false);
        if (this.getGroup() != null) {
            this.applyXTitle(this.getGroupTitle());
            int i = 0;
            while (i < MathArrayUtils.distinctValues((Object[])this.getGroup()) && i < this.COLOR.length) {
                this.applySeriesColor(i + 1, this.COLOR[i]);
                ++i;
            }
            if (this.isMeanLine()) {
                this.applySeriesColor(MathArrayUtils.distinctValues((Object[])this.getGroup()) + 2, SOColor.BRIGHT_PINK_COLOR);
                int i2 = 0;
                while (i2 < this.m_legendsIndex.length) {
                    this.applyPointTextLegend(this.m_chartData.length - 2, this.m_legendsIndex[i2]);
                    this.applyPointSymbolVisibility(this.m_chartData.length - 2, this.m_legendsIndex[i2], false);
                    ++i2;
                }
                this.showLines(true);
                int i3 = 0;
                while (i3 < this.m_chartData.length - 1) {
                    this.applySeriesLinesVisibile(i3, false);
                    ++i3;
                }
            } else {
                int i4 = 0;
                while (i4 < this.m_legendsIndex.length) {
                    this.applyPointTextLegend(this.m_chartData.length - 1, this.m_legendsIndex[i4]);
                    this.applyPointSymbolVisibility(this.m_chartData.length - 1, this.m_legendsIndex[i4], false);
                    ++i4;
                }
            }
        } else {
            this.applySeriesColor(0, SOColor.RED_COLOR);
            this.applyPointTextLegend(this.m_chartData.length - 1, this.m_chartData[0].length - 1);
            this.applyPointSymbolVisibility(this.m_chartData.length - 1, this.m_chartData[0].length - 1, false);
        }
        if (this.m_Ho != this.getEmptyValue()) {
            this.applyHoPoint(this.m_Ho);
        }
        if (this.m_avg != this.getEmptyValue()) {
            this.applyAvgPoint(this.m_avg);
        }
        if (this.m_confidenceHigh != this.getEmptyValue()) {
            this.applyConfidenceHighLine(this.m_confidenceHigh);
        }
        if (this.m_confidenceLow != this.getEmptyValue()) {
            this.applyConfidenceLowLine(this.m_confidenceLow);
        }
    }

    public double[] getData() {
        return this.m_data;
    }

    public String getDataTitle() {
        return this.m_dataTitle;
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    public boolean isMeanLine() {
        return this.m_meanLine;
    }

    protected double[][] prepareChartData() throws Exception {
        double[] group;
        Vector averages = new Vector();
        HashMap groupsMap = new HashMap();
        if (this.getGroup() == null) {
            Object[] tmpGroup = new String[this.getData().length];
            Arrays.fill(tmpGroup, new String(""));
            group = new double[this.getData().length];
            FormatArrayUtils.enumerate((Object[])tmpGroup, (double[])group, groupsMap);
        } else {
            group = new double[this.getGroup().length];
            FormatArrayUtils.enumerate((Object[])this.getGroup(), (double[])group, groupsMap);
        }
        double[][] splitedData = new double[groupsMap.size()][this.getData().length];
        splitedData = FormatArrayUtils.splitByKey((double[])group, (double[])this.getData(), (double)this.getNotANumber(), averages);
        double[][] chartData = BasicArrayUtils.mergeArrays((double[])group, (double[][])splitedData);
        chartData = BasicArrayUtils.sortByIndex((double[][])chartData, (int)0);
        String[] colsDesc = FormatArrayUtils.getKeysText((double[])chartData[0], groupsMap);
        this.setColumnDesc(colsDesc);
        double min = chartData[0][0];
        this.setXMinValue(Math.floor(min * 0.9));
        double max = chartData[0][chartData[0].length - 1];
        this.setXMaxValue(Math.ceil(max * 1.1));
        double[][] newChartData = new double[chartData.length + 1][chartData[0].length + colsDesc.length];
        BasicArrayUtils.fill((double[][])newChartData, (double)this.getNotANumber());
        int i = 0;
        while (i < chartData.length) {
            int j = 0;
            while (j < chartData[0].length) {
                newChartData[i][j] = chartData[i][j];
                ++j;
            }
            ++i;
        }
        this.m_legendsIndex = new int[colsDesc.length];
        double[] minMax = new double[2];
        MathArrayUtils.getRadicalValues((double[])this.getData(), (double[])minMax);
        double step = Math.abs(minMax[1] - minMax[0]) * 0.15;
        double yPos = minMax[0] - step * 1.5;
        this.setYMinValue(yPos);
        int i2 = 0;
        while (i2 < colsDesc.length) {
            newChartData[0][chartData[0].length + i2] = i2 + 1;
            newChartData[chartData.length][chartData[0].length + i2] = yPos;
            this.m_legendsIndex[i2] = chartData[0].length + i2;
            ++i2;
        }
        Object[] rowsDesc = new String[newChartData[0].length];
        Arrays.fill(rowsDesc, "");
        int i3 = 0;
        while (i3 < colsDesc.length) {
            rowsDesc[i3 + chartData[0].length] = colsDesc[i3];
            ++i3;
        }
        this.setRowsDesc((String[])rowsDesc);
        if (this.isMeanLine() && this.getGroup() != null) {
            double[][] meanChartData = new double[newChartData.length + 1][newChartData[0].length + groupsMap.size()];
            BasicArrayUtils.fill((double[][])meanChartData, (double)this.getNotANumber());
            int i4 = 0;
            while (i4 < newChartData.length) {
                int j = 0;
                while (j < newChartData[0].length) {
                    meanChartData[i4][j] = newChartData[i4][j];
                    ++j;
                }
                ++i4;
            }
            this.m_meansIndex = new int[groupsMap.size()];
            int groupColIndex = newChartData.length;
            int groupRowIndex = newChartData[0].length;
            int i5 = 0;
            while (i5 < groupsMap.size()) {
                meanChartData[0][groupRowIndex + i5] = i5 + 1;
                meanChartData[groupColIndex][groupRowIndex + i5] = (Double)averages.get(i5);
                this.m_meansIndex[i5] = groupRowIndex + i5;
                ++i5;
            }
            this.m_chartData = new double[meanChartData.length][meanChartData[0].length];
            int i6 = 0;
            while (i6 < this.m_chartData.length) {
                int j = 0;
                while (j < this.m_chartData[0].length) {
                    this.m_chartData[i6][j] = meanChartData[i6][j];
                    ++j;
                }
                ++i6;
            }
        } else {
            this.m_chartData = new double[newChartData.length][newChartData[0].length];
            int i7 = 0;
            while (i7 < this.m_chartData.length) {
                int j = 0;
                while (j < this.m_chartData[0].length) {
                    this.m_chartData[i7][j] = newChartData[i7][j];
                    ++j;
                }
                ++i7;
            }
        }
        return this.m_chartData;
    }

    public void setAvg(double _avg) {
        this.m_avg = _avg;
    }

    public void setConfidenceHigh(double _ch) {
        this.m_confidenceHigh = _ch;
    }

    public void setConfidenceLow(double _cl) {
        this.m_confidenceLow = _cl;
    }

    private void setData(double[] m_data) {
        this.m_data = m_data;
    }

    private void setDataTitle(String m_dataTitle) {
        this.m_dataTitle = m_dataTitle;
    }

    private void setGroup(Object[] m_group) {
        this.m_group = m_group;
    }

    private void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }

    public void setHo(double _Ho) {
        this.m_Ho = _Ho;
    }

    public void setMeanLine(boolean m_meanLine) {
        this.m_meanLine = m_meanLine;
    }

    public void setXMaxValue(double _xMax) {
        this.m_xMax = _xMax;
    }

    public void setXMinValue(double _xMin) {
        this.m_xMin = _xMin;
    }
}

