/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;

public class FishBone
extends Chart {
    private String[] m_bone1;
    private String[] m_bone2;
    private String[] m_bone3;
    private String[] m_bone4;
    private String[] m_bone5;
    private String[] m_bone6;
    private String m_bone1Title;
    private String m_bone2Title;
    private String m_bone3Title;
    private String m_bone4Title;
    private String m_bone5Title;
    private String m_bone6Title;
    private String m_effects;
    private boolean m_displayLabelBones;
    private boolean m_displayEmptyBones;
    private String[] m_pointLabel;
    private double[][] m_outPointsData;
    int m_currentCol = 0;
    int m_currentRow = 0;
    private final int MIN_BONE_POINTS = 4;
    private final int X_COL_NUM = 0;
    private final int SPINE_Y_COL = 4;
    private final double BONE_WIDTH = 2.0;
    private final double BONE_HEIGHT = 20.0;
    private final double BONE1_HEAD_XPOS = 11.0;
    private final double BONE1_HEAD_YPOS = 20.0;
    private final double BONES_HEADS_XSTEP = 3.0;

    public FishBone(XMultiServiceFactory _xMultiServiceFactory, String _chartName, String _effects, String[] _bone1, String[] _bone2, String[] _bone3, String[] _bone4, String[] _bone5, String[] _bone6) throws InvalidInputException {
        this(_xMultiServiceFactory, _effects, _bone1, _bone2, _bone3, _bone4, _bone5, _bone6, "Group 1", "Group 2", "Group 3", "Group 4", "Group 5", "Group 6");
    }

    public FishBone(XMultiServiceFactory _xMultiServiceFactory, String _effects, String[] _bone1, String[] _bone2, String[] _bone3, String[] _bone4, String[] _bone5, String[] _bone6, String _bone1Title, String _bone2Title, String _bone3Title, String _bone4Title, String _bone5Title, String _bone6Title) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.XYDiagram");
        this.setBone1(_bone1);
        this.setBone2(_bone2);
        this.setBone3(_bone3);
        this.setBone4(_bone4);
        this.setBone5(_bone5);
        this.setBone6(_bone6);
        this.setBone1Title(_bone1Title);
        this.setBone2Title(_bone2Title);
        this.setBone3Title(_bone3Title);
        this.setBone4Title(_bone4Title);
        this.setBone5Title(_bone5Title);
        this.setBone6Title(_bone6Title);
        this.setEffectsName(_effects);
        this.setDisplayEmptyBones(false);
    }

    private void addBoneEndPoint(double _boneXEnd, double _boneYEnd, int _boneNum) {
        if (this.getBoneData(_boneNum) == null && !this.isEmptyBonesDisplyed()) {
            return;
        }
        this.m_outPointsData[0][this.m_currentRow] = _boneXEnd;
        this.m_outPointsData[this.m_currentCol][this.m_currentRow] = _boneYEnd;
        ++this.m_currentRow;
    }

    private void addBoneStartPoint(double _boneXStart, double _boneYStart, int _boneNum) {
        if (this.getBoneData(_boneNum) == null && !this.isEmptyBonesDisplyed()) {
            return;
        }
        this.m_outPointsData[0][this.m_currentRow] = _boneXStart;
        this.m_outPointsData[this.m_currentCol][this.m_currentRow] = _boneYStart;
        this.m_pointLabel[this.m_currentRow] = this.getBoneTitle(_boneNum);
        ++this.m_currentRow;
    }

    private void addBonesDataPoints(double _boneXStart, double _boneYStart, double _boneXEnd, double _boneYEnd, String[] _boneData) {
        int pointsNum = _boneData.length;
        double xStep = this.calcStep(pointsNum, _boneXStart, _boneXEnd);
        double yStep = this.calcStep(pointsNum, _boneYStart, _boneYEnd);
        double pointX = _boneXStart;
        double pointY = _boneYStart;
        int i = 0;
        while (i < pointsNum) {
            pointX = this.makeStep(pointX, xStep, _boneXStart, _boneXEnd);
            pointY = this.makeStep(pointY, yStep, _boneYStart, _boneYEnd);
            this.m_outPointsData[0][this.m_currentRow] = pointX;
            this.m_outPointsData[this.m_currentCol][this.m_currentRow] = pointY;
            this.m_pointLabel[this.m_currentRow] = _boneData[i];
            ++this.m_currentRow;
            ++i;
        }
    }

    private void addFishBoneSpine() {
        this.m_outPointsData[0][this.m_outPointsData[0].length - 2] = 5.0;
        this.m_outPointsData[4][this.m_outPointsData[0].length - 2] = 0.0;
        this.m_outPointsData[0][this.m_outPointsData[0].length - 1] = 15.4;
        this.m_outPointsData[4][this.m_outPointsData[0].length - 1] = 0.0;
        this.m_pointLabel[this.m_outPointsData[0].length - 1] = this.getEffectsName();
    }

    protected void applyAppearance() throws Exception {
        this.showAxis(false, false);
        this.applySeriesSymboleInvisabile(1);
        this.applySeriesSymboleInvisabile(2);
        this.applySeriesSymboleInvisabile(3);
        this.applyPointSymbolVisibility(0, this.m_outPointsData[0].length - 2, false);
        this.applySeriesLineColor(1, SOColor.BROWN_COLOR);
        this.applySeriesLineColor(2, SOColor.BROWN_COLOR);
        this.applySeriesLineColor(3, SOColor.BROWN_COLOR);
        this.applySeriesLineColor(4, SOColor.RED_COLOR);
        this.applyXAxisDescriptionVisibility(false);
        this.applyYAxisDescriptionVisibility(false);
        this.applyLegendVisibility(false);
        this.applyXAxisMarksVisibility(false);
        this.applyYAxisMarksVisibility(false);
        double maxY = Chart.changeValueByPercent(20.0, 20.0);
        double minY = Chart.changeValueByPercent(-20.0, -10.0);
        double maxX = Chart.changeValueByPercent(13.0, 30.0);
        double minX = Chart.changeValueByPercent(5.0, -30.0);
        this.applyYMax(maxY);
        this.applyYMin(minY);
        this.applyXMax(maxX);
        this.applyXMin(minX);
        this.applyYLegendLabels();
        this.applyTextLegendSymbols(true);
        this.applyXAxisBreak(false);
    }

    private double calcStep(int _numOfPoints, double _start, double _end) {
        double length = Math.abs(_start - _end);
        double step = _numOfPoints < 4 ? length / 5.0 : length / (double)(_numOfPoints + 1);
        return step;
    }

    public String[] getBone1() {
        return this.m_bone1;
    }

    public String getBone1Title() {
        return this.m_bone1Title;
    }

    public String[] getBone2() {
        return this.m_bone2;
    }

    public String getBone2Title() {
        return this.m_bone2Title;
    }

    public String[] getBone3() {
        return this.m_bone3;
    }

    public String getBone3Title() {
        return this.m_bone3Title;
    }

    public String[] getBone4() {
        return this.m_bone4;
    }

    public String getBone4Title() {
        return this.m_bone4Title;
    }

    public String[] getBone5() {
        return this.m_bone5;
    }

    public String getBone5Title() {
        return this.m_bone5Title;
    }

    public String[] getBone6() {
        return this.m_bone6;
    }

    public String getBone6Title() {
        return this.m_bone6Title;
    }

    private String[] getBoneData(int _boneNo) throws InternalError {
        switch (_boneNo) {
            case 1: {
                return this.getBone1();
            }
            case 2: {
                return this.getBone2();
            }
            case 3: {
                return this.getBone3();
            }
            case 4: {
                return this.getBone4();
            }
            case 5: {
                return this.getBone5();
            }
            case 6: {
                return this.getBone6();
            }
        }
        throw new InternalError("FishBone: requested invalid bone number");
    }

    private String getBoneTitle(int _boneNo) throws InternalError {
        switch (_boneNo) {
            case 1: {
                return this.getBone1Title();
            }
            case 2: {
                return this.getBone2Title();
            }
            case 3: {
                return this.getBone3Title();
            }
            case 4: {
                return this.getBone4Title();
            }
            case 5: {
                return this.getBone5Title();
            }
            case 6: {
                return this.getBone6Title();
            }
        }
        throw new InternalError("FishBone: requested invalid bone number");
    }

    public String getEffectsName() {
        return this.m_effects;
    }

    public boolean isEmptyBonesDisplyed() {
        return this.m_displayEmptyBones;
    }

    public boolean isLabelBonesDisplyed() {
        return this.m_displayLabelBones;
    }

    private boolean isUpperBone(double _boneNo) {
        return (double)Math.round(_boneNo / 2.0) != _boneNo / 2.0;
    }

    private double makeStep(double _value, double _step, double _start, double _end) {
        if (_start > _end) {
            return _value - _step;
        }
        return _value + _step;
    }

    protected double[][] prepareChartData() throws Exception {
        int pointsCount = 0;
        int i = 1;
        while (i <= 6) {
            String[] bonesData = this.getBoneData(i);
            if (bonesData != null) {
                pointsCount += bonesData.length;
            }
            ++i;
        }
        this.m_outPointsData = new double[5][12 + pointsCount + 2];
        BasicArrayUtils.fill((double[][])this.m_outPointsData, (double)this.getNotANumber());
        this.m_pointLabel = new String[this.m_outPointsData[0].length];
        int i2 = 0;
        while (i2 < this.m_pointLabel.length) {
            this.m_pointLabel[i2] = "";
            ++i2;
        }
        int i3 = 1;
        while (i3 <= 6) {
            this.m_currentCol = (int)Math.ceil((double)i3 / 2.0);
            double[] boneXStartAndEnd = this.prepareXStartAndEndBone();
            double[] boneYStartAndEnd = this.prepareYStartAndEndBone(i3);
            String[] boneData = this.getBoneData(i3);
            this.addBoneStartPoint(boneXStartAndEnd[0], boneYStartAndEnd[0], i3);
            if (boneData != null) {
                this.addBonesDataPoints(boneXStartAndEnd[0], boneYStartAndEnd[0], boneXStartAndEnd[1], boneYStartAndEnd[1], boneData);
            }
            this.addBoneEndPoint(boneXStartAndEnd[1], boneYStartAndEnd[1], i3);
            ++i3;
        }
        this.addFishBoneSpine();
        this.setRowsDesc(this.m_pointLabel);
        return this.m_outPointsData;
    }

    private double[] prepareXStartAndEndBone() {
        double[] xData;
        xData = new double[]{11.0 - (double)(this.m_currentCol - 1) * 3.0, xData[0] + 2.0};
        return xData;
    }

    private double[] prepareYStartAndEndBone(int _boneNumber) {
        double[] yData = new double[2];
        if (this.isUpperBone(_boneNumber)) {
            yData[0] = 20.0;
            yData[1] = 0.0;
        } else {
            yData[0] = -20.0;
            yData[1] = 0.0;
        }
        return yData;
    }

    public void setBone1(String[] m_bone1) {
        this.m_bone1 = m_bone1;
    }

    public void setBone1Title(String _bone1Title) {
        this.m_bone1Title = _bone1Title;
    }

    public void setBone2(String[] m_bone2) {
        this.m_bone2 = m_bone2;
    }

    public void setBone2Title(String _bone2Title) {
        this.m_bone2Title = _bone2Title;
    }

    public void setBone3(String[] m_bone3) {
        this.m_bone3 = m_bone3;
    }

    public void setBone3Title(String _bone3Title) {
        this.m_bone3Title = _bone3Title;
    }

    public void setBone4(String[] m_bone4) {
        this.m_bone4 = m_bone4;
    }

    public void setBone4Title(String _bone4Title) {
        this.m_bone4Title = _bone4Title;
    }

    public void setBone5(String[] m_bone5) {
        this.m_bone5 = m_bone5;
    }

    public void setBone5Title(String _bone5Title) {
        this.m_bone5Title = _bone5Title;
    }

    public void setBone6(String[] m_bone6) {
        this.m_bone6 = m_bone6;
    }

    public void setBone6Title(String _bone6Title) {
        this.m_bone6Title = _bone6Title;
    }

    public void setDisplayBonesLabel(boolean _isDisplayed) {
        this.m_displayLabelBones = _isDisplayed;
    }

    public void setDisplayEmptyBones(boolean _isDisplayed) {
        this.m_displayEmptyBones = _isDisplayed;
    }

    public void setEffectsName(String _effects) {
        this.m_effects = _effects;
    }
}

