/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.FrequencyTable;
import com.ivistaportal.math.SigmaMathLib;
import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;

public class Histogram
extends Chart {
    private double[] m_data;
    private double[][] m_chartData;
    private int m_noOfBins;
    private int m_numberOfLines;
    private double m_step;
    private double m_ucl;
    private double m_lcl;
    private String m_xTitle;
    private String m_yTitle;
    private boolean m_percentage;
    private boolean m_cumulative;
    private boolean m_curve;
    private double m_Ho;
    private double m_avg;
    private double m_confidenceHigh;
    private double m_confidenceLow;
    private static final int MIN_BARS_FOR_CALC = 10;

    public Histogram(XMultiServiceFactory _xMultiServiceFactory, double[] _data) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.ivistaportal.solibrary.Histogram");
        this.setData(_data);
        this.setNoOfBins(0);
        this.setStep(0.0);
        this.setVisibleLegend(false);
        this.setPercentage(false);
        this.setCurve(false);
        this.setXTitle("");
        this.setYTitle("");
        this.setNumberOfLines(0);
        this.setConfidenceHigh(this.getEmptyValue());
        this.setConfidenceLow(this.getEmptyValue());
        this.setAvg(this.getEmptyValue());
        this.setHo(this.getEmptyValue());
        this.setLcl(this.getEmptyValue());
        this.setUcl(this.getEmptyValue());
    }

    protected void applyAppearance() throws Exception {
        String[] columnDesc = this.getRowsDesc();
        Double min = Double.valueOf(columnDesc[0]);
        Double max = Double.valueOf(columnDesc[columnDesc.length - 1]);
        Double minNext = Double.valueOf(columnDesc[1]);
        double step = minNext - min;
        this.applyXMin(min);
        this.applyXMax(max + step);
        this.applyXAxisStep(step);
        this.applyXAxisBreak(false);
        this.applyYLegendLabels();
        this.showLines();
        this.applyLegendVisibility();
        this.applyXGapWidth(0);
        this.applyXTitle(this.getXTitle());
        this.applyYTitle(this.getYTitle());
        if (this.isCurve()) {
            this.applyNumOfLines(this.getNumberOfLines());
            int i = 1;
            while (i <= this.getNumberOfLines()) {
                this.applySeriesSymboleInvisabile(i);
                this.applySeriesLineWidth(i, 50);
                this.applySeriesLineColor(i, SOColor.RED_COLOR);
                ++i;
            }
        }
        if (this.getLcl() != this.getEmptyValue()) {
            this.applyLclVerticalLine(this.getLcl());
        }
        if (this.getUcl() != this.getEmptyValue()) {
            this.applyUclVerticalLine(this.getUcl());
        }
        if (this.m_Ho != this.getEmptyValue()) {
            this.applyHoPoint(this.m_Ho);
        }
        if (this.m_avg != this.getEmptyValue()) {
            this.applyAvgPoint(this.m_avg);
        }
        if (this.m_confidenceHigh != this.getEmptyValue()) {
            this.applyConfidenceHighLine(this.m_confidenceHigh);
        }
        if (this.m_confidenceLow != this.getEmptyValue()) {
            this.applyConfidenceLowLine(this.m_confidenceLow);
        }
    }

    private double[] buildNewBinsData(int _newBinsNo, double _step, double _start) {
        double[] newBinsData = new double[_newBinsNo];
        double i = 0.0;
        double j = _start;
        while (i < (double)newBinsData.length) {
            newBinsData[(int)i] = j;
            i += 1.0;
            j += _step;
        }
        return newBinsData;
    }

    public static int calcNumOfBins(int _dataLength) {
        int binsNum = 0;
        if (_dataLength <= 10) {
            binsNum = _dataLength;
        } else {
            double bins = Math.sqrt(_dataLength);
            bins += 0.5;
            bins = Math.round(bins);
            binsNum = (int)bins;
        }
        return binsNum;
    }

    private double[] getCurveData(double[] _bins, int _noOfDataElements, double _dataAverage, double _standardDeviation, double _mean, double _step, boolean _cumulative) throws Exception {
        double prevNormDist = this.getEmptyValue();
        double C = 1.0;
        double[] curveData = new double[_bins.length];
        SigmaMathLib lib = new SigmaMathLib(this.getXMultiServiceFactory());
        int i = 0;
        while (i < _bins.length) {
            double currNormDist = lib.normdist(_bins[i] + _step, _mean, _standardDeviation, 1.0);
            if (_cumulative) {
                prevNormDist = 0.0;
            } else if (prevNormDist == this.getEmptyValue()) {
                prevNormDist = lib.normdist(_bins[i], _mean, _standardDeviation, 1.0);
            }
            curveData[i] = (currNormDist - prevNormDist) * (double)_noOfDataElements;
            prevNormDist = currNormDist;
            ++i;
        }
        return curveData;
    }

    public double[] getData() {
        return this.m_data;
    }

    public double getLcl() {
        return this.m_lcl;
    }

    public int getNoOfBins() {
        return this.m_noOfBins;
    }

    private int getNumberOfLines() {
        return this.m_numberOfLines;
    }

    private double getStep() {
        return this.m_step;
    }

    public double getUcl() {
        return this.m_ucl;
    }

    public String getXTitle() {
        return this.m_xTitle;
    }

    public String getYTitle() {
        return this.m_yTitle;
    }

    private double[][] handleLimit(double[][] _freqTab, double _step, double _limit) throws InvalidInputException {
        block4: {
            int limitBinsNo;
            double max;
            block3: {
                double min = _freqTab[0][0];
                max = _freqTab[0][_freqTab[0].length - 1];
                if (!(_limit < min)) break block3;
                int limitBinsNo2 = this.numberOfBinsInGap(_limit, min, _step);
                if (limitBinsNo2 <= 0) break block4;
                double[] limitData = new double[limitBinsNo2];
                limitData = this.buildNewBinsData(limitBinsNo2, _step, min - (double)limitBinsNo2 * _step);
                double[] currData = new double[2];
                int i = 0;
                while (i < limitData.length) {
                    currData[0] = limitData[limitData.length - 1 - i];
                    currData[1] = 0.0;
                    _freqTab = FormatArrayUtils.addRowAtStart((double[][])_freqTab, (double[])currData);
                    ++i;
                }
                break block4;
            }
            if (_limit > max && (limitBinsNo = this.numberOfBinsInGap(_limit, max, _step)) > 0) {
                double[] limitData = new double[limitBinsNo];
                limitData = this.buildNewBinsData(limitBinsNo, _step, max + _step);
                double[] currData = new double[2];
                int i = 0;
                while (i < limitData.length) {
                    currData[0] = limitData[i];
                    currData[1] = 0.0;
                    _freqTab = FormatArrayUtils.addRowAtEnd((double[][])_freqTab, (double[])currData);
                    ++i;
                }
            }
        }
        return _freqTab;
    }

    public boolean isCumulative() {
        return this.m_cumulative;
    }

    public boolean isCurve() {
        return this.m_curve;
    }

    public boolean isPercentage() {
        return this.m_percentage;
    }

    private int numberOfBinsInGap(double _startPos, double _endPos, double _step) {
        double gap = Math.abs(_startPos - _endPos);
        if (gap < _step) {
            return 1;
        }
        return (int)Math.ceil(gap / _step);
    }

    public double[][] prepareChartData() throws Exception {
        int i;
        SigmaMathLib lib = new SigmaMathLib(this.getXMultiServiceFactory());
        double[] sortedData = BasicArrayUtils.sort((double[])this.getData());
        this.setData(sortedData);
        int distinctValues = MathArrayUtils.distinctValues((double[])this.getData());
        if (this.getNoOfBins() <= 0) {
            this.setNoOfBins(Histogram.calcNumOfBins(distinctValues));
        }
        if (this.getNoOfBins() > distinctValues) {
            this.setNoOfBins(distinctValues);
        }
        double step = FrequencyTable.calcStepByGroupsNum((double[])this.getData(), (int)this.getNoOfBins());
        double[][] freqTab = FrequencyTable.createFrequencyTable((double[])this.getData(), (int)this.getNoOfBins(), (boolean)this.isCumulative());
        if (this.getLcl() != this.getEmptyValue()) {
            freqTab = this.handleLimit(freqTab, step, this.getLcl());
        }
        if (this.getUcl() != this.getEmptyValue()) {
            freqTab = this.handleLimit(freqTab, step, this.getUcl());
        }
        this.m_chartData = new double[1][freqTab[0].length];
        int i2 = 0;
        while (i2 < this.m_chartData[0].length) {
            this.m_chartData[0][i2] = freqTab[1][i2];
            ++i2;
        }
        if (this.isCurve()) {
            this.setNumberOfLines(this.getNumberOfLines() + 1);
            double average = MathArrayUtils.arrayAverage((double[])this.getData());
            Double stDev = lib.stDev((Object[])FormatArrayUtils.toDouble((double[])this.getData()));
            double mean = MathArrayUtils.arrayMean((double[])this.getData());
            double[] curveData = this.getCurveData(freqTab[0], this.getData().length, average, stDev, mean, step, this.isCumulative());
            this.m_chartData = BasicArrayUtils.mergeArrays((double[][])this.m_chartData, (double[])curveData);
        }
        double freqStep = freqTab[0][1] - freqTab[0][0];
        double startLabel = freqTab[0][0] + 0.5 * freqStep;
        String[] xLegend = FormatArrayUtils.RoundDouble((double)startLabel, (double)step, (int)freqTab[0].length);
        this.setRowsDesc(xLegend);
        if (this.isPercentage()) {
            double freqSum = this.isCumulative() ? this.m_chartData[0][this.m_chartData[0].length - 1] : MathArrayUtils.arraySum((double[])this.m_chartData[0]);
            i = 0;
            while (i < this.m_chartData[0].length) {
                this.m_chartData[0][i] = this.m_chartData[0][i] / freqSum * 100.0;
                ++i;
            }
        }
        if (this.isPercentage() && this.isCurve()) {
            double curveSum = this.isCumulative() ? this.m_chartData[1][this.m_chartData[1].length - 1] : MathArrayUtils.arraySum((double[])this.m_chartData[1]);
            i = 0;
            while (i < this.m_chartData[1].length) {
                this.m_chartData[1][i] = this.m_chartData[1][i] / curveSum * 100.0;
                ++i;
            }
        }
        return this.m_chartData;
    }

    public void setAvg(double _avg) {
        this.m_avg = _avg;
    }

    public void setConfidenceHigh(double _ch) {
        this.m_confidenceHigh = _ch;
    }

    public void setConfidenceLow(double _cl) {
        this.m_confidenceLow = _cl;
    }

    public void setCumulative(boolean m_cumulative) {
        this.m_cumulative = m_cumulative;
    }

    public void setCurve(boolean m_curve) {
        this.m_curve = m_curve;
    }

    private void setData(double[] m_data) {
        this.m_data = m_data;
    }

    public void setHo(double _Ho) {
        this.m_Ho = _Ho;
    }

    public void setLcl(double m_lcl) {
        this.m_lcl = m_lcl;
    }

    public void setNoOfBins(int m_noOfBins) {
        this.m_noOfBins = m_noOfBins;
    }

    private void setNumberOfLines(int m_numberOfLines) {
        this.m_numberOfLines = m_numberOfLines;
    }

    public void setPercentage(boolean m_percentage) {
        this.m_percentage = m_percentage;
    }

    private void setStep(double m_step) {
        this.m_step = m_step;
    }

    public void setUcl(double m_ucl) {
        this.m_ucl = m_ucl;
    }

    public void setXTitle(String _xTtitle) {
        this.m_xTitle = _xTtitle;
    }

    public void setYTitle(String _yTtitle) {
        this.m_yTitle = _yTtitle;
    }
}

