/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Control;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class Individual
extends Control {
    private double[] m_data;

    public Individual(XMultiServiceFactory _xMultiServiceFactory, double[] _data) throws InvalidInputException {
        this(_xMultiServiceFactory, _data, null);
    }

    public Individual(XMultiServiceFactory _xMultiServiceFactory, double[] _data, String[] _groupLabels) throws InvalidInputException {
        super(_xMultiServiceFactory);
        if (_data == null) {
            throw new InvalidInputException("individual chart: data for chart is empty");
        }
        if (_groupLabels != null && _data.length % _groupLabels.length != 0) {
            throw new InvalidInputException("individual chart: number of groups cannot fit into chart data");
        }
        this.setData(_data);
        this.setGroupLabels(_groupLabels);
        this.setTest1Active(true);
    }

    protected void applyAppearance() throws Exception {
        super.applyAppearance();
        this.applyXAxisStep(1.0);
        this.applyXMin(0.0);
        this.applyXAxisDescriptionVisibility(true);
        this.applyXAxisBreak(false);
    }

    public static double[] calcMovingRange(double[] _data) {
        return Individual.calcMovingRange(_data, -1.0);
    }

    public static double[] calcMovingRange(double[] _data, double _errorValue) {
        double[] mr = new double[_data.length];
        mr[0] = _errorValue;
        int i = 1;
        while (i < _data.length) {
            mr[i] = Math.abs(_data[i] - _data[i - 1]);
            ++i;
        }
        return mr;
    }

    public double[] getData() {
        return this.m_data;
    }

    protected double[][] prepareChartData() throws Exception {
        double middle = MathArrayUtils.arrayMean((double[])this.getData());
        double[] mr = Individual.calcMovingRange(this.getData(), this.getNotANumber());
        double mrMean = MathArrayUtils.arrayMean((double[])mr);
        double sRandom = mrMean / 1.128;
        double lcl = middle - 3.0 * sRandom;
        double ucl = middle + 3.0 * sRandom;
        double[][] chartData = this.calcData(this.getData(), lcl, middle, ucl);
        return chartData;
    }

    public void setData(double[] m_data) {
        this.m_data = m_data;
    }
}

