/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Control;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class MovingRange
extends Control {
    private double[] m_data;

    public MovingRange(XMultiServiceFactory _xMultiServiceFactory, double[] _data) throws InvalidInputException {
        this(_xMultiServiceFactory, _data, null);
    }

    public MovingRange(XMultiServiceFactory _xMultiServiceFactory, double[] _data, String[] _groupLabels) throws InvalidInputException {
        super(_xMultiServiceFactory);
        if (_data == null) {
            throw new InvalidInputException("moving range chart: data for chart is empty");
        }
        if (_groupLabels != null && _data.length % _groupLabels.length != 0) {
            throw new InvalidInputException("moving range chart: number of groups cannot fit into chart data");
        }
        this.setData(_data);
        this.setGroupLabels(_groupLabels);
        this.setTest1Active(true);
    }

    public static double[] calcMovingRange(double[] _data) {
        return MovingRange.calcMovingRange(_data, -1.0);
    }

    public static double[] calcMovingRange(double[] _data, double _errorValue) {
        double[] mr = new double[_data.length];
        mr[0] = _errorValue;
        int i = 1;
        while (i < _data.length) {
            mr[i] = Math.abs(_data[i] - _data[i - 1]);
            ++i;
        }
        return mr;
    }

    public double[] getData() {
        return this.m_data;
    }

    protected double[][] prepareChartData() throws Exception {
        double[] mr = MovingRange.calcMovingRange(this.getData(), this.getNotANumber());
        double middle = MathArrayUtils.arrayAverage((double[])mr);
        double lcl = 0.0;
        double ucl = 3.27 * middle;
        double[][] chartData = this.calcData(mr, lcl, middle, ucl);
        return chartData;
    }

    public void setData(double[] m_data) {
        this.m_data = m_data;
    }
}

