/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.SigmaMathLib;
import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.awt.Size;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;

public class NormalProbability
extends Chart {
    private double[] m_data;
    private String m_groupTitle;
    private String m_dataTitle;
    private double[][] m_chartData;
    private String[] YLABELS = new String[]{".001                    ", ".01                     ", ".05                     ", " .2                     ", " .5                     ", " .8                     ", ".95                     ", ".99                     ", ".999                    "};

    public NormalProbability(XMultiServiceFactory _xMultiServiceFactory, double[] _data) throws Exception {
        super(_xMultiServiceFactory, "com.sun.star.chart.XYDiagram");
        this.setData(_data);
        this.setGroupTitle("");
        this.setVisibleLegend(false);
    }

    protected void applyAppearance() throws Exception {
        this.applyGridDashed();
        this.showLines();
        this.applyXTitle(this.getGroupTitle());
        this.applyYTitle(this.getDataTitle());
        this.applySymbolLine(false);
        this.applyLegendVisibility();
        this.applyNumOfLines(0);
        this.applyRoundSymbols();
        this.applySeriesColor(1, SOColor.BLACK_COLOR);
        this.applyLinearRegression(true);
        double minX = this.retrieveXMin();
        double minY = this.retrieveYMin();
        double maxY = this.retrieveYMax();
        double stepY = (maxY - minY) / 10.0;
        double[][] yLabelsData = new double[3][9];
        double startY = Chart.changeValueByPercent(minY, 10.0);
        int i = 0;
        while (i < yLabelsData[0].length) {
            yLabelsData[0][i] = minX;
            yLabelsData[1][i] = this.getNotANumber();
            yLabelsData[2][i] = startY + stepY * (double)i;
            ++i;
        }
        this.m_chartData = FormatArrayUtils.addEmptyColumn((double[][])this.m_chartData, (double)this.getNotANumber());
        this.m_chartData = BasicArrayUtils.concatenate((double[][])this.m_chartData, (double[][])yLabelsData);
        Object[] yLabels = new String[this.m_chartData[0].length];
        Arrays.fill(yLabels, "");
        int i2 = 0;
        while (i2 < this.YLABELS.length) {
            yLabels[i2 + this.getData().length] = this.YLABELS[i2];
            ++i2;
        }
        this.applyYMax(maxY);
        this.applyYMin(minY);
        this.applyYAxisStep(stepY);
        this.applyChartData(this.m_chartData);
        this.applyYAxisDescriptionVisibility(false);
        this.applyXAxisBreak(false);
        this.setRowsDesc((String[])yLabels);
        this.setColumnDesc((String[])yLabels);
        this.applyYLegendLabels();
        this.applyUnvisibleSymbols(2);
        this.applySeriesTextLegend(2);
        Size size = this.getDrawingSize();
        size.Width = (int)((double)size.Width * 0.9);
        this.setDrawingSize(size.Width, size.Height);
        int drawingXPos = this.retrieveDrawingXPos();
        this.applyDrawingXPos(drawingXPos *= 3);
    }

    private double[] getData() {
        return this.m_data;
    }

    public String getDataTitle() {
        return this.m_dataTitle;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    protected double[][] prepareChartData() throws Exception {
        SigmaMathLib lib = new SigmaMathLib(this.getXMultiServiceFactory());
        this.setData(BasicArrayUtils.sort((double[])this.getData()));
        int dataCount = this.getData().length;
        double[] rankData = new double[dataCount];
        MathArrayUtils.rank((double[])this.getData(), (double[])rankData);
        double[] invStDiv = new double[dataCount];
        int i = 0;
        while (i < invStDiv.length) {
            Double currentInvStDev = lib.normsinv((rankData[i] - 0.375) / ((double)dataCount + 0.25));
            invStDiv[i] = currentInvStDev;
            ++i;
        }
        this.m_chartData = BasicArrayUtils.mergeArrays((double[])this.getData(), (double[])invStDiv);
        return this.m_chartData;
    }

    private void setData(double[] m_data) {
        this.m_data = m_data;
    }

    public void setDataTitle(String m_dataTitle) {
        this.m_dataTitle = m_dataTitle;
    }

    public void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }
}

