/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.HashMap;

public class Pareto
extends Chart {
    private double[] m_count;
    private Object[] m_group;
    private int m_coverPercent;
    private String m_othersLabel;
    private boolean m_percentScale;
    private String m_groupTitle;
    private boolean m_cumulativeLine;

    public Pareto(XMultiServiceFactory _xMultiServiceFactory, double[] _count, Object[] _group) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.BarDiagram");
        if (_count == null) {
            _count = new double[_group.length];
            int i = 0;
            while (i < _count.length) {
                _count[i] = 1.0;
                ++i;
            }
        }
        this.setGroup(_group);
        this.setCount(_count);
        this.setOthersLabel("Others");
        this.setGroupTitle("");
        this.setcoverPercent(95);
        this.setCumulativeLine(true);
        this.setPercentScale(false);
        this.setVisibleLegend(false);
    }

    public Pareto(XMultiServiceFactory _xMultiServiceFactory, Object[] _group) throws InvalidInputException {
        this(_xMultiServiceFactory, null, _group);
    }

    protected void applyAppearance() throws Exception {
        this.applyXLegendLabels();
        this.applyYLegendLabels();
        this.showLines();
        this.applyLegendVisibility();
        if (this.isCumulativeLine()) {
            this.applyNumOfLines(1);
        }
        this.applyXGapWidth(0);
        this.applyXAxisBreak(false);
    }

    public double[] getCount() {
        return this.m_count;
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    public String getOthersLabel() {
        return this.m_othersLabel;
    }

    public int getcoverPercent() {
        return this.m_coverPercent;
    }

    public boolean isCumulativeLine() {
        return this.m_cumulativeLine;
    }

    public boolean isPercentScale() {
        return this.m_percentScale;
    }

    protected double[][] prepareChartData() throws Exception {
        double[][] result;
        int i;
        double[] barsData;
        double allCountsSum = MathArrayUtils.arraySum((double[])this.getCount());
        double[] enumGroup = new double[this.getGroup().length];
        HashMap groupsMap = new HashMap();
        FormatArrayUtils.enumerate((Object[])this.getGroup(), (double[])enumGroup, groupsMap);
        double[][] merged = BasicArrayUtils.mergeArrays((double[])enumGroup, (double[])this.getCount());
        double[][] aggregated = FormatArrayUtils.aggregateByColumn((double[][])merged, (int)0);
        double threshold = allCountsSum * (double)this.getcoverPercent() / 100.0;
        double[][] descendData = BasicArrayUtils.sortByIndex((double[][])aggregated, (int)1, (boolean)false);
        double countsSum = 0.0;
        int lastNormalIndex = 0;
        int i2 = 0;
        while (i2 < descendData[0].length) {
            if ((countsSum += descendData[1][i2]) >= threshold) {
                lastNormalIndex = i2;
                break;
            }
            ++i2;
        }
        double othersCount = allCountsSum - countsSum;
        if (othersCount == 0.0) {
            barsData = new double[lastNormalIndex + 1];
            i = 0;
            while (i < barsData.length) {
                barsData[i] = descendData[1][i];
                ++i;
            }
        } else {
            barsData = new double[lastNormalIndex + 2];
            i = 0;
            while (i < barsData.length - 1) {
                barsData[i] = descendData[1][i];
                ++i;
            }
            barsData[barsData.length - 1] = othersCount;
        }
        double[] lineData = new double[barsData.length];
        lineData[0] = barsData[0];
        int i3 = 1;
        while (i3 < lineData.length) {
            lineData[i3] = lineData[i3 - 1] + barsData[i3];
            ++i3;
        }
        if (this.isPercentScale()) {
            int i4 = 0;
            while (i4 < barsData.length) {
                barsData[i4] = barsData[i4] / allCountsSum * 100.0;
                ++i4;
            }
            if (this.isCumulativeLine()) {
                int i5 = 0;
                while (i5 < lineData.length) {
                    lineData[i5] = lineData[i5] / allCountsSum * 100.0;
                    ++i5;
                }
            }
        }
        if (this.isCumulativeLine()) {
            result = new double[2][barsData.length];
            result[0] = barsData;
            result[1] = lineData;
        } else {
            result = new double[1][barsData.length];
            result[0] = barsData;
        }
        String[] legend = new String[barsData.length];
        int i6 = 0;
        while (i6 < legend.length) {
            legend[i6] = (String)groupsMap.get(new Double(descendData[0][i6]));
            ++i6;
        }
        if (othersCount != 0.0) {
            legend[legend.length - 1] = this.getOthersLabel();
        }
        this.setRowsDesc(legend);
        if (this.isPercentScale()) {
            this.applyYTitle("Percentage");
        } else {
            this.applyYTitle("Frequency");
        }
        this.applyXTitle(this.getGroupTitle());
        if (this.getTitle() == "") {
            this.setTitle("Pareto Chart For ".concat(this.getGroupTitle()));
        }
        return result;
    }

    private void setCount(double[] m_count) {
        this.m_count = m_count;
    }

    public void setCumulativeLine(boolean m_cumulativeLine) {
        this.m_cumulativeLine = m_cumulativeLine;
    }

    private void setGroup(Object[] m_group) {
        this.m_group = m_group;
    }

    public void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }

    public void setOthersLabel(String m_othersLabel) {
        this.m_othersLabel = m_othersLabel;
    }

    public void setPercentScale(boolean m_percentScale) {
        this.m_percentScale = m_percentScale;
    }

    public void setcoverPercent(int m_coverPercent) {
        this.m_coverPercent = m_coverPercent;
    }
}

