/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;
import java.util.HashMap;

public class Pie
extends Chart {
    private Object[] m_group;
    private double[] m_data;
    private String m_dataTitle;
    private String m_groupTitle;
    private boolean m_percentage;
    private double m_coverPercent;
    private String m_othersLabel;

    public Pie(XMultiServiceFactory _xMultiServiceFactory, double[] _data, String _dataTitle, Object[] _group, String _groupTitle) throws Exception {
        super(_xMultiServiceFactory, "com.sun.star.chart.PieDiagram");
        this.setData(_data);
        this.setGroup(_group);
        this.setDataTitle(_dataTitle);
        this.setGroupTitle(_groupTitle);
        this.setPercentage(false);
        this.setcoverPercent(95.0);
        this.setOthersLabel("Others");
    }

    public Pie(XMultiServiceFactory _xMultiServiceFactory, Object[] _group, String _groupTitle) throws Exception {
        this(_xMultiServiceFactory, null, null, _group, _groupTitle);
    }

    protected void applyAppearance() throws Exception {
        this.applyXAxisDescriptionVisibility(false);
        this.applyYAxisDescriptionVisibility(false);
        this.applyXLegendLabels();
        this.applyYLegendLabels();
        this.applyLegendBg();
        this.applyTextLegendSymbols(true);
        this.applyYTitle(this.getDataTitle());
        this.applyXTitle(this.getGroupTitle());
        this.applyLegendVisibility(false);
        this.applyXAxisBreak(false);
    }

    public double[] getData() {
        return this.m_data;
    }

    public String getDataTitle() {
        return this.m_dataTitle;
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    public String getOthersLabel() {
        return this.m_othersLabel;
    }

    public double getcoverPercent() {
        return this.m_coverPercent;
    }

    public boolean isPercentage() {
        return this.m_percentage;
    }

    protected double[][] prepareChartData() throws Exception {
        int i;
        double[] newData;
        if (this.getData() == null) {
            double[] dummyData = new double[this.getGroup().length];
            Arrays.fill(dummyData, 1.0);
            this.setData(dummyData);
            this.setDataTitle("");
        }
        double[] group = new double[this.getGroup().length];
        HashMap groupsMap = new HashMap();
        Object[] objGroup = this.getGroup();
        FormatArrayUtils.enumerate((Object[])objGroup, (double[])group, groupsMap);
        double dataSum = MathArrayUtils.arraySum((double[])this.getData());
        double[][] merged = BasicArrayUtils.mergeArrays((double[])group, (double[])this.getData());
        double[][] aggregated = FormatArrayUtils.aggregateByColumn((double[][])merged, (int)0);
        double threshold = dataSum * this.getcoverPercent() / 100.0;
        double[][] descendData = BasicArrayUtils.sortByIndex((double[][])aggregated, (int)1, (boolean)false);
        double countsSum = 0.0;
        int lastNormalIndex = 0;
        int i2 = 0;
        while (i2 < descendData[0].length) {
            if ((countsSum += descendData[1][i2]) >= threshold) {
                lastNormalIndex = i2;
                break;
            }
            ++i2;
        }
        double othersCount = dataSum - countsSum;
        if (othersCount == 0.0) {
            newData = new double[lastNormalIndex + 1];
            i = 0;
            while (i < newData.length) {
                newData[i] = descendData[1][i];
                ++i;
            }
        } else {
            newData = new double[lastNormalIndex + 2];
            i = 0;
            while (i < newData.length - 1) {
                newData[i] = descendData[1][i];
                ++i;
            }
            newData[newData.length - 1] = othersCount;
        }
        this.setData(newData);
        double[] newGroups = new double[this.getData().length];
        int i3 = 0;
        while (i3 < newGroups.length) {
            newGroups[i3] = descendData[0][i3];
            ++i3;
        }
        double[] sumData = FormatArrayUtils.arraySumByKey((double[])newGroups, (double[])this.getData());
        double[] percentage = MathArrayUtils.arrayPercentage((double[])sumData);
        String[] labels = new String[sumData.length];
        int i4 = 0;
        while (i4 < descendData[0].length) {
            double nu = descendData[0][i4];
            labels[i4] = othersCount != 0.0 && i4 == labels.length - 1 ? "Others" : (String)groupsMap.get(new Double(nu));
            int n = i4;
            labels[n] = String.valueOf(labels[n]) + " " + String.valueOf(descendData[1][i4]);
            Double rounded = new Double(percentage[i4]);
            int n2 = i4++;
            labels[n2] = String.valueOf(labels[n2]) + " (" + rounded.intValue() + "%)";
        }
        this.setRowsDesc(labels);
        double[][] result = new double[1][sumData.length];
        result[0] = sumData;
        return result;
    }

    private void setData(double[] m_data) {
        this.m_data = m_data;
    }

    private void setDataTitle(String m_dataTitle) {
        this.m_dataTitle = m_dataTitle;
    }

    private void setGroup(Object[] m_group) {
        this.m_group = m_group;
    }

    private void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }

    public void setOthersLabel(String m_othersLabel) {
        this.m_othersLabel = m_othersLabel;
    }

    public void setPercentage(boolean m_percentage) {
        this.m_percentage = m_percentage;
    }

    public void setcoverPercent(double m_coverPercent) {
        this.m_coverPercent = m_coverPercent;
    }
}

