/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.BasicArrayUtils;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.lang.XMultiServiceFactory;
import java.util.Arrays;
import java.util.HashMap;

public class ScatterPlot
extends Chart {
    private Object[] m_group;
    private double[] m_xData;
    private double[] m_yData;
    private String m_xDataTitle;
    private String m_yDataTitle;
    protected boolean m_xAxisVisible;

    public ScatterPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _xData, String _xDataTitle, double[] _yData, String _yDataTitle) throws Exception {
        this(_xMultiServiceFactory, _xData, _xDataTitle, _yData, _yDataTitle, null, null);
    }

    public ScatterPlot(XMultiServiceFactory _xMultiServiceFactory, double[] _xData, String _xDataTitle, double[] _yData, String _yDataTitle, Object[] _group, String _groupTitle) throws NullPointerException {
        super(_xMultiServiceFactory, "com.sun.star.chart.XYDiagram");
        if (_xData == null) {
            throw new NullPointerException("ScatterPlot: X data was recieved an null");
        }
        if (_xDataTitle == null) {
            throw new NullPointerException("ScatterPlot: X data title was recieved an null");
        }
        if (_yData == null) {
            throw new NullPointerException("ScatterPlot: Y data was recieved an null");
        }
        if (_yDataTitle == null) {
            throw new NullPointerException("ScatterPlot: Y data title was recieved an null");
        }
        this.setXData(_xData);
        this.setYData(_yData);
        this.setGroup(_group);
        this.setXDataTitle(_xDataTitle);
        this.setYDataTitle(_yDataTitle);
        this.m_xAxisVisible = false;
    }

    protected void applyAppearance() throws Exception {
        this.showAxis(this.m_xAxisVisible, true);
        this.showLines();
        this.applySymbolLine(false);
        this.applyYAutoOrigin(true);
        this.applyXLegendLabels();
        this.applyYLegendLabels();
        this.applyLegendBg();
        this.applyYTitle(this.getYDataTitle());
        this.applyXTitle(this.getXDataTitle());
        this.applyXAxisBreak(false);
        if (this.getGroup() != null) {
            int i = 0;
            while (i < MathArrayUtils.distinctValues((Object[])this.getGroup()) && i < this.COLOR.length) {
                this.applySeriesSymboleType(7, i + 1);
                this.applySeiresSymboleSize(i + 1, 5);
                this.applySeriesColor(i + 1, this.COLOR[i]);
                ++i;
            }
        } else {
            this.applySeriesColor(0, SOColor.RED_COLOR);
        }
        if (this.getGroup() == null) {
            this.applyLegendVisibility(false);
        }
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public double[] getXData() {
        return this.m_xData;
    }

    public String getXDataTitle() {
        return this.m_xDataTitle;
    }

    public double[] getYData() {
        return this.m_yData;
    }

    public String getYDataTitle() {
        return this.m_yDataTitle;
    }

    protected synchronized double[][] prepareChartData() throws Exception {
        double[] group;
        HashMap groupsMap = new HashMap();
        if (this.getGroup() == null) {
            Object[] tmpGroup = new String[this.getYData().length];
            Arrays.fill(tmpGroup, new String(""));
            group = new double[this.getYData().length];
            FormatArrayUtils.enumerate((Object[])tmpGroup, (double[])group, groupsMap);
        } else {
            group = new double[this.getGroup().length];
            FormatArrayUtils.enumerate((Object[])this.getGroup(), (double[])group, groupsMap);
        }
        double[][] splitedYData = FormatArrayUtils.splitByKey((double[])group, (double[])this.getYData(), (double)this.getNotANumber());
        double[][] chartData = BasicArrayUtils.mergeArrays((double[])this.getXData(), (double[][])splitedYData);
        chartData = BasicArrayUtils.sortByIndex((double[][])chartData, (int)0);
        String[] colsDesc = FormatArrayUtils.getKeysText((double[])group, groupsMap);
        this.setColumnDesc(colsDesc);
        return chartData;
    }

    private void setGroup(Object[] m_group) {
        this.m_group = m_group;
    }

    public void setXData(double[] m_xData) {
        this.m_xData = m_xData;
    }

    public void setXDataTitle(String m_xDataTitle) {
        this.m_xDataTitle = m_xDataTitle;
    }

    public void setYData(double[] m_yData) {
        this.m_yData = m_yData;
    }

    public void setYDataTitle(String m_yDataTitle) {
        this.m_yDataTitle = m_yDataTitle;
    }
}

