/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class SimpleLine
extends Chart {
    private Object[] m_legend;
    private Object[] m_group;
    private double[] m_yData;
    private String m_dataTitle;
    private String m_groupTitle;
    private double[][] m_chartData;

    public SimpleLine(XMultiServiceFactory _xMultiServiceFactory, double[] _yData, String _dataTitle, Object[] _group, String _groupTitle, Object[] _legend) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.LineDiagram");
        if (_yData == null || _group == null || _dataTitle == null || _groupTitle == null) {
            throw new InvalidInputException("line chart: one or more parameters are null");
        }
        if (_yData.length != _group.length) {
            throw new InvalidInputException("line chart: data length should be equal to group length");
        }
        this.setYData(_yData);
        this.setGroup(_group);
        this.setDataTitle(_dataTitle);
        this.setGroupTitle(_groupTitle);
        this.setLegend(_legend);
        this.setChartData(null);
    }

    public SimpleLine(XMultiServiceFactory _xMultiServiceFactory, double[][] _data, String _dataTitle, Object[] _group, String _groupTitle, Object[] _legend) throws InvalidInputException {
        super(_xMultiServiceFactory, "com.sun.star.chart.LineDiagram");
        if (_data == null || _dataTitle == null || _groupTitle == null) {
            throw new InvalidInputException("line chart: one or more parameters are null");
        }
        if (_data.length != _group.length) {
            throw new InvalidInputException("line chart: number of groups doesnt match data length");
        }
        this.setChartData(_data);
        this.setDataTitle(_dataTitle);
        this.setGroupTitle(_groupTitle);
        this.setLegend(_legend);
        this.setGroup(_group);
        this.setYData(null);
    }

    protected void applyAppearance() throws Exception {
        this.applySymbolsVisibility(true);
        this.applyRectSymbols();
        double[] minMax = new double[2];
        if (this.getChartData() == null) {
            MathArrayUtils.getRadicalValues((double[])this.getYData(), (double[])minMax);
        } else {
            MathArrayUtils.getRadicalValues((double[][])this.getChartData(), (double[])minMax);
        }
        double min = minMax[0];
        double max = minMax[1];
        double setmax = Chart.changeValueByPercent(max, 10.0);
        double setmin = Chart.changeValueByPercent(min, -10.0);
        this.applyYMax(setmax);
        this.applyYMin(setmin);
        this.applyXLegendLabelsNoHeader();
        String[] rowsLegend = new String[this.getLegend().length];
        int i = 0;
        while (i < rowsLegend.length) {
            rowsLegend[i] = String.valueOf(this.m_legend[i]);
            ++i;
        }
        this.setRowsDesc(rowsLegend);
        this.applyYLegendLabels();
        this.applyYTitle(this.getDataTitle());
        this.applyXTitle(this.getGroupTitle());
        this.applyXAxisBreak(false);
        int groupsNo = this.getChartData() == null ? MathArrayUtils.distinctValues((Object[])this.getGroup()) : this.getChartData().length;
        int i2 = 0;
        while (i2 < groupsNo && i2 < this.COLOR.length) {
            this.applySeriesLineColor(i2, this.COLOR[i2]);
            ++i2;
        }
        this.applyLegendBg();
    }

    public double[][] getChartData() {
        return this.m_chartData;
    }

    public String getDataTitle() {
        return this.m_dataTitle;
    }

    public Object[] getGroup() {
        return this.m_group;
    }

    public String getGroupTitle() {
        return this.m_groupTitle;
    }

    public Object[] getLegend() {
        return this.m_legend;
    }

    public double[] getYData() {
        return this.m_yData;
    }

    protected double[][] prepareChartData() throws Exception {
        double[][] splitedData;
        if (this.getChartData() == null) {
            double[] enumGroup = new double[this.getGroup().length];
            String[] keysStr = new String[MathArrayUtils.distinctValues((Object[])this.getGroup())];
            FormatArrayUtils.enumerate((Object[])this.getGroup(), (double[])enumGroup, (String[])keysStr);
            splitedData = FormatArrayUtils.splitByKeyTiled((double[])enumGroup, (double[])this.getYData(), (double)this.getNotANumber());
            this.setColumnDesc(keysStr);
        } else {
            splitedData = this.getChartData();
            String[] keysStr = new String[this.getGroup().length];
            int i = 0;
            while (i < keysStr.length) {
                keysStr[i] = String.valueOf(this.m_group[i]);
                ++i;
            }
            this.setColumnDesc(keysStr);
        }
        return splitedData;
    }

    private void setChartData(double[][] m_cahrtData) {
        this.m_chartData = m_cahrtData;
    }

    private void setDataTitle(String m_dataTitle) {
        this.m_dataTitle = m_dataTitle;
    }

    private void setGroup(Object[] m_group) {
        this.m_group = m_group;
    }

    private void setGroupTitle(String m_groupTitle) {
        this.m_groupTitle = m_groupTitle;
    }

    private void setLegend(Object[] m_legend) {
        this.m_legend = m_legend;
    }

    private void setYData(double[] m_yData) {
        this.m_yData = m_yData;
    }
}

