/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Chart;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class Stock
extends Chart {
    private double[] m_Ucl;
    private double[] m_Lcl;
    private double[] m_Scores;
    private String[] m_GroupTitle;
    private String m_YaxisTitle;
    private double m_min;
    private double m_max;
    private int m_numOfStocks;
    private int m_numOfDataInput;

    public Stock(XMultiServiceFactory _xMultiServiceFactory, double[] _Ucl, double[] _Lcl, double[] _Scores, String[] _GroupTitle) throws Exception {
        super(_xMultiServiceFactory, "com.sun.star.chart.StockDiagram");
        if (_Ucl.length != _Lcl.length || _Ucl.length != _Scores.length || _Ucl.length != _GroupTitle.length) {
            throw new InvalidInputException("Stock chart: worng number of parmeters for all input arrays");
        }
        this.setUcl(_Ucl);
        this.setLcl(_Lcl);
        this.setScores(_Scores);
        this.setGroupTitle(_GroupTitle);
        this.setNumOfDataInput(3);
        this.setYAxisTitle("");
    }

    protected void applyAppearance() throws Exception {
        this.showLines(true);
        this.applyLegendVisibility(true);
        this.applyXAxisStep(1.0);
        this.applyXAxisBreak(false);
        String[] ColsName = new String[this.m_numOfDataInput];
        ColsName[0] = "95% UCL";
        ColsName[1] = "Calculated Score";
        ColsName[2] = "95% LCL";
        this.setColumnDesc(ColsName);
        this.applyXLegendLabelsNoHeader();
        this.applyRectSymbols();
        this.setRowsDesc(this.m_GroupTitle);
        this.applyYLegendLabels();
        this.m_max = Chart.changeValueByPercent(this.m_max, 10.0);
        this.m_min = Chart.changeValueByPercent(this.m_min, -15.0);
        double[] minMax = this.axisRoundByPercent(this.m_min, this.m_max);
        this.applyYMax(minMax[1]);
        this.applyYMin(minMax[0]);
        this.applyYScalePercent(true);
        this.applySeriesTriangleSymbols(1);
        if (this.getYAxisTitle() != "") {
            this.applyYTitle(this.getYAxisTitle());
        }
    }

    void findMinAndMax() {
        double[] uclValue = new double[2];
        double[] scoresValue = new double[2];
        double[] lclValue = new double[2];
        MathArrayUtils.getRadicalValues((double[])this.m_Ucl, (double[])uclValue);
        MathArrayUtils.getRadicalValues((double[])this.m_Scores, (double[])scoresValue);
        MathArrayUtils.getRadicalValues((double[])this.m_Lcl, (double[])lclValue);
        this.m_min = uclValue[0];
        this.m_max = uclValue[1];
        if (scoresValue[0] < this.m_min) {
            this.m_min = scoresValue[0];
        }
        if (lclValue[0] < this.m_min) {
            this.m_min = lclValue[0];
        }
        if (scoresValue[1] > this.m_max) {
            this.m_max = scoresValue[1];
        }
        if (lclValue[1] > this.m_max) {
            this.m_max = lclValue[1];
        }
    }

    private String[] getGroupTitle() {
        return this.m_GroupTitle;
    }

    private double[] getLcl() {
        return this.m_Lcl;
    }

    private double[] getScores() {
        return this.m_Scores;
    }

    private double[] getUcl() {
        return this.m_Ucl;
    }

    public String getYAxisTitle() {
        return this.m_YaxisTitle;
    }

    protected double[][] prepareChartData() throws Exception {
        this.m_numOfStocks = this.getGroupTitle().length;
        double[][] chartData = new double[this.m_numOfDataInput][this.m_numOfStocks];
        int i = 0;
        while (i < this.m_numOfStocks) {
            chartData[0][i] = this.m_Ucl[i];
            chartData[1][i] = this.m_Scores[i];
            chartData[2][i] = this.m_Lcl[i];
            ++i;
        }
        this.findMinAndMax();
        return chartData;
    }

    private void setGroupTitle(String[] _GroupTitle) {
        this.m_GroupTitle = _GroupTitle;
    }

    private void setLcl(double[] _Lcl) {
        this.m_Lcl = _Lcl;
    }

    private void setNumOfDataInput(int number) {
        this.m_numOfDataInput = number;
    }

    private void setScores(double[] _Scores) {
        this.m_Scores = _Scores;
    }

    private void setUcl(double[] _Ucl) {
        this.m_Ucl = _Ucl;
    }

    public void setYAxisTitle(String name) {
        this.m_YaxisTitle = name;
    }
}

