/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.SigmaMathLib;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Control;
import com.ivistaportal.solibrary.chart.ControlConsts;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class XBar
extends Control {
    private double[] m_averages;
    private int m_subGroupSize;

    public XBar(XMultiServiceFactory _xMultiServiceFactory, double[] _averages, int _subGroupSize) throws Exception {
        this(_xMultiServiceFactory, _averages, _subGroupSize, null);
    }

    public XBar(XMultiServiceFactory _xMultiServiceFactory, double[] _averages, int _subGroupSize, String[] _groupLabels) throws InvalidInputException {
        super(_xMultiServiceFactory);
        if (_groupLabels != null && _averages.length % _groupLabels.length != 0) {
            throw new InvalidInputException();
        }
        this.setAverages(_averages);
        this.setGroupLabels(_groupLabels);
        this.setTest1Active(true);
        this.setSubGroupSize(_subGroupSize);
    }

    public double[] getAverages() {
        return this.m_averages;
    }

    public int getSubGroupSize() {
        return this.m_subGroupSize;
    }

    protected double[][] prepareChartData() throws Exception {
        SigmaMathLib lib = new SigmaMathLib(this.getXMultiServiceFactory());
        double middle = MathArrayUtils.arrayAverage((double[])this.getAverages());
        double sigma = lib.stDev((Object[])FormatArrayUtils.toDouble((double[])this.getAverages()));
        double coef = ControlConsts.getControlConst(3, this.m_subGroupSize);
        double ucl = middle + coef * sigma;
        double lcl = middle - coef * sigma;
        double[][] chartData = this.calcData(this.getAverages(), lcl, middle, ucl);
        return chartData;
    }

    public void setAverages(double[] m_averages) {
        this.m_averages = m_averages;
    }

    public void setSubGroupSize(int m_subGroupSize) {
        this.m_subGroupSize = m_subGroupSize;
    }
}

