/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Control;
import com.ivistaportal.solibrary.chart.ControlConsts;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class XBarR
extends Control {
    private double[] m_mins;
    private double[] m_maxes;
    private int m_subGroupCount;

    public XBarR(XMultiServiceFactory _xMultiServiceFactory, double[] _mins, double[] _maxes, int _subGroupCount) throws Exception {
        this(_xMultiServiceFactory, _mins, _maxes, _subGroupCount, null);
    }

    public XBarR(XMultiServiceFactory _xMultiServiceFactory, double[] _mins, double[] _maxes, int _subGroupCount, String[] _groupLabels) throws InvalidInputException {
        super(_xMultiServiceFactory);
        if (_mins.length != _maxes.length || _subGroupCount < 2) {
            throw new InvalidInputException();
        }
        if (_groupLabels != null && _mins.length % _groupLabels.length != 0) {
            throw new InvalidInputException();
        }
        this.setMins(_mins);
        this.setMaxes(_maxes);
        this.setGroupLabels(_groupLabels);
        this.setTest1Active(true);
        this.setSubGroupCount(_subGroupCount);
    }

    public double[] getMaxes() {
        return this.m_maxes;
    }

    public double[] getMins() {
        return this.m_mins;
    }

    public int getSubGroupCount() {
        return this.m_subGroupCount;
    }

    protected double[][] prepareChartData() throws Exception {
        double[] data = new double[this.getMaxes().length];
        int i = 0;
        while (i < data.length) {
            data[i] = this.m_maxes[i] - this.m_mins[i];
            ++i;
        }
        double middle = MathArrayUtils.arrayAverage((double[])data);
        double ucl = middle * ControlConsts.getControlConst(5, this.getSubGroupCount());
        double lcl = middle * ControlConsts.getControlConst(4, this.getSubGroupCount());
        double[][] chartData = this.calcData(data, lcl, middle, ucl);
        return chartData;
    }

    public void setMaxes(double[] m_maxes) {
        this.m_maxes = m_maxes;
    }

    public void setMins(double[] m_mins) {
        this.m_mins = m_mins;
    }

    public void setSubGroupCount(int m_subGroupCount) {
        this.m_subGroupCount = m_subGroupCount;
    }
}

