/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chart;

import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chart.Control;
import com.ivistaportal.solibrary.chart.ControlConsts;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.sun.star.lang.XMultiServiceFactory;

public class XBarS
extends Control {
    private double[] m_stDivs;
    private double[] m_averages;
    private double[] m_mins;
    private double[] m_maxes;
    private int m_subGroupCount;

    public XBarS(XMultiServiceFactory _xMultiServiceFactory, double[] _stDivs, double[] _mins, double[] _maxes, int _subGroupCount) throws InvalidInputException {
        this(_xMultiServiceFactory, _stDivs, _mins, _maxes, _subGroupCount, null);
    }

    public XBarS(XMultiServiceFactory _xMultiServiceFactory, double[] _stDivs, double[] _mins, double[] _maxes, int _subGroupCount, String[] _groupLabels) throws InvalidInputException {
        super(_xMultiServiceFactory);
        if (_subGroupCount < 2) {
            throw new InvalidInputException("XBarS chart: sub group must be >1");
        }
        if (_groupLabels != null && _stDivs.length % _groupLabels.length != 0) {
            throw new InvalidInputException("XBarS chart: impossible number of groups");
        }
        this.setMins(_mins);
        this.setMaxes(_maxes);
        this.setStDivs(_stDivs);
        this.setGroupLabels(_groupLabels);
        this.setTest1Active(false);
        this.setSubGroupCount(_subGroupCount);
    }

    public double[] getMaxes() {
        return this.m_maxes;
    }

    public double[] getMins() {
        return this.m_mins;
    }

    public double[] getStDivs() {
        return this.m_stDivs;
    }

    public int getSubGroupCount() {
        return this.m_subGroupCount;
    }

    protected double[][] prepareChartData() throws Exception {
        double[] data = new double[this.getMaxes().length];
        int i = 0;
        while (i < data.length) {
            data[i] = this.m_maxes[i] - this.m_mins[i];
            ++i;
        }
        double middle = MathArrayUtils.arrayAverage((double[])data);
        double lcl = middle * ControlConsts.getControlConst(0, this.getSubGroupCount());
        double ucl = middle * ControlConsts.getControlConst(1, this.getSubGroupCount());
        double[][] chartData = this.calcData(this.getStDivs(), lcl, middle, ucl);
        return chartData;
    }

    public void setMaxes(double[] m_maxes) {
        this.m_maxes = m_maxes;
    }

    public void setMins(double[] m_mins) {
        this.m_mins = m_mins;
    }

    public void setStDivs(double[] m_stDivs) {
        this.m_stDivs = m_stDivs;
    }

    public void setSubGroupCount(int m_subGroupCount) {
        this.m_subGroupCount = m_subGroupCount;
    }
}

