/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chartservice;

import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.chartservice.SOChartService;
import com.ivistaportal.solibrary.chartservice.SeriesInfo;
import com.ivistaportal.solibrary.drawing.DelimitedShape;
import com.ivistaportal.solibrary.drawing.LineShape;
import com.ivistaportal.solibrary.drawing.RectangleShape;
import com.ivistaportal.solibrary.protocols.ChartDocumentProtocol;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;

public class BoxplotService
extends SOChartService {
    private final double CONFIDENCE_HEIGHT = 0.92;
    public static final String SERVICE_NAME = "com.ivistaportal.solibrary.Boxplot";
    public static final String IMPLEMENTATION_NAME = "com.ivistaportal.solibrary.BoxplotImpl";
    private static final String BASE_DIAGRAM_NAME = "com.sun.star.chart.XYDiagram";
    private static final String DIAGRAM_TYPE_NAME = "com.ivistaportal.solibrary.chart.BoxplotDiagram";
    private static final String DIAGRAM_SHAPE_TYPE_NAME = "com.ivistaportal.solibrary.chart.BoxplotDiagramShape";
    private static final int WHISKERS_HIGH = 5;
    private static final int FIRST_QUARTILE = 4;
    private static final int MEAN = 3;
    private static final int MEDIAN = 2;
    private static final int THIRD_QUARTILE = 1;
    private static final int WHISKERS_LOW = 0;
    private DelimitedShape m_confidenceShape;
    private Vector m_series = new Vector();
    private Vector m_meanLines = new Vector();
    private Vector m_medianLines = new Vector();
    private double m_boxWidth = 0.8;
    private boolean m_meanConnect = false;
    private boolean m_medianConnect = false;
    private long m_boxesColor = SOColor.WHITE_COLOR;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void ensureMeanLines(int _count) throws Exception {
        int linesCount = this.m_meanLines.size();
        if (linesCount < _count) {
            int i = linesCount;
            while (i < _count) {
                LineShape lineShape = new LineShape(this.getChartFactory());
                this.addShape(lineShape);
                lineShape.setLineColor((int)SOColor.BROWN_COLOR);
                lineShape.setLineWidth(20);
                this.m_meanLines.add(lineShape);
                ++i;
            }
        }
    }

    private void ensureMedianLines(int _count) throws Exception {
        int linesCount = this.m_medianLines.size();
        if (linesCount < _count) {
            int i = linesCount;
            while (i < _count) {
                LineShape lineShape = new LineShape(this.getChartFactory());
                this.addShape(lineShape);
                lineShape.setLineColor((int)SOColor.BROWN_COLOR);
                this.m_medianLines.add(lineShape);
                ++i;
            }
        }
    }

    private Vector ensureSeries(double[][] _data) throws InvalidInputException {
        int seriesCount;
        double NaN = ChartDocumentProtocol.getNotANumber(this.m_xChartDocument);
        boolean BOX_NO_COL = false;
        boolean BOX_DATA_COL = true;
        Vector<double[]> result = new Vector<double[]>();
        if (_data[0].length < 6) {
            return result;
        }
        double boxNo = 1.0;
        int dataIndex = 0;
        int groupElementsNo = 0;
        double[] boxData = new double[6];
        while (dataIndex < _data[0].length) {
            if (_data[0][dataIndex] == boxNo) {
                if (_data[1][dataIndex] != NaN) {
                    if (groupElementsNo == 6) {
                        throw new InvalidInputException("BoxPlotService: too many box values");
                    }
                    boxData[groupElementsNo] = _data[1][dataIndex];
                    ++groupElementsNo;
                }
                ++dataIndex;
                continue;
            }
            if (groupElementsNo != 6) {
                throw new InvalidInputException("BoxPlotService: too few box values");
            }
            groupElementsNo = 0;
            boxNo = _data[0][dataIndex];
            result.add(boxData);
            boxData = new double[6];
        }
        if (groupElementsNo != 6 && groupElementsNo != 0) {
            throw new InvalidInputException("BoxPlotService: too few box values");
        }
        result.add(boxData);
        int i = seriesCount = this.m_series.size();
        while ((double)i < boxNo) {
            this.m_series.add(new BoxplotSeries());
            ++i;
        }
        return result;
    }

    public Double getAvg() {
        return this.m_confidenceShape.getAvg();
    }

    protected String getBaseDiagramName() {
        return BASE_DIAGRAM_NAME;
    }

    public Double getBoxWidth() {
        return new Double(this.m_boxWidth);
    }

    public Double getBoxesColor() {
        return new Double(this.m_boxesColor);
    }

    public Boolean getConnectMean() {
        return new Boolean(this.m_meanConnect);
    }

    public Boolean getConnectMedian() {
        return new Boolean(this.m_medianConnect);
    }

    protected String getDiagramTypeName() {
        return DIAGRAM_TYPE_NAME;
    }

    public Double getHighConfidence() {
        return this.m_confidenceShape.getHighConfidence();
    }

    public Double getHo() {
        return this.m_confidenceShape.getExternalPoint();
    }

    public String getImplementationName() throws RuntimeException {
        return IMPLEMENTATION_NAME;
    }

    public Double getLowConfidence() {
        return this.m_confidenceShape.getLowConfidence();
    }

    public String getServiceName() throws RuntimeException {
        return SERVICE_NAME;
    }

    protected String getShapeTypeName() {
        return DIAGRAM_SHAPE_TYPE_NAME;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return new String[]{SERVICE_NAME, "com.sun.star.chart.Diagram"};
    }

    protected void init() {
        this.addProperty("ConnectMean", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = BoxplotService.class$("java.lang.Boolean")));
        this.addProperty("ConnectMedian", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = BoxplotService.class$("java.lang.Boolean")));
        this.addProperty("BoxWidth", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
        this.addProperty("BoxesColor", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
        this.addProperty("Avg", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
        this.addProperty("Ho", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
        this.addProperty("HighConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
        this.addProperty("LowConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = BoxplotService.class$("java.lang.Double")));
    }

    public synchronized void refresh() throws RuntimeException {
        try {
            if (this.m_xChartDocument != null) {
                if (this.getPosition() == null || this.getSize() == null) {
                    return;
                }
                System.out.println("boxplot position : " + this.getPosition().X + " - " + this.getPosition().Y);
                System.out.println("boxplot size : " + this.getSize().Width + " - " + this.getSize().Height);
                double[][] data = ChartDocumentProtocol.getChartData(this.m_xChartDocument);
                data = FormatArrayUtils.rotateMatrix((double[][])data);
                Vector newData = this.ensureSeries(data);
                int count = newData.size();
                if (count > 0) {
                    int i = 0;
                    while (i < count) {
                        BoxplotSeries series = (BoxplotSeries)this.m_series.elementAt(i);
                        series.refresh((double[])newData.elementAt(i), i);
                        ++i;
                    }
                    if (this.m_meanConnect) {
                        this.ensureMeanLines(count - 1);
                        int i2 = 0;
                        while (i2 < count - 1) {
                            Point pointFrom = ((BoxplotSeries)this.m_series.elementAt(i2)).getVisualPoint(3);
                            Point pointTo = ((BoxplotSeries)this.m_series.elementAt(i2 + 1)).getVisualPoint(3);
                            LineShape line = (LineShape)this.m_meanLines.elementAt(i2);
                            line.setPosition(pointFrom);
                            Size lineSize = new Size();
                            lineSize.Height = pointTo.Y - pointFrom.Y;
                            lineSize.Width = pointTo.X - pointFrom.X;
                            if (lineSize.Height == 0) {
                                lineSize.Height = 1;
                            }
                            if (lineSize.Width == 0) {
                                lineSize.Width = 1;
                            }
                            line.setSize(lineSize);
                            Point start = new Point(pointFrom.X, pointFrom.Y);
                            Point end = new Point(pointFrom.X + lineSize.Width, pointFrom.Y + lineSize.Height);
                            Point[] points = new Point[]{start, end};
                            XShape xShape = line.getXShape();
                            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : BoxplotService.class$("com.sun.star.beans.XPropertySet")), (Object)xShape);
                            xPropertySet.setPropertyValue("PolyPolygon", (Object)points);
                            ++i2;
                        }
                    }
                    if (this.m_medianConnect) {
                        this.ensureMedianLines(count);
                        XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = BoxplotService.class$("com.sun.star.drawing.XShape"))), (Object)this.getXAxis());
                        SeriesInfo seriesInfo = SOChartService.getSeriesInfo(xshape, false);
                        int boxWidth = new Double((double)seriesInfo.getSeriesWidth() * this.m_boxWidth).intValue();
                        int i3 = 0;
                        while (i3 < count - 1) {
                            Point pointFrom = ((BoxplotSeries)this.m_series.elementAt(i3)).getVisualPoint(2);
                            Point pointTo = ((BoxplotSeries)this.m_series.elementAt(i3 + 1)).getVisualPoint(2);
                            LineShape line = (LineShape)this.m_medianLines.elementAt(i3);
                            Point pos = new Point();
                            pos.X = pointFrom.X + boxWidth / 2;
                            pos.Y = pointFrom.Y;
                            line.setPosition(pos);
                            Size lineSize = new Size();
                            lineSize.Height = pointTo.Y - pointFrom.Y;
                            lineSize.Width = pointTo.X - pointFrom.X - boxWidth;
                            if (lineSize.Height == 0) {
                                lineSize.Height = 1;
                            }
                            if (lineSize.Width == 0) {
                                lineSize.Width = 1;
                            }
                            line.setSize(lineSize);
                            ++i3;
                        }
                    }
                    if (count == 1) {
                        if (this.m_confidenceShape == null) {
                            this.m_confidenceShape = new DelimitedShape(this.getChartFactory(), true);
                        }
                        this.m_confidenceShape.refresh(this.getXChartDocument(), 1.5);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException("dotplot refresh fault", (Object)ex);
        }
    }

    public void setAvg(Double _value) {
        this.m_confidenceShape.setAvg(_value);
        this.refresh();
    }

    public void setBoxWidth(Double _value) {
        this.m_boxWidth = _value;
        this.refresh();
    }

    public void setBoxesColor(Double _value) {
        this.m_boxesColor = _value.longValue();
        this.refresh();
    }

    public void setConnectMean(Boolean _value) {
        this.m_meanConnect = _value;
        this.refresh();
    }

    public void setConnectMedian(Boolean _value) {
        this.m_medianConnect = _value;
        this.refresh();
    }

    public void setHighConfidence(Double _value) {
        this.m_confidenceShape.setHighConfidence(_value);
        this.refresh();
    }

    public void setHo(Double _value) {
        this.m_confidenceShape.setExternalPoint(_value);
        this.refresh();
    }

    public void setLowConfidence(Double _value) {
        this.m_confidenceShape.setLowConfidence(_value);
        this.refresh();
    }

    class BoxplotSeries {
        private double[] m_points = new double[6];
        private Point[] m_visualPoints = new Point[]{new Point(), new Point(), new Point(), new Point(), new Point(), new Point()};
        private LineShape m_shapeWhiskersHigh = null;
        private RectangleShape m_shapeQuartile = null;
        private LineShape m_shapeMedian = null;
        private RectangleShape m_shapeMean = null;
        private LineShape m_shapeWhiskersLow = null;

        BoxplotSeries() {
        }

        private boolean ensureShapes() throws Exception {
            if (this.m_shapeWhiskersHigh == null) {
                this.m_shapeWhiskersHigh = new LineShape(BoxplotService.this.getChartFactory());
                BoxplotService.this.addShape(this.m_shapeWhiskersHigh);
                this.m_shapeWhiskersHigh.setLineColor((int)SOColor.BROWN_COLOR);
            }
            if (this.m_shapeQuartile == null) {
                this.m_shapeQuartile = new RectangleShape(BoxplotService.this.getChartFactory());
                BoxplotService.this.addShape(this.m_shapeQuartile);
            }
            if (this.m_shapeMedian == null) {
                this.m_shapeMedian = new LineShape(BoxplotService.this.getChartFactory());
                BoxplotService.this.addShape(this.m_shapeMedian);
                this.m_shapeMedian.setLineColor((int)SOColor.BROWN_COLOR);
            }
            if (this.m_shapeMean == null) {
                this.m_shapeMean = new RectangleShape(BoxplotService.this.getChartFactory());
                this.m_shapeMean.getXShape();
                BoxplotService.this.addShape(this.m_shapeMean);
            }
            if (this.m_shapeWhiskersLow == null) {
                this.m_shapeWhiskersLow = new LineShape(BoxplotService.this.getChartFactory());
                BoxplotService.this.addShape(this.m_shapeWhiskersLow);
                this.m_shapeWhiskersLow.setLineColor((int)SOColor.BROWN_COLOR);
            }
            return true;
        }

        public Point getVisualPoint(int _index) {
            Point result = null;
            if (_index >= 0 && _index < this.m_points.length) {
                result = this.m_visualPoints[_index];
            }
            return result;
        }

        void refresh(double[] _data, int _series) throws Exception {
            System.out.println("refresh on series : " + _series);
            this.ensureShapes();
            this.updatePoints(_data, _series);
            this.updateShapes();
        }

        private void updatePoints(double[] _data, int _series) {
            XShape yshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = BoxplotService.class$("com.sun.star.drawing.XShape"))), (Object)BoxplotService.this.getYAxis());
            XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = BoxplotService.class$("com.sun.star.drawing.XShape"))), (Object)BoxplotService.this.getXAxis());
            SeriesInfo seriesInfo = SOChartService.getSeriesInfo(xshape, false);
            int i = 0;
            while (i < 6) {
                this.m_visualPoints[i].X = seriesInfo.getSeriesPosition(_series);
                this.m_visualPoints[i].Y = SOChartService.convertLogical2Visual(yshape, _data[i], true);
                ++i;
            }
        }

        private void updateShapes() throws Exception {
            XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = BoxplotService.class$("com.sun.star.drawing.XShape"))), (Object)BoxplotService.this.getXAxis());
            SeriesInfo seriesInfo = SOChartService.getSeriesInfo(xshape, false);
            int boxWidth = new Double((double)seriesInfo.getSeriesWidth() * BoxplotService.this.m_boxWidth).intValue();
            this.m_shapeWhiskersHigh.setPosition(this.m_visualPoints[5]);
            this.m_shapeWhiskersHigh.setSize(new Size(1, this.m_visualPoints[4].Y - this.m_visualPoints[5].Y));
            Point pos = new Point(this.m_visualPoints[4].X - boxWidth / 2, this.m_visualPoints[4].Y);
            this.m_shapeQuartile.setPosition(pos);
            Size size = new Size(boxWidth, this.m_visualPoints[1].Y - this.m_visualPoints[4].Y);
            this.m_shapeQuartile.setSize(size);
            pos = new Point(this.m_visualPoints[2].X - boxWidth / 2, this.m_visualPoints[2].Y);
            this.m_shapeMedian.setPosition(pos);
            this.m_shapeMedian.setSize(new Size(boxWidth, 1));
            int meanHeight = Math.abs(this.m_visualPoints[4].Y - this.m_visualPoints[1].Y);
            meanHeight = Math.min(boxWidth / 10, meanHeight / 10);
            this.m_shapeMean.setSize(new Size(boxWidth / 10, meanHeight));
            pos = new Point(this.m_visualPoints[3].X - boxWidth / 20, this.m_visualPoints[3].Y - meanHeight / 20);
            this.m_shapeMean.setPosition(pos);
            this.m_shapeWhiskersLow.setPosition(this.m_visualPoints[1]);
            this.m_shapeWhiskersLow.setSize(new Size(1, this.m_visualPoints[0].Y - this.m_visualPoints[1].Y));
        }
    }
}

