/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chartservice;

import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.math.arrayutils.MathArrayUtils;
import com.ivistaportal.solibrary.chartservice.SOChartService;
import com.ivistaportal.solibrary.drawing.DelimitedShape;
import com.ivistaportal.solibrary.protocols.ChartDocumentProtocol;
import com.sun.star.uno.RuntimeException;

public class DotplotService
extends SOChartService {
    public static final String SERVICE_NAME = "com.ivistaportal.solibrary.Dotplot";
    public static final String IMPLEMENTATION_NAME = "com.ivistaportal.solibrary.DotplotImpl";
    private static final String BASE_DIAGRAM_NAME = "com.sun.star.chart.XYDiagram";
    private static final String DIAGRAM_TYPE_NAME = "com.ivistaportal.solibrary.chart.DotplotDiagram";
    private static final String DIAGRAM_SHAPE_TYPE_NAME = "com.ivistaportal.solibrary.chart.DotplotDiagramShape";
    private DelimitedShape m_confidenceShape;
    static /* synthetic */ Class class$java$lang$Double;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void ensureShapes() throws Exception {
        if (this.m_confidenceShape == null) {
            this.m_confidenceShape = new DelimitedShape(this.getChartFactory(), true);
        }
    }

    public Double getAvg() {
        return this.m_confidenceShape.getAvg();
    }

    protected String getBaseDiagramName() {
        return BASE_DIAGRAM_NAME;
    }

    protected String getDiagramTypeName() {
        return DIAGRAM_TYPE_NAME;
    }

    private int getGroupsNo() {
        double[][] data = ChartDocumentProtocol.getChartData(this.m_xChartDocument);
        if (data != null) {
            data = FormatArrayUtils.rotateMatrix((double[][])data);
            return MathArrayUtils.distinctValues((double[])data[0]);
        }
        return 0;
    }

    public Double getHighConfidence() {
        return this.m_confidenceShape.getHighConfidence();
    }

    public Double getHo() {
        return this.m_confidenceShape.getExternalPoint();
    }

    public String getImplementationName() throws RuntimeException {
        return IMPLEMENTATION_NAME;
    }

    public Double getLowConfidence() {
        return this.m_confidenceShape.getLowConfidence();
    }

    public String getServiceName() throws RuntimeException {
        return SERVICE_NAME;
    }

    protected String getShapeTypeName() {
        return DIAGRAM_SHAPE_TYPE_NAME;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return new String[]{SERVICE_NAME, "com.sun.star.chart.Diagram"};
    }

    protected void init() {
        this.addProperty("Ho", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DotplotService.class$("java.lang.Double")));
        this.addProperty("Avg", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DotplotService.class$("java.lang.Double")));
        this.addProperty("HighConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DotplotService.class$("java.lang.Double")));
        this.addProperty("LowConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DotplotService.class$("java.lang.Double")));
    }

    public void refresh() throws RuntimeException {
        block2: {
            if (this.getGroupsNo() != 1) break block2;
            try {
                this.ensureShapes();
                this.m_confidenceShape.refresh(this.getXChartDocument(), 1.5);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new RuntimeException("Histogram refresh fault ", (Object)ex);
            }
        }
    }

    public void setAvg(Double _value) {
        this.m_confidenceShape.setAvg(_value);
        this.refresh();
    }

    public void setHighConfidence(Double _value) {
        this.m_confidenceShape.setHighConfidence(_value);
        this.refresh();
    }

    public void setHo(Double _value) {
        this.m_confidenceShape.setExternalPoint(_value);
        this.refresh();
    }

    public void setLowConfidence(Double _value) {
        this.m_confidenceShape.setLowConfidence(_value);
        this.refresh();
    }
}

