/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chartservice;

import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.chartservice.SOChartService;
import com.ivistaportal.solibrary.chartservice.SeriesInfo;
import com.ivistaportal.solibrary.drawing.DelimitedShape;
import com.ivistaportal.solibrary.drawing.EllipseShape;
import com.ivistaportal.solibrary.drawing.LineShape;
import com.ivistaportal.solibrary.protocols.DrawingProtocol;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.drawing.XShape;
import com.sun.star.uno.RuntimeException;

public class HistogramService
extends SOChartService {
    public static final String SERVICE_NAME = "com.ivistaportal.solibrary.Histogram";
    public static final String IMPLEMENTATION_NAME = "com.ivistaportal.solibrary.HistogramImpl";
    private static final String BASE_DIAGRAM_NAME = "com.sun.star.chart.BarDiagram";
    private static final String DIAGRAM_TYPE_NAME = "com.ivistaportal.solibrary.chart.HistogramDiagram";
    private static final String DIAGRAM_SHAPE_TYPE_NAME = "com.ivistaportal.solibrary.chart.HistogramDiagramShape";
    private DelimitedShape m_confidenceShape;
    private double m_UCL = Double.MIN_VALUE;
    private double m_LCL = Double.MIN_VALUE;
    private LineShape m_lineUCL = null;
    private LineShape m_lineLCL = null;
    static /* synthetic */ Class class$java$lang$Double;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private LineShape ensureShape(double _value, LineShape _shape, long _color) throws Exception {
        if (_value != Double.MIN_VALUE && _shape == null) {
            _shape = new LineShape(this.getChartFactory());
            _shape.setLineColor((int)_color);
            this.addShape(_shape);
        } else if (_value == Double.MIN_VALUE && _shape != null) {
            this.removeShape(_shape);
            _shape = null;
        }
        return _shape;
    }

    private void ensureShapes() throws Exception {
        if (this.m_confidenceShape == null) {
            this.m_confidenceShape = new DelimitedShape(this.getChartFactory(), false);
        }
        this.m_lineUCL = this.ensureShape(this.m_UCL, this.m_lineUCL, SOColor.BRIGHT_PINK_COLOR);
        this.m_lineLCL = this.ensureShape(this.m_LCL, this.m_lineLCL, SOColor.BRIGHT_PINK_COLOR);
    }

    private double getAligningYPos() throws Exception {
        XShape yshape = DrawingProtocol.getXShape(this.getYAxis());
        SeriesInfo axisYInfo = SOChartService.getSeriesInfo(yshape, true);
        double min = axisYInfo.getMinValue();
        double step = axisYInfo.getStepValue();
        double yPos = min - 1.5 * step;
        return yPos;
    }

    public Double getAvg() {
        return this.m_confidenceShape.getAvg();
    }

    protected String getBaseDiagramName() {
        return BASE_DIAGRAM_NAME;
    }

    protected String getDiagramTypeName() {
        return DIAGRAM_TYPE_NAME;
    }

    public Double getHighConfidence() {
        return this.m_confidenceShape.getHighConfidence();
    }

    public Double getHo() {
        return this.m_confidenceShape.getExternalPoint();
    }

    public String getImplementationName() throws RuntimeException {
        return IMPLEMENTATION_NAME;
    }

    public Double getLCL() {
        return new Double(this.m_LCL);
    }

    public Double getLowConfidence() {
        return this.m_confidenceShape.getLowConfidence();
    }

    public String getServiceName() throws RuntimeException {
        return SERVICE_NAME;
    }

    protected String getShapeTypeName() {
        return DIAGRAM_SHAPE_TYPE_NAME;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return new String[]{SERVICE_NAME, "com.sun.star.chart.Diagram"};
    }

    public Double getUCL() {
        return new Double(this.m_UCL);
    }

    protected void init() {
        this.addProperty("UCL", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
        this.addProperty("LCL", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
        this.addProperty("Ho", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
        this.addProperty("Avg", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
        this.addProperty("HighConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
        this.addProperty("LowConfidence", class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = HistogramService.class$("java.lang.Double")));
    }

    public void refresh() throws RuntimeException {
        try {
            this.ensureShapes();
            this.updateConfidence(this.m_confidenceShape);
            if (this.m_lineUCL != null) {
                this.updateLine(this.m_UCL, this.m_lineUCL);
            }
            if (this.m_lineLCL != null) {
                this.updateLine(this.m_LCL, this.m_lineLCL);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new RuntimeException("Histogram refresh fault ", (Object)ex);
        }
    }

    public void setAvg(Double _value) {
        this.m_confidenceShape.setAvg(_value);
        this.refresh();
    }

    public void setHighConfidence(Double _value) {
        this.m_confidenceShape.setHighConfidence(_value);
        this.refresh();
    }

    public void setHo(Double _value) {
        this.m_confidenceShape.setExternalPoint(_value);
        this.refresh();
    }

    public void setLCL(Double _value) {
        this.m_LCL = _value;
        this.refresh();
    }

    public void setLowConfidence(Double _value) {
        this.m_confidenceShape.setLowConfidence(_value);
        this.refresh();
    }

    public void setUCL(Double _value) {
        this.m_UCL = _value;
        this.refresh();
    }

    private void updateConfidence(DelimitedShape _confidenceShape) throws Exception {
        double yPos = this.getAligningYPos();
        _confidenceShape.refresh(this.getXChartDocument(), yPos);
    }

    private void updateEllipse(double _value, EllipseShape _ellipse) throws InvalidInputException, PropertyVetoException, Exception {
        XShape xshape = DrawingProtocol.getXShape(this.getXAxis());
        SeriesInfo axisXInfo = SOChartService.getSeriesInfo(xshape, false);
        XShape yshape = DrawingProtocol.getXShape(this.getYAxis());
        SeriesInfo axisYInfo = SOChartService.getSeriesInfo(yshape, true);
        int height = EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo);
        int xPos = SOChartService.convertLogical2Visual(xshape, _value, false);
    }

    private void updateLine(double _value, LineShape _line) throws InvalidInputException, PropertyVetoException {
        XShape xshape = DrawingProtocol.getXShape(this.getXAxis());
        SeriesInfo axisXInfo = SOChartService.getSeriesInfo(xshape, false);
        XShape yshape = DrawingProtocol.getXShape(this.getYAxis());
        SeriesInfo axisYInfo = SOChartService.getSeriesInfo(yshape, true);
        if (_value < axisXInfo.getMinValue() || _value > axisXInfo.getMaxValue()) {
            throw new InvalidInputException();
        }
        int xposLine = SOChartService.convertLogical2Visual(xshape, _value, false);
        int yposLine = axisYInfo.getPosition() + new Double((double)axisYInfo.getLength() * 0.05).intValue();
        int hieghtLine = new Double((double)axisYInfo.getLength() * 0.95).intValue();
        _line.setPosition(new Point(xposLine, yposLine));
        _line.setSize(new Size(1, hieghtLine));
    }
}

