/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chartservice;

import com.ivistaportal.math.FrequencyTable;
import com.ivistaportal.math.arrayutils.FormatArrayUtils;
import com.ivistaportal.solibrary.chart.Histogram;
import com.ivistaportal.solibrary.chartservice.SOChartService;
import com.ivistaportal.solibrary.drawing.RectangleShape;
import com.ivistaportal.solibrary.drawing.Shape;
import com.ivistaportal.solibrary.drawing.TextShape;
import com.ivistaportal.solibrary.protocols.ChartDocumentProtocol;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.drawing.XShape;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MarginalplotService
extends SOChartService {
    public static final String SERVICE_NAME = "com.ivistaportal.solibrary.Marginalplot";
    public static final String IMPLEMENTATION_NAME = "com.ivistaportal.solibrary.MarginalplotImpl";
    private static final String BASE_DIAGRAM_NAME = "com.sun.star.chart.XYDiagram";
    private static final String DIAGRAM_TYPE_NAME = "com.ivistaportal.solibrary.chart.MarginalplotDiagram";
    private static final String DIAGRAM_SHAPE_TYPE_NAME = "com.ivistaportal.solibrary.chart.MarginalplotDiagramShape";
    private static final double SIZE_CF = 0.85;
    private static final double SIZE_CF_INV = 1.15;
    private BarMargin m_verticalBar;
    private BarMargin m_horizontalBar;
    private boolean m_diagramResize = true;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void ensureDiagramSize(boolean _resize) {
        Point position = this.getPosition();
        Size size = this.getSize();
        try {
            Point dpos = this.m_xChartDocument.getDiagram().getPosition();
            Size dsize = this.m_xChartDocument.getDiagram().getSize();
        }
        catch (Exception exception) {
            System.out.println("diagram is null");
        }
        try {
            if (!_resize && this.m_diagramResize) {
                this.m_xChartDocument.getDiagram().setPosition(new Point(position.X, new Double((double)position.Y + (double)size.Height * 0.15000000000000002).intValue()));
                this.m_xChartDocument.getDiagram().setSize(new Size(new Double((double)size.Width * 0.85).intValue(), new Double((double)size.Height * 0.85).intValue()));
                this.m_diagramResize = false;
            }
        }
        catch (Exception exception) {
            System.out.println("does't change size or position property");
        }
    }

    protected String getBaseDiagramName() {
        return BASE_DIAGRAM_NAME;
    }

    protected String getDiagramTypeName() {
        return DIAGRAM_TYPE_NAME;
    }

    private double[] getHorizontalBarsData(double[][] _chartData) {
        double[] horizontalData = this.getYValues(_chartData);
        int horizontalBinsNo = Histogram.calcNumOfBins(horizontalData.length);
        double horizontalStep = FrequencyTable.calcStepByGroupsNum((double[])horizontalData, (int)horizontalBinsNo);
        double[][] hortFreqTab = FrequencyTable.createFrequencyTable((double[])horizontalData, (int)horizontalBinsNo, (boolean)false);
        double[] result = new double[hortFreqTab[1].length];
        int i = 0;
        while (i < result.length) {
            result[i] = hortFreqTab[1][hortFreqTab[1].length - 1 - i];
            ++i;
        }
        return result;
    }

    public String getImplementationName() throws RuntimeException {
        return IMPLEMENTATION_NAME;
    }

    public String getServiceName() throws RuntimeException {
        return SERVICE_NAME;
    }

    protected String getShapeTypeName() {
        return DIAGRAM_SHAPE_TYPE_NAME;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return new String[]{SERVICE_NAME, "com.sun.star.chart.Diagram"};
    }

    private double[] getVerticalBarsData(double[][] _chartData) {
        double[] verticalData = this.getXValues(_chartData);
        int verticalBinsNo = Histogram.calcNumOfBins(verticalData.length);
        double verticalStep = FrequencyTable.calcStepByGroupsNum((double[])verticalData, (int)verticalBinsNo);
        double[][] vertFreqTab = FrequencyTable.createFrequencyTable((double[])verticalData, (int)verticalBinsNo, (boolean)false);
        return vertFreqTab[1];
    }

    private double[] getXValues(double[][] _chartData) {
        Vector<Double> xValues = new Vector<Double>();
        int index = 0;
        double NaN = ChartDocumentProtocol.getNotANumber(this.m_xChartDocument);
        int i = 1;
        while (i < _chartData.length) {
            int j = 0;
            while (j < _chartData[0].length) {
                if (_chartData[i][j] != NaN) {
                    Double currData = new Double(_chartData[0][j]);
                    xValues.add(index, currData);
                    ++index;
                }
                ++j;
            }
            ++i;
        }
        double[] result = new double[xValues.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Double)xValues.get(i2);
            ++i2;
        }
        return result;
    }

    private double[] getYUniqueValues(double[][] _chartData) {
        HashMap<Double, Object> map = new HashMap<Double, Object>();
        double NaN = ChartDocumentProtocol.getNotANumber(this.m_xChartDocument);
        int i = 1;
        while (i < _chartData.length) {
            int j = 0;
            while (j < _chartData[0].length) {
                Double currData = new Double(_chartData[i][j]);
                if (!map.containsKey(currData) && currData != NaN) {
                    map.put(currData, new Object());
                }
                ++j;
            }
            ++i;
        }
        double[] result = new double[map.size()];
        Iterator values = map.keySet().iterator();
        int i2 = 0;
        while (values.hasNext()) {
            result[i2] = (Double)values.next();
            ++i2;
        }
        return result;
    }

    private double[] getYValues(double[][] _chartData) {
        Vector<Double> yValues = new Vector<Double>();
        int index = 0;
        double NaN = ChartDocumentProtocol.getNotANumber(this.m_xChartDocument);
        int i = 1;
        while (i < _chartData.length) {
            int j = 0;
            while (j < _chartData[0].length) {
                Double currData = new Double(_chartData[i][j]);
                if (currData != NaN) {
                    yValues.add(index, currData);
                    ++index;
                }
                ++j;
            }
            ++i;
        }
        double[] result = new double[yValues.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Double)yValues.get(i2);
            ++i2;
        }
        return result;
    }

    protected void init() {
        this.ensureDiagramSize(true);
        this.m_verticalBar = new BarMargin(this, true);
        this.m_horizontalBar = new BarMargin(this, false);
    }

    public synchronized void refresh() throws RuntimeException {
        try {
            System.out.println("in refresh");
            this.ensureDiagramSize(false);
            XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = MarginalplotService.class$("com.sun.star.drawing.XShape"))), (Object)this.getXAxis());
            XShape yshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = MarginalplotService.class$("com.sun.star.drawing.XShape"))), (Object)this.getYAxis());
            Point pos = yshape.getPosition();
            Size size = new Size(xshape.getSize().Width, yshape.getSize().Height);
            Point verticalPos = new Point();
            verticalPos.X = pos.X;
            verticalPos.Y = new Double((double)pos.Y - ((double)size.Height * 1.15 - (double)size.Height)).intValue();
            Size verticalSize = new Size();
            verticalSize.Width = size.Width;
            verticalSize.Height = new Double((double)size.Height * 1.15 - (double)size.Height).intValue();
            Point horizontalPos = new Point(pos.X + size.Width, pos.Y);
            Size horizontalSize = new Size();
            horizontalSize.Width = new Double((double)size.Width * 1.15 - (double)size.Width).intValue();
            horizontalSize.Height = size.Height;
            double[][] chartData = FormatArrayUtils.rotateMatrix((double[][])ChartDocumentProtocol.getChartData(this.m_xChartDocument));
            double[] verticalBarsData = this.getVerticalBarsData(chartData);
            double[] horizontalBarsData = this.getHorizontalBarsData(chartData);
            this.m_verticalBar.refresh(verticalPos, verticalSize, verticalBarsData);
            this.m_horizontalBar.refresh(horizontalPos, horizontalSize, horizontalBarsData);
        }
        catch (Exception ex) {
            new RuntimeException("Marginalplot refresh fault", (Object)ex);
        }
    }

    class BarMargin {
        private MarginalplotService m_service;
        private Vector m_barShapes = new Vector();
        private Vector m_textShapes = new Vector();
        private Size m_size;
        private Point m_position;
        private boolean m_vertical;
        private double m_maxValue;
        private int m_barWidth;
        private int m_textHeight;
        private static final double TEXT_MARGIN = 0.1;

        public BarMargin(MarginalplotService _service, boolean _vertical) {
            this.m_service = _service;
            this.m_vertical = _vertical;
        }

        private double calculateMax(double[] _data) {
            double result = _data[0];
            int count = _data.length;
            int i = 1;
            while (i < count) {
                result = Math.max(result, _data[i]);
                ++i;
            }
            return result;
        }

        private int convertLogical2Visual(double _data) {
            double result = 0.0;
            double dataCF = _data / this.m_maxValue;
            result = this.m_vertical ? (double)this.m_size.Height * dataCF : (double)this.m_size.Width * dataCF;
            return new Double(result).intValue();
        }

        private void ensureShapes(int _count) throws Exception {
            block3: {
                int shapesCount;
                block2: {
                    shapesCount = this.m_barShapes.size();
                    if (shapesCount >= _count) break block2;
                    RectangleShape rectShape = null;
                    TextShape textShape = null;
                    int i = shapesCount;
                    while (i < _count) {
                        rectShape = new RectangleShape(this.m_service.getChartFactory());
                        this.m_service.addShape(rectShape);
                        this.m_barShapes.add(rectShape);
                        textShape = new TextShape(this.m_service.getChartFactory());
                        this.m_service.addShape(textShape);
                        textShape.setAutoGrowWidth(true);
                        this.m_textShapes.add(textShape);
                        ++i;
                    }
                    break block3;
                }
                if (shapesCount <= _count) break block3;
                int i = _count;
                while (i < shapesCount) {
                    this.m_service.removeShape((Shape)this.m_barShapes.elementAt(i));
                    this.m_service.removeShape((Shape)this.m_textShapes.elementAt(i));
                    ++i;
                }
            }
        }

        void refresh(Point _position, Size _size, double[] _data) throws Exception {
            System.out.println("refreshing marginal plot");
            int dataCount = _data.length;
            this.ensureShapes(dataCount);
            if (this.m_vertical) {
                this.m_textHeight = new Double((double)_size.Height * 0.1).intValue();
                this.m_position = new Point(_position.X, this.m_textHeight + _position.Y);
                this.m_size = new Size(_size.Width, _size.Height - this.m_textHeight);
            } else {
                this.m_textHeight = new Double((double)_size.Width * 0.1).intValue();
                this.m_position = _position;
                this.m_size = new Size(_size.Width - this.m_textHeight, _size.Height);
            }
            this.m_maxValue = this.calculateMax(_data);
            this.m_barWidth = this.m_vertical ? this.m_size.Width / dataCount : this.m_size.Height / dataCount;
            int i = 0;
            while (i < dataCount) {
                this.updateBar(i, _data[i]);
                ++i;
            }
        }

        private void updateBar(int _index, double _data) throws Exception {
            int top = this.convertLogical2Visual(_data);
            RectangleShape barShape = (RectangleShape)this.m_barShapes.elementAt(_index);
            TextShape textShape = (TextShape)this.m_textShapes.elementAt(_index);
            Size barSize = new Size();
            Point barPos = new Point();
            Size textSize = new Size();
            Point textPos = new Point();
            if (this.m_vertical) {
                barSize.Height = top;
                barSize.Width = this.m_barWidth;
                barPos.X = this.m_position.X + this.m_barWidth * _index;
                barPos.Y = this.m_position.Y + this.m_size.Height - top;
                textSize.Height = this.m_textHeight;
                textSize.Width = barSize.Width;
                textPos.X = barPos.X + barSize.Width / 2 - textSize.Width / 2;
                textPos.Y = barPos.Y - textSize.Height;
            } else {
                barSize.Height = this.m_barWidth;
                barSize.Width = top;
                barPos.X = this.m_position.X;
                barPos.Y = this.m_position.Y + this.m_barWidth * _index;
                textSize.Height = barSize.Height;
                textSize.Width = this.m_textHeight;
                textPos.X = barPos.X;
                textPos.Y = barPos.Y - barSize.Height / 2 - textSize.Height / 2;
            }
            barShape.setPosition(barPos);
            barShape.setSize(barSize);
            textShape.setPosition(textPos);
        }
    }
}

