/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.chartservice;

import com.ivistaportal.solibrary.chartservice.SeriesInfo;
import com.ivistaportal.solibrary.drawing.Shape;
import com.ivistaportal.solibrary.protocols.ChartDiagramProtocol;
import com.ivistaportal.solibrary.protocols.ChartDocumentProtocol;
import com.ivistaportal.solibrary.protocols.DrawingProtocol;
import com.ivistaportal.solibrary.service.SOService;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.chart.XAxisXSupplier;
import com.sun.star.chart.XAxisYSupplier;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XRefreshListener;
import com.sun.star.util.XRefreshable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class SOChartService
extends SOService
implements XInitialization,
XRefreshable,
XDiagram,
XAxisXSupplier,
XAxisYSupplier,
XPropertySet {
    protected static final String DIAGRAM_SERVICE_NAME = "com.sun.star.chart.Diagram";
    protected static final String PROPNAME_BASEDIAGRAM = "BaseDiagram";
    protected XChartDocument m_xChartDocument;
    private Hashtable m_propertiesTable;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;

    protected void addProperty(String _name, Class _type) {
        this.addProperty(_name.trim(), _type, "get" + _name.trim(), "set" + _name.trim());
    }

    protected void addProperty(String _name, Class _type, String _getMethod, String _setMethod) {
        try {
            if (this.m_propertiesTable == null) {
                this.m_propertiesTable = new Hashtable();
            }
            PropertyInfo propInfo = new PropertyInfo(this, _name.trim(), _type, _getMethod.trim(), _setMethod.trim());
            this.m_propertiesTable.put(_name, propInfo);
        }
        catch (Exception exception) {}
    }

    public void addPropertyChangeListener(String parm1, XPropertyChangeListener parm2) throws UnknownPropertyException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
    }

    public void addRefreshListener(XRefreshListener parm1) throws RuntimeException {
        throw new UnsupportedOperationException("Method addRefreshListener() not yet implemented.");
    }

    protected void addShape(Shape _shape) {
        DrawingProtocol.addShape(_shape, this.m_xChartDocument);
    }

    public void addVetoableChangeListener(String parm1, XVetoableChangeListener parm2) throws UnknownPropertyException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static int convertLogical2Visual(XShape _shape, double _value, boolean _vertical) {
        int result = 0;
        Point point = SOChartService.getLogicalPosition(_shape, _value, _vertical);
        result = _vertical ? point.Y : point.X;
        return result;
    }

    public static Point convertLogical2Visual(XShape _xAxisShape, XShape _yAxisShape, double _xLogical, double _yLogical) {
        Point xPoint = SOChartService.getLogicalPosition(_xAxisShape, _xLogical, false);
        Point yPoint = SOChartService.getLogicalPosition(_yAxisShape, _yLogical, true);
        Point result = new Point(xPoint.X, yPoint.Y);
        return result;
    }

    public static Point convertLogical2Visual(XShape _xAxisShape, XShape _yAxisShape, Point _logicalPoint) {
        return SOChartService.convertLogical2Visual(_xAxisShape, _yAxisShape, new Point(_logicalPoint.X, _logicalPoint.Y));
    }

    protected abstract String getBaseDiagramName();

    protected XMultiServiceFactory getChartFactory() {
        return (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory != null ? class$com$sun$star$lang$XMultiServiceFactory : (class$com$sun$star$lang$XMultiServiceFactory = SOChartService.class$("com.sun.star.lang.XMultiServiceFactory"))), (Object)this.m_xChartDocument);
    }

    public synchronized XPropertySet getDataPointProperties(int _nCol, int _nRow) throws IndexOutOfBoundsException, RuntimeException {
        XPropertySet result = null;
        if (this.m_xChartDocument == null) {
            XDiagram diagram = this.m_xChartDocument.getDiagram();
            result = diagram.getDataPointProperties(_nCol, _nRow);
        }
        return result;
    }

    public synchronized XPropertySet getDataRowProperties(int _nRow) throws IndexOutOfBoundsException, RuntimeException {
        XPropertySet result = null;
        if (this.m_xChartDocument == null) {
            XDiagram diagram = this.m_xChartDocument.getDiagram();
            result = diagram.getDataRowProperties(_nRow);
        }
        return result;
    }

    public synchronized String getDiagramType() throws RuntimeException {
        System.out.println(">>> call XDiagram.getDiagramType");
        return this.getDiagramType();
    }

    protected abstract String getDiagramTypeName();

    protected static Point getLogicalPosition(XShape _shape, double _value, boolean _vertical) {
        Point result;
        block4: {
            result = null;
            if (_shape == null) break block4;
            Size shapeSize = _shape.getSize();
            int length = _vertical ? shapeSize.Height : shapeSize.Width;
            XPropertySet shapePropSet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SOChartService.class$("com.sun.star.beans.XPropertySet"))), (Object)_shape);
            if (shapePropSet != null) {
                try {
                    double max = ((Float)shapePropSet.getPropertyValue("Max")).doubleValue();
                    double min = ((Float)shapePropSet.getPropertyValue("Min")).doubleValue();
                    double range = max - min;
                    if (range == 0.0) break block4;
                    double percent = (_value - min) / range;
                    Point shapePosition = _shape.getPosition();
                    result = new Point();
                    if (_vertical) {
                        double percentPoints = (double)length * (1.0 - percent);
                        result.X = shapePosition.X;
                        result.Y = shapePosition.Y + new Double(percentPoints).intValue();
                        break block4;
                    }
                    double percentPoints = (double)length * percent;
                    result.Y = shapePosition.Y;
                    result.X = shapePosition.X + new Double(percentPoints).intValue();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public synchronized Point getPosition() throws RuntimeException {
        System.out.println(">>> call XDiagram.getPosition");
        Point result = null;
        if (this.m_xChartDocument != null) {
            XShape shape = DrawingProtocol.getXShape(this.m_xChartDocument);
            result = shape.getPosition();
        }
        return result;
    }

    public XPropertySetInfo getPropertySetInfo() throws RuntimeException {
        System.out.println(">>> call XProperySet");
        PropertySetInfo propInfo = new PropertySetInfo(this.m_propertiesTable);
        return propInfo;
    }

    public Object getPropertyValue(String _name) throws UnknownPropertyException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
        if (this.m_xChartDocument != null) {
            if (this.m_propertiesTable.containsKey(_name)) {
                try {
                    PropertyInfo prop = (PropertyInfo)this.m_propertiesTable.get(_name);
                    Object result = prop.invokeGet();
                    return result;
                }
                catch (Exception ex) {
                    new RuntimeException("Error getting property " + _name + " value.", (Object)ex);
                }
            } else {
                new UnknownPropertyException("Unknown property : " + _name);
            }
        }
        return null;
    }

    public static SeriesInfo getSeriesInfo(XShape _shape, boolean _vertical) {
        SeriesInfo result;
        block3: {
            result = null;
            if (_shape == null) break block3;
            Size shapeSize = _shape.getSize();
            int length = _vertical ? shapeSize.Height : shapeSize.Width;
            XPropertySet shapePropSet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SOChartService.class$("com.sun.star.beans.XPropertySet"))), (Object)_shape);
            if (shapePropSet != null) {
                try {
                    double max = ((Float)shapePropSet.getPropertyValue("Max")).doubleValue();
                    double min = ((Float)shapePropSet.getPropertyValue("Min")).doubleValue();
                    double step = ((Float)shapePropSet.getPropertyValue("StepMain")).doubleValue();
                    int position = _vertical ? _shape.getPosition().Y : _shape.getPosition().X;
                    result = new SeriesInfo(length, position, max, min, step);
                    System.out.println("series position : " + position + " size : " + length);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    protected int getSeriesPosition(XShape _shape, int _seriesNum, boolean _vertical) {
        int result;
        block4: {
            result = 0;
            if (_shape == null) break block4;
            Size shapeSize = _shape.getSize();
            int length = _vertical ? shapeSize.Height : shapeSize.Width;
            XPropertySet shapePropSet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SOChartService.class$("com.sun.star.beans.XPropertySet"))), (Object)_shape);
            if (shapePropSet != null) {
                try {
                    double max = ((Float)shapePropSet.getPropertyValue("Max")).doubleValue();
                    double min = ((Float)shapePropSet.getPropertyValue("Min")).doubleValue();
                    double step = ((Float)shapePropSet.getPropertyValue("StepMain")).doubleValue();
                    double range = max - min;
                    double stepCount = range / step;
                    if (!(stepCount >= (double)_seriesNum)) break block4;
                    double pointPos = (double)length / stepCount * (double)(_seriesNum + 1);
                    Point shapePosition = _shape.getPosition();
                    if (_vertical) {
                        result = new Double((double)shapePosition.Y + pointPos).intValue();
                        break block4;
                    }
                    result = new Double((double)shapePosition.X + pointPos).intValue();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public synchronized String getShapeType() throws RuntimeException {
        System.out.println(">>> call XDiagram.getShapeType");
        return this.getShapeType();
    }

    protected abstract String getShapeTypeName();

    public synchronized Size getSize() throws RuntimeException {
        System.out.println(">>> call XDiagram.getSize");
        Size result = null;
        if (this.m_xChartDocument != null) {
            XShape shape = DrawingProtocol.getXShape(this.m_xChartDocument);
            result = shape.getSize();
        }
        return result;
    }

    public synchronized XPropertySet getXAxis() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisXSupplier axisSupp = ChartDiagramProtocol.getXAxisXSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getXAxis();
        }
        return null;
    }

    public synchronized XShape getXAxisTitle() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisXSupplier axisSupp = ChartDiagramProtocol.getXAxisXSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getXAxisTitle();
        }
        return null;
    }

    protected XChartDocument getXChartDocument() {
        return this.m_xChartDocument;
    }

    public synchronized XPropertySet getXHelpGrid() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisXSupplier axisSupp = ChartDiagramProtocol.getXAxisXSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getXHelpGrid();
        }
        return null;
    }

    public synchronized XPropertySet getXMainGrid() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisXSupplier axisSupp = ChartDiagramProtocol.getXAxisXSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getXMainGrid();
        }
        return null;
    }

    public synchronized XPropertySet getYAxis() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisYSupplier axisSupp = ChartDiagramProtocol.getXAxisYSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getYAxis();
        }
        return null;
    }

    public synchronized XShape getYAxisTitle() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisYSupplier axisSupp = ChartDiagramProtocol.getXAxisYSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getYAxisTitle();
        }
        return null;
    }

    public synchronized XPropertySet getYHelpGrid() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisYSupplier axisSupp = ChartDiagramProtocol.getXAxisYSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getYHelpGrid();
        }
        return null;
    }

    public synchronized XPropertySet getYMainGrid() throws RuntimeException {
        if (this.m_xChartDocument != null) {
            XAxisYSupplier axisSupp = ChartDiagramProtocol.getXAxisYSupplier(this.m_xChartDocument.getDiagram());
            return axisSupp.getYMainGrid();
        }
        return null;
    }

    protected void init() {
    }

    public final void initialize(Object[] _arguments) throws com.sun.star.uno.Exception, RuntimeException {
        System.out.println("Begin initialization of chart service. Diagram type " + this.getDiagramTypeName());
        if (_arguments.length > 0) {
            this.m_xChartDocument = (XChartDocument)_arguments[0];
            if (this.m_xChartDocument != null) {
                XPropertySet propertySet;
                this.init();
                try {
                    propertySet = ChartDocumentProtocol.getXPropertySet(this.m_xChartDocument);
                }
                catch (Exception exception) {
                    throw new com.sun.star.uno.Exception("Cannot recieve property set interface");
                }
                String baseName = this.getBaseDiagramName();
                if (baseName != null && baseName.trim().length() > 0 && propertySet != null) {
                    propertySet.setPropertyValue(PROPNAME_BASEDIAGRAM, (Object)baseName);
                }
            }
        }
    }

    public abstract void refresh() throws RuntimeException;

    public void removePropertyChangeListener(String parm1, XPropertyChangeListener parm2) throws UnknownPropertyException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
    }

    public void removeRefreshListener(XRefreshListener parm1) throws RuntimeException {
        throw new UnsupportedOperationException("Method removeRefreshListener() not yet implemented.");
    }

    protected void removeShape(Shape _shape) {
        DrawingProtocol.removeShape(_shape, this.m_xChartDocument);
    }

    public void removeVetoableChangeListener(String parm1, XVetoableChangeListener parm2) throws UnknownPropertyException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
    }

    public synchronized void setPosition(Point _point) throws RuntimeException {
        System.out.println(">>> call XDiagram.setPosition");
        if (this.m_xChartDocument != null) {
            XShape shape = DrawingProtocol.getXShape(this.m_xChartDocument);
            shape.setPosition(_point);
        }
    }

    public void setPropertyValue(String _name, Object _value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, RuntimeException {
        System.out.println(">>> call XProperySet");
        if (this.m_xChartDocument != null) {
            if (this.m_propertiesTable.containsKey(_name)) {
                try {
                    PropertyInfo prop = (PropertyInfo)this.m_propertiesTable.get(_name);
                    prop.invokeSet(_value);
                }
                catch (Exception ex) {
                    new RuntimeException("Error getting property " + _name + " value.", (Object)ex);
                }
            } else {
                new UnknownPropertyException("Unknown property : " + _name);
            }
        }
    }

    public synchronized void setSize(Size _size) throws PropertyVetoException, RuntimeException {
        System.out.println(">>> call XDiagram.setSize");
        if (this.m_xChartDocument != null) {
            XShape shape = DrawingProtocol.getXShape(this.m_xChartDocument);
            shape.setSize(_size);
        }
    }

    public class PropertyInfo {
        private Object m_owner;
        private String m_name;
        private Class m_type;
        private Method m_getMethod;
        private Method m_setMethod;

        public PropertyInfo(Object _owner, String _name, Class _type, String _getMethod, String _setMethod) throws Exception {
            this.m_owner = _owner;
            this.m_name = _name;
            this.m_type = _type;
            if (_getMethod == null || _getMethod.trim().length() > 0) {
                this.m_getMethod = this.m_owner.getClass().getMethod(_getMethod, null);
            }
            if (_setMethod == null || _setMethod.trim().length() > 0) {
                this.m_setMethod = this.m_owner.getClass().getMethod(_setMethod, this.m_type);
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Object invokeGet() throws Exception {
            return this.m_getMethod.invoke(this.m_owner, null);
        }

        public void invokeSet(Object _value) throws Exception {
            this.m_setMethod.invoke(this.m_owner, _value);
        }
    }

    public class PropertySetInfo
    implements XPropertySetInfo {
        private Hashtable m_properties;

        public PropertySetInfo(Hashtable _properties) {
            this.m_properties = _properties;
        }

        public Property[] getProperties() throws RuntimeException {
            Property[] properties = new Property[this.m_properties.size()];
            Enumeration enumeration = this.m_properties.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                Property prop = new Property();
                PropertyInfo propInfo = (PropertyInfo)enumeration.nextElement();
                prop.Name = propInfo.getName();
                properties[i] = prop;
                ++i;
            }
            return properties;
        }

        public Property getPropertyByName(String _name) throws UnknownPropertyException, RuntimeException {
            Property result = new Property();
            if (this.m_properties.containsKey(_name)) {
                PropertyInfo propInfo = (PropertyInfo)this.m_properties.get(_name);
                result.Name = propInfo.getName();
            }
            return result;
        }

        public boolean hasPropertyByName(String _name) throws RuntimeException {
            return this.m_properties.containsKey(_name);
        }
    }
}

