/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.connector;

import com.ivistaportal.solibrary.protocols.SOConnectorProtocol;
import com.ivistaportal.solibrary.protocols.SpreadsheetDocumentProtocol;
import com.ivistaportal.solibrary.spreadsheet.SOSpreadsheetDocument;
import com.sun.star.awt.XTopWindow;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;

public class SOConnector {
    private XMultiServiceFactory m_xMSF = null;
    private String m_hostName = "localhost";
    private String m_portNo = "8100";

    public SOConnector() {
    }

    public SOConnector(XMultiServiceFactory _xMSF) {
        this.m_xMSF = _xMSF;
    }

    public SOConnector(String hostName, String portNo) {
        this.m_hostName = hostName;
        this.m_portNo = portNo;
    }

    public void connect() throws Exception {
        if (this.m_xMSF == null) {
            this.m_xMSF = SOConnectorProtocol.connect(this.m_hostName, this.m_portNo);
        }
    }

    public String[] getAvailableServiceNames() {
        String[] servicesNames = new String[]{};
        if (this.m_xMSF != null) {
            servicesNames = SOConnectorProtocol.getAvailableServiceNames(this.m_xMSF);
        }
        return servicesNames;
    }

    public SOSpreadsheetDocument getCurrentDocument() throws Exception {
        String docName = "";
        XSpreadsheetDocument xSpreadsheetDocument = SOConnectorProtocol.getCurrentDocument(this.m_xMSF);
        docName = SpreadsheetDocumentProtocol.getDocumentURL(xSpreadsheetDocument);
        SOSpreadsheetDocument soSpreadsheetDocument = new SOSpreadsheetDocument(xSpreadsheetDocument, docName);
        XTopWindow xTopWindow = SOConnectorProtocol.getCurrentWindow(this.m_xMSF);
        soSpreadsheetDocument.setXTopWindow(xTopWindow);
        return soSpreadsheetDocument;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public XMultiServiceFactory getMSF() {
        return this.m_xMSF;
    }

    public String getPortNo() {
        return this.m_portNo;
    }

    public SOSpreadsheetDocument newSpreadsheetDocument(boolean _visible) throws Exception {
        return this.openSpreadsheetDocument("staroffice.factory:scalc", _visible);
    }

    public SOSpreadsheetDocument openSpreadsheetDocument(String _docName, boolean _Visible) throws Exception {
        XSpreadsheetDocument xSpreadsheetDocument = SOConnectorProtocol.openDocument(this.m_xMSF, _docName, _Visible);
        SOSpreadsheetDocument soSpreadsheetDocument = new SOSpreadsheetDocument(xSpreadsheetDocument, _docName);
        return soSpreadsheetDocument;
    }

    public void setHostName(String _hostName) {
        this.m_hostName = _hostName;
        this.m_xMSF = null;
    }

    public void setPortNo(String _portNo) {
        this.m_portNo = _portNo;
        this.m_xMSF = null;
    }

    public void setXMSF(XMultiServiceFactory _xMSF) {
        this.m_xMSF = _xMSF;
    }
}

