/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.drawing;

import com.ivistaportal.solibrary.chart.exceptions.InvalidInputException;
import com.ivistaportal.solibrary.chartservice.SOChartService;
import com.ivistaportal.solibrary.chartservice.SeriesInfo;
import com.ivistaportal.solibrary.drawing.EllipseShape;
import com.ivistaportal.solibrary.drawing.LineShape;
import com.ivistaportal.solibrary.drawing.Shape;
import com.ivistaportal.solibrary.protocols.ChartDiagramProtocol;
import com.ivistaportal.solibrary.protocols.DrawingProtocol;
import com.ivistaportal.solibrary.utils.SOColor;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.chart.XAxisXSupplier;
import com.sun.star.chart.XAxisYSupplier;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;

public class DelimitedShape {
    private XMultiServiceFactory m_MSF = null;
    private boolean m_vertical = false;
    private double m_alignPos;
    private XChartDocument m_xChartDocument;
    private EllipseShape m_ellipseAvg = null;
    private LineShape m_lineHighConfidence = null;
    private LineShape m_lineLowConfidence = null;
    private LineShape m_lineHighDelimiter = null;
    private LineShape m_lineLowDelimiter = null;
    private EllipseShape m_ellipseExternal;
    private double m_externalPoint;
    private double m_avg;
    private double m_highConfidence = Double.MIN_VALUE;
    private double m_lowConfidence = Double.MIN_VALUE;
    private double m_highDelimiter;
    private double m_lowDelimiter;

    public DelimitedShape(XMultiServiceFactory _factory, double _basePoint, double _highDelimiter, double _lowDelimiter, boolean _vertical) {
        this.m_avg = Double.MIN_VALUE;
        this.m_externalPoint = Double.MIN_VALUE;
        this.m_MSF = _factory;
        this.m_avg = _basePoint;
        this.m_highConfidence = _highDelimiter;
        this.m_lowConfidence = _lowDelimiter;
        this.m_vertical = _vertical;
    }

    public DelimitedShape(XMultiServiceFactory _factory, boolean _vertical) {
        this.m_avg = Double.MIN_VALUE;
        this.m_externalPoint = Double.MIN_VALUE;
        this.m_MSF = _factory;
        this.m_vertical = _vertical;
    }

    private EllipseShape ensureShape(double _value, EllipseShape _shape, long _color) throws Exception {
        if (_value != Double.MIN_VALUE && _shape == null) {
            _shape = new EllipseShape(this.m_MSF);
            _shape.setShapeColor((int)_color);
            DrawingProtocol.addShape(_shape, this.m_xChartDocument);
        } else if (_value == Double.MIN_VALUE && _shape != null) {
            this.removeShape(_shape);
            _shape = null;
        }
        return _shape;
    }

    private LineShape ensureShape(double _value, LineShape _shape, long _color) throws Exception {
        if (_value != Double.MIN_VALUE && _shape == null) {
            _shape = new LineShape(this.m_MSF);
            _shape.setLineColor((int)_color);
            DrawingProtocol.addShape(_shape, this.m_xChartDocument);
        } else if (_value == Double.MIN_VALUE && _shape != null) {
            this.removeShape(_shape);
            _shape = null;
        }
        return _shape;
    }

    private void ensureShapes() throws Exception {
        this.m_lineLowConfidence = this.ensureShape(this.m_lowConfidence, this.m_lineLowConfidence, SOColor.RED_COLOR);
        this.m_lineHighConfidence = this.ensureShape(this.m_highConfidence, this.m_lineHighConfidence, SOColor.RED_COLOR);
        this.m_lineLowDelimiter = this.ensureShape(this.m_lowDelimiter, this.m_lineLowDelimiter, SOColor.RED_COLOR);
        this.m_lineHighDelimiter = this.ensureShape(this.m_highDelimiter, this.m_lineHighDelimiter, SOColor.RED_COLOR);
        this.m_ellipseAvg = this.ensureShape(this.m_avg, this.m_ellipseAvg, SOColor.RED_COLOR);
        this.m_ellipseExternal = this.ensureShape(this.m_externalPoint, this.m_ellipseExternal, SOColor.BLUE_COLOR);
    }

    public Double getAvg() {
        return new Double(this.m_avg);
    }

    public Double getExternalPoint() {
        return new Double(this.m_externalPoint);
    }

    public Double getHighConfidence() {
        return new Double(this.m_highConfidence);
    }

    public Double getLowConfidence() {
        return new Double(this.m_lowConfidence);
    }

    private XShape getXAxis(XDiagram _xDiagram) {
        XAxisXSupplier xaxisSupp = ChartDiagramProtocol.getXAxisXSupplier(_xDiagram);
        return DrawingProtocol.getXShape(xaxisSupp.getXAxis());
    }

    private SeriesInfo getXAxisInfo(XDiagram _xDiagram) {
        XAxisXSupplier xaxisSupp = ChartDiagramProtocol.getXAxisXSupplier(_xDiagram);
        XShape xshape = DrawingProtocol.getXShape(xaxisSupp.getXAxis());
        return SOChartService.getSeriesInfo(xshape, false);
    }

    private XShape getYAxis(XDiagram _xDiagram) {
        XAxisYSupplier yaxisSupp = ChartDiagramProtocol.getXAxisYSupplier(_xDiagram);
        return DrawingProtocol.getXShape(yaxisSupp.getYAxis());
    }

    private SeriesInfo getYAxisInfo(XDiagram _xDiagram) {
        XAxisYSupplier yaxisSupp = ChartDiagramProtocol.getXAxisYSupplier(_xDiagram);
        XShape yshape = DrawingProtocol.getXShape(yaxisSupp.getYAxis());
        return SOChartService.getSeriesInfo(yshape, true);
    }

    public void refresh(XChartDocument _xChartDoc, double _alignPos) throws RuntimeException {
        this.m_xChartDocument = _xChartDoc;
        this.m_alignPos = _alignPos;
        try {
            this.ensureShapes();
            if (this.m_ellipseAvg != null) {
                this.updateEllipse(this.m_avg, this.m_ellipseAvg);
                if (this.m_lineHighConfidence != null) {
                    this.updateConfidenceLine(this.m_highConfidence, this.m_lineHighConfidence);
                    if (this.m_lineHighDelimiter != null) {
                        this.updateDelimiterLine(this.m_highDelimiter, this.m_lineHighDelimiter);
                    }
                }
                if (this.m_lineLowConfidence != null) {
                    this.updateConfidenceLine(this.m_lowConfidence, this.m_lineLowConfidence);
                    if (this.m_lineLowDelimiter != null) {
                        this.updateDelimiterLine(this.m_lowDelimiter, this.m_lineLowDelimiter);
                    }
                }
            }
            if (this.m_ellipseExternal != null) {
                this.updateEllipse(this.m_externalPoint, this.m_ellipseExternal);
            }
        }
        catch (Exception ex) {
            new RuntimeException("DelimiterShape refresh fault ", (Object)ex);
        }
    }

    private void removeShape(Shape _shape) {
        DrawingProtocol.removeShape(_shape, this.m_xChartDocument);
    }

    public void setAvg(Double _value) {
        this.m_avg = _value;
    }

    public void setExternalPoint(Double _value) {
        this.m_externalPoint = _value;
    }

    public void setHighConfidence(Double _value) {
        this.m_highConfidence = _value;
        this.m_highDelimiter = this.m_highDelimiter == Double.POSITIVE_INFINITY ? Double.MIN_VALUE : _value;
    }

    public void setLowConfidence(Double _value) {
        this.m_lowConfidence = _value;
        this.m_lowDelimiter = this.m_lowConfidence == Double.NEGATIVE_INFINITY ? Double.MIN_VALUE : _value;
    }

    private void updateConfidenceLine(double _value, LineShape _line) throws InvalidInputException, PropertyVetoException {
        XDiagram xDiagram = this.m_xChartDocument.getDiagram();
        XShape xshape = this.getXAxis(xDiagram);
        XShape yshape = this.getYAxis(xDiagram);
        SeriesInfo axisXInfo = this.getXAxisInfo(xDiagram);
        SeriesInfo axisYInfo = this.getYAxisInfo(xDiagram);
        if (this.m_vertical) {
            int yStartPosLine = _value == Double.POSITIVE_INFINITY ? yshape.getPosition().Y : (_value == Double.NEGATIVE_INFINITY ? yshape.getPosition().Y + yshape.getSize().Height : SOChartService.convertLogical2Visual(yshape, _value, true));
            int alignVisualPos = SOChartService.convertLogical2Visual(xshape, this.m_alignPos, false);
            int xStartPosLine = alignVisualPos + new Double(EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo) / 2).intValue();
            int yEndPosLine = SOChartService.convertLogical2Visual(yshape, this.m_avg, true);
            int lineHeight = yEndPosLine - yStartPosLine;
            _line.setPosition(new Point(xStartPosLine, yStartPosLine));
            _line.setSize(new Size(1, lineHeight));
        } else {
            int xStartPosLine = _value == Double.POSITIVE_INFINITY ? xshape.getPosition().X + xshape.getSize().Width : (_value == Double.NEGATIVE_INFINITY ? xshape.getPosition().X : SOChartService.convertLogical2Visual(xshape, _value, false));
            int alignVisualPos = SOChartService.convertLogical2Visual(yshape, this.m_alignPos, true);
            int yStartPosLine = alignVisualPos + new Double(EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo) / 2).intValue();
            int xEndPosLine = SOChartService.convertLogical2Visual(xshape, this.m_avg, false);
            int lineWidth = xEndPosLine - xStartPosLine;
            _line.setPosition(new Point(xStartPosLine, yStartPosLine));
            _line.setSize(new Size(lineWidth, 1));
        }
    }

    private void updateDelimiterLine(double _value, LineShape _line) throws InvalidInputException, PropertyVetoException {
        int xStartPosLine;
        int yStartPosLine;
        XDiagram xDiagram = this.m_xChartDocument.getDiagram();
        XShape xshape = this.getXAxis(xDiagram);
        XShape yshape = this.getYAxis(xDiagram);
        SeriesInfo axisXInfo = this.getXAxisInfo(xDiagram);
        SeriesInfo axisYInfo = this.getYAxisInfo(xDiagram);
        int lineLength = new Double(EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo) * 4).intValue();
        if (this.m_vertical) {
            yStartPosLine = SOChartService.convertLogical2Visual(yshape, _value, true);
            int alignVisualPos = SOChartService.convertLogical2Visual(xshape, this.m_alignPos, false);
            xStartPosLine = alignVisualPos - new Double((double)EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo) * 1.5).intValue();
            _line.setSize(new Size(lineLength, 1));
        } else {
            xStartPosLine = SOChartService.convertLogical2Visual(xshape, _value, false);
            int alignVisualPos = SOChartService.convertLogical2Visual(yshape, this.m_alignPos, true);
            yStartPosLine = alignVisualPos - new Double((double)EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo) * 1.5).intValue();
            _line.setSize(new Size(1, lineLength));
        }
        _line.setPosition(new Point(xStartPosLine, yStartPosLine));
    }

    private void updateEllipse(double _value, EllipseShape _ellipse) throws InvalidInputException, PropertyVetoException {
        XDiagram xDiagram = this.m_xChartDocument.getDiagram();
        XShape xshape = this.getXAxis(xDiagram);
        XShape yshape = this.getYAxis(xDiagram);
        SeriesInfo axisXInfo = this.getXAxisInfo(xDiagram);
        SeriesInfo axisYInfo = this.getYAxisInfo(xDiagram);
        int height = EllipseShape.getDefaultDotHeight(axisXInfo, axisYInfo);
        _ellipse.setSize(new Size(height, height));
        if (this.m_vertical) {
            _ellipse.setPosition(SOChartService.convertLogical2Visual(xshape, yshape, this.m_alignPos, _value));
        } else {
            _ellipse.setPosition(SOChartService.convertLogical2Visual(xshape, yshape, _value, this.m_alignPos));
        }
    }
}

