/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.progressbar;

import com.ivistaportal.solibrary.protocols.ProgressBarProtocol;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.uno.Exception;

public class ProgressBar {
    private XMultiServiceFactory m_xMSF = null;
    private XStatusIndicator m_SI = null;
    private int m_currValue = 0;
    private int m_maxValue = 0;
    private int m_step = 0;

    public ProgressBar(XMultiServiceFactory _xMSF) throws NullPointerException, Exception {
        if (_xMSF == null) {
            throw new NullPointerException("ProgressBar: MSF is null");
        }
        this.m_xMSF = _xMSF;
        this.m_SI = ProgressBarProtocol.createStatusIndicator(_xMSF);
        if (this.m_SI == null) {
            throw new NullPointerException();
        }
    }

    public void advanceBarByStep() {
        if (this.m_currValue < this.m_maxValue) {
            this.m_currValue += this.m_step;
            if (this.m_currValue > this.m_maxValue) {
                this.m_currValue = this.m_maxValue;
            }
            this.moveBar(this.m_currValue);
        }
    }

    public void autoAdvanceBar() {
        if (this.m_currValue < this.m_maxValue) {
            this.m_currValue += (this.m_maxValue - this.m_currValue) / 2;
            System.out.println("advancing bar to " + this.m_currValue);
            this.moveBar(this.m_currValue);
        }
    }

    public void endBar() {
        if (this.m_SI != null) {
            this.m_SI.end();
        }
        this.m_currValue = this.m_maxValue;
    }

    public void moveBar(int _barVal) {
        if (this.m_SI != null) {
            this.m_SI.setValue(_barVal);
            this.m_currValue = _barVal;
        }
    }

    public void startBar(String _title, int _maxValue) {
        this.startBar(_title, _maxValue, 0);
    }

    public void startBar(String _title, int _maxValue, int _step) {
        if (this.m_SI != null) {
            this.m_SI.reset();
            this.m_SI.start(_title, _maxValue);
            this.m_maxValue = _maxValue;
            this.m_step = _step;
            this.m_currValue = 0;
        }
    }
}

